<#--定义宏递归生成动作列事件和超链接方法-->
<#macro colEvent colList>
    <#list colList as col>
        <#if col.isParent??>
            <@colEvent colList=col.children></@colEvent>
        <#elseif col.eventList?? && col.eventList.isNeedAction?? && col.eventList.isNeedAction!>
            <#--动作列事件-->
            @${col.eventList.eventName!}="${instanceKey!}${col.eventList.eventName?cap_first}"
        </#if>
        <#if col.hyperlinks?? && col.hyperlinks.fileId?? && col.hyperlinks.fileId! != "">
        <#--超链接方法-->
            @${col.field!}CLICK="${instanceKey!}${col.field!}CLICK"
        </#if>
    </#list>
</#macro>
<div v-show="!${instanceKey!}Hidden">
    <h-table
            theme-name="${styleSchemeClassName!}"
            :props="${instanceKey!}PropsData"
            :inner-styles="${instanceKey!}InnerStyles"
            <#--列表loading-->
            v-loading="${instanceKey!}TableLoading"
            <#--表格高度（分页）-->
            <#if isPagination?? && isPagination>
                :height="'calc(100% - 53px)'"
            <#else >
                :height="'100%'"
            </#if>
            <#--列表合计-->
            <#if columnSummary?? && columnSummary>
                :summary-method="${instanceKey!}ColumnSummaryEvent"
                show-summary
            </#if>
            <#--选择项变化-->
            <#if crossPageSelect?? && crossPageSelect>
                @select="${instanceKey!}SelectRow" @select-all="${instanceKey!}SelectAll"
            <#else>
                @selection-change="${instanceKey!}SelectRow"
            </#if>
            <#--是否复选框只能选择一个-->
            ref="${instanceKey!}TableRef"
            <#if isRadio?? && isRadio!>
                 @select="${instanceKey!}Select" @select-all="${instanceKey!}SelectAll"
            </#if>
            <#--行单选，选中后该行高亮-->
            <#if isSingleSelect?? && isSingleSelect!>
                highlight-current-row @current-change="${instanceKey!}SingleSelectRow"
            </#if>
            <#--单双击耦合 增加额外计算时间方法-->
            <#if (colClick?? && colClick!) && dblClick?? && dblClick!>
                @row-click="${instanceKey!}ColClickFront"
                @row-dblclick="${instanceKey!}DblClickFront"
            <#else>
                <#--行单击事件-->
                <#if colClick?? && colClick>
                    @row-click="${instanceKey!}ColClick"
                </#if>
                <#--行双击事件-->
                <#if dblClick?? && dblClick>
                    @row-dblclick="${instanceKey!}DblClick"
                </#if>
            </#if>
            <#--单元格单击事件-->
            <#if cellClick?? && cellClick>
                @cell-click="${instanceKey!}CellClickInfo"
                :cell-class-name="${instanceKey!}CellClassNAme"
            </#if>
            <#if columnStyle?? && columnStyle>
                :cell-style="${instanceKey!}CellStyle"
            </#if>
            <#--排序改变-->
            <#if isSortChange?? && isSortChange>
                @sort-change="${instanceKey!}SortChange"
            </#if>
            <#--合并表头-->
            <#if mergeHead?? && mergeHead>
                :header-cell-style="${instanceKey!}HandMethod"
            </#if>
            <#if showHead?? && !showHead>
                :show-header="${instanceKey!}ShowHeader"
            </#if>
            <#--表格合并列-->
            <#if mergeCol?? && mergeCol>
                :span-method="${instanceKey!}MergeCol"
            </#if>
            <@colEvent colList=tableShowFields></@colEvent>
            <#--循环生成超链接事件-->
            <#list needOperations as item>
                <#if item.isEvent?? && item.isEvent>
                    @${item.eventName}="${instanceKey!}${item.eventName?cap_first}"
                </#if>
            </#list>
    >
    </h-table>
    <#--分页组件-->
    <#if isPagination?? && isPagination>
        <div class="page">
            <el-pagination
                background
                @size-change="${instanceKey!}HandleSizeChange"
                @current-change="${instanceKey!}HandleCurrentChange"
                :page-size="${ListQuery!}.size"
                <#if size?? && size! lt 10>
                :page-sizes="[${size?c!}, 10, 20, 50]"
                <#elseif size?? && size! gt 10 && size! lt 20>
                :page-sizes="[10, ${size?c!}, 20, 50]"
                <#elseif size?? && size! gt 20 && size! lt 50>
                :page-sizes="[10, 20, ${size?c!}, 50]"
                <#elseif size?? && size! gt 50>
                :page-sizes="[10, 20, 50, ${size?c!}]"
                </#if>
                <#if (layout??)>
                    :layout="${instanceKey!}Layout"
                </#if>
                :total="${TableTotal!}"
                :current-page.sync="${instanceKey!}CurrentPage">
            </el-pagination>
        </div>
    </#if>
</div>
