/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.cascade;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.file.VuePathService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;

@ClientKind(kind="com.jxdinfo.WebPage.cascade")
public class VueCascadeImpl
implements ResourceCascadeVisitor {
    public static final String KIND = "com.jxdinfo.WebPage.cascade";
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    private final ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextHolder.getBean(ResourceCascadeService.class);
    private final FilePublishService filePublishService = (FilePublishService)SpringContextHolder.getBean(FilePublishService.class);
    private final PageInfoService pageInfoService = (PageInfoService)SpringContextHolder.getBean(PageInfoService.class);

    public void cascadeEdit(BaseFile baseFile) throws LcdpException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldfilePath = this.getOldVuePath(baseFile.getId(), strategy);
        String newFilePath = this.getNeWVuePath(baseFile.getId(), baseFile.getName(), strategy);
        File newFile = new File(newFilePath);
        File oldFile = new File(oldfilePath);
        if (FileUtils.exists((File)oldFile) && !FileUtils.exists((File)newFile)) {
            this.fixName(oldFile, newFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String parentPath = this.getMetaPath(parentId);
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File vueFrom = new File(oldVueFilePath);
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getVueCodePath(strategy)})});
        File vueTo = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (FileUtils.exists((File)vueFrom)) {
            if (!FileUtils.exists((File)vueTo)) {
                FileUtils.forceMkdir((File)vueTo);
            }
            if (newName != null && !newName.isEmpty()) {
                vueTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + this.formDesignProperties.getPageSuffix(), rootPath));
                if (!FileUtils.exists((File)vueTo)) {
                    try {
                        FileUtils.copyFile((File)vueFrom, (File)vueTo, (boolean)false);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, vueFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.copyFileToDirectory((File)vueFrom, (File)vueTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_COPY_FAIL, vueFrom.getAbsolutePath());
                }
            }
        }
        this.copyAncestor(id, newId);
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String parentPath = this.getMetaPath(parentId);
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File vueFrom = new File(oldVueFilePath);
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getVueCodePath(strategy)})});
        File vueTo = new File(this.relativeToAbsolute(parentPath, rootPath));
        if (FileUtils.exists((File)vueFrom)) {
            if (!FileUtils.exists((File)vueTo)) {
                FileUtils.forceMkdir((File)vueTo);
            }
            if (newName != null && !newName.isEmpty()) {
                vueTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + this.formDesignProperties.getPageSuffix(), rootPath));
                if (!FileUtils.exists((File)vueTo)) {
                    try {
                        FileUtils.moveFile((File)vueFrom, (File)vueTo);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, vueFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.moveFileToDirectory((File)vueFrom, (File)vueTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, vueFrom.getAbsolutePath());
                }
            }
        }
    }

    public void cascadeDelete(String id) throws LcdpException {
        File file;
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        if (VfgModeTool.isModularization()) {
            this.deleteImportVue(id);
        }
        if (FileUtils.exists((File)(file = new File(oldVueFilePath)))) {
            try {
                FileUtils.forceDelete((File)file);
                this.resourceCascadeService.deleteVuePublishFile(id);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldVueFilePath);
            }
        }
    }

    String getOldVuePath(String id, Integer strategy) throws LcdpException {
        String oldVuePath = this.fileMappingService.getFormatPath(id);
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getVueCodePath(strategy)})});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldVuePath + this.formDesignProperties.getPageSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNeWVuePath(String id, String pageName, Integer strategy) throws LcdpException {
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getVueCodePath(strategy)})});
        String newVuePath = FileUtil.systemPath((String[])new String[]{this.fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newVuePath + this.formDesignProperties.getPageSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    void copyAncestor(String oidId, String newId) throws IOException {
        String oldPublishPath = this.getPublishVersionFilePathById(oidId);
        String oldFilePath = this.getLastFileVersionFilePathById(oidId);
        File oldPublish = new File(oldPublishPath);
        File oldFile = new File(oldFilePath);
        File toPublish = new File(this.getPublishVersionFilePathById(newId));
        File toFile = new File(this.getLastFileVersionFilePathById(newId));
        if (FileUtils.exists((File)oldPublish) && FileUtils.exists((File)oldFile)) {
            FileUtils.copyFile((File)oldPublish, (File)toPublish, (boolean)false);
            FileUtils.copyFile((File)oldFile, (File)toFile, (boolean)false);
        }
    }

    String getPublishVersionFilePathById(String id) {
        return FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), "/publish/version/ancestor", id.replace("_", "/"), "/last_publish.version"});
    }

    String getLastFileVersionFilePathById(String id) {
        return FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), "/publish/version/ancestor", id.replace("_", "/"), "/last_file.version"});
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }

    private void deleteImportVue(String id) throws LcdpException {
        VuePathService vuePathService = this.pathStrategy.vuePathService();
        String mainJsPath = FileUtil.posixPath((String[])new String[]{vuePathService.getFrontProjectPath(), "src", "main.js"});
        try {
            String mainContent = FileUtils.readFileToString((File)new File(mainJsPath), (Charset)StandardCharsets.UTF_8);
            String moduleRelatePath = this.fileMappingService.getFormatParentPath(id);
            PageInfo pageInfo = (PageInfo)this.pageInfoService.get(id);
            String pageName = pageInfo.getName();
            String vueRelativePath = FileUtil.posixPath((String[])new String[]{vuePathService.getVueCodePath(null), moduleRelatePath, pageName}).replace("/src", "");
            String vueAbsolutePath = FileUtil.posixPath((String[])new String[]{vuePathService.prefix(), moduleRelatePath, pageName});
            String onlyVar = FileUtil.systemPath((String[])new String[]{FileUtil.posixPath((String[])new String[]{moduleRelatePath, pageName})}).replace(File.separator, "_");
            String importVue = String.format("const %s = () => import('.%s')", onlyVar, vueRelativePath);
            String constructVue = String.format("'%s': %s", vueAbsolutePath, onlyVar);
            String importVueRemove = VueCascadeImpl.parseAndRemove(mainContent, importVue, "/* @import vue start */", "/* @import vue end */", ";");
            String constructRemove = VueCascadeImpl.parseAndRemove(importVueRemove, constructVue, "/* @construct vue start */", "/* @construct vue end */", ",");
            this.filePublishService.writeStringToFile(constructRemove, mainJsPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String parseAndRemove(String str, String element, String start, String end, String split) {
        if (ToolUtil.isEmpty((Object)str) || !str.contains(element.trim())) {
            ToolUtil.getLogger(ToolUtil.class).info("\u6e90\u5b57\u7b26\u4e0d\u5b58\u5728\u6216\u5f85\u5220\u9664\u5143\u7d20\u4e0d\u5b58\u5728\uff01");
            return str;
        }
        int startIndex = str.indexOf(start) + start.length();
        int endIndex = str.indexOf(end);
        String content = str.substring(startIndex, endIndex).trim();
        String[] elements = content.split(split);
        HashSet<String> elementList = new HashSet<String>();
        for (String e : elements) {
            String trimmedElement = e.trim();
            if (trimmedElement.isEmpty()) continue;
            elementList.add(trimmedElement);
        }
        elementList.remove(element);
        StringBuilder updatedContent = new StringBuilder();
        for (String e : elementList) {
            updatedContent.append(e).append(String.format("%s\n", split));
        }
        str = String.format("%s\n%s%s", str.substring(0, startIndex), updatedContent, str.substring(endIndex));
        return str;
    }
}

