/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.cascade;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.publishrecord.service.ISysPublishRecordService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.util.CascadeClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.formdesign.publish.service.ResourcePublishService;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@ClientKind(kind="com.jxdinfo.Module.cascade")
public class ModuleCascadeImpl
implements ResourceCascadeVisitor {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final ResourcePublishService resourcePublishService = (ResourcePublishService)SpringContextHolder.getBean(ResourcePublishService.class);
    private final ISysResManageService resManageService = (ISysResManageService)SpringContextHolder.getBean(ISysResManageService.class);
    private final ISysPublishRecordService sysPublishRecordService = (ISysPublishRecordService)SpringContextHolder.getBean(ISysPublishRecordService.class);
    private final SysQuoteRelationService sysQuoteRelationService = (SysQuoteRelationService)SpringContextHolder.getBean(SysQuoteRelationService.class);
    private final PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    private final ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextHolder.getBean(ResourceCascadeService.class);
    public static final String KIND = "com.jxdinfo.Module.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getVueCodePath(strategy)})});
        String path = this.getMetaPath(baseFile.getId());
        String parentPath = this.getMetaPath(baseFile.getParentId());
        File newFile = new File(this.relativeToAbsolute(parentPath + File.separator + baseFile.getName(), rootPath));
        File oldFile = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        this.moduleEdit(oldFile, newFile);
        String apiRootPath = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getFrontApiPath()});
        String apiPath = this.getMetaPath(baseFile.getId());
        String apiParentPath = this.getMetaPath(baseFile.getParentId());
        File apiNewFile = new File(this.relativeToAbsolute(apiParentPath + File.separator + baseFile.getName(), apiRootPath));
        File apiOldFile = new File(FileUtil.systemPath((String[])new String[]{apiRootPath, apiPath}));
        this.moduleEdit(apiOldFile, apiNewFile);
        String extendRootPath = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getExtendScriptPath()});
        File extendnewFile = new File(extendRootPath);
        this.iteratorDirectory(extendnewFile, baseFile, this.fileMappingService.getFileName(baseFile.getId()));
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniModule")).cascadeEdit(baseFile);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileModule")).cascadeEdit(baseFile);
        String oldbackJavaPath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath(), this.fileMappingService.getFormatPath(baseFile.getId())});
        File oldJavaPath = new File(oldbackJavaPath);
        String newbackJavaPath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath(), this.getMetaPath(baseFile.getParentId()), baseFile.getName()});
        File newJavaPath = new File(newbackJavaPath);
        this.moduleEdit(oldJavaPath, newJavaPath);
    }

    public void iteratorDirectory(File extendnewFile, BaseFile baseFile, String oldName) {
        if (ToolUtil.isNotEmpty((Object)extendnewFile) && ToolUtil.isNotEmpty((Object)FileUtils.listFiles((File)extendnewFile))) {
            for (File file : FileUtils.listFiles((File)extendnewFile)) {
                if (!FileUtils.isDirectory((File)file)) continue;
                if (file.getName().equals(oldName)) {
                    File newFile = new File(file.getParent() + File.separator + baseFile.getName());
                    if (FileUtils.exists((File)newFile)) continue;
                    this.fixName(file, newFile);
                    continue;
                }
                this.iteratorDirectory(file, baseFile, oldName);
            }
        }
    }

    public void moduleEdit(File oldFile, File newFile) {
        if (FileUtils.exists((File)oldFile) && !FileUtils.exists((File)newFile)) {
            this.fixName(oldFile, newFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getVueCodePath(strategy)})});
        String path = this.getMetaPath(id);
        String parentPath = this.getMetaPath(parentId);
        File from = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
        if (parentPath.contains(path) && parentPath.length() > path.length()) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (FileUtils.exists((File)from)) {
            if (!FileUtils.exists((File)to)) {
                FileUtils.forceMkdir((File)to);
            }
            FileUtils.copyDirectoryToDirectory((File)from, (File)to);
        }
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniModule")).cascadeCopy(id, newId, newName, parentId);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileModule")).cascadeCopy(id, newId, newName, parentId);
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getVueCodePath(strategy)})});
        String parentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, parentPath, rootPath, newName, parentId);
        String apiRootPath = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getFrontApiPath()});
        String apiParentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, apiParentPath, apiRootPath, newName, parentId);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniModule")).cascadeMove(id, newName, parentId);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileModule")).cascadeMove(id, newName, parentId);
        String backJavaPath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath(), this.fileMappingService.getFormatPath(id)});
        File javaFrom = new File(backJavaPath);
        File javaTo = new File(this.relativeToAbsolute(parentPath, this.pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath()));
        if (FileUtils.exists((File)javaFrom)) {
            if (!FileUtils.exists((File)javaTo)) {
                FileUtils.forceMkdir((File)javaTo);
            }
            if (!FileUtils.exists((File)(javaTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName, this.pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath()))))) {
                FileUtils.moveDirectory((File)javaFrom, (File)javaTo);
            } else {
                FileUtils.moveFileToDirectory((File)javaFrom, (File)javaTo, (boolean)false);
            }
        }
    }

    public void moveFrontFile(String id, String parentPath, String rootPath, String newName, String parentId) throws LcdpException, IOException {
        String path = this.getMetaPath(id);
        File from = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
        if (parentPath.contains(path) && (id.equals(parentId) || this.copyCheck(id, parentId))) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (FileUtils.exists((File)from)) {
            if (!FileUtils.exists((File)to)) {
                FileUtils.moveDirectory((File)from, (File)to);
            } else {
                FileUtils.moveDirectoryToDirectory((File)from, (File)to, (boolean)false);
            }
        }
    }

    private boolean copyCheck(String id, String parentId) throws IOException, LcdpException {
        BaseFile baseFile = this.fileMappingService.getPageInfoById(parentId);
        if (ToolUtil.isNotEmpty((Object)baseFile) && !"#".equals(baseFile.getParentId())) {
            if (id.equals(baseFile.getId())) {
                return true;
            }
            return this.copyCheck(id, baseFile.getParentId());
        }
        return false;
    }

    public void cascadeDelete(String id) throws LcdpException, IOException {
        String saveJavaFilePathPrefix;
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String rootPath = FileUtil.systemPath((String[])new String[]{this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getVueCodePath(strategy)})});
        if (ToolUtil.isEmpty((Object)id)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        String path = this.getMetaPath(id);
        File f = new File(this.relativeToAbsolute(path, rootPath));
        this.moduleDelete(f);
        String apiRootPath = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getFrontApiPath()});
        File apif = new File(this.relativeToAbsolute(path, apiRootPath));
        this.moduleDelete(apif);
        String extendRootPath = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getExtendScriptPath()});
        this.extendModuleDelete(extendRootPath, path);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("UniModule")).cascadeDelete(id);
        CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind("MobileModule")).cascadeDelete(id);
        File code = new File(FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), path}));
        this.iteratorFile(code);
        String backProjectPath = this.pathStrategy.javaPathService().backProjectJava(new String[0]).getLocalPath();
        File bf = new File(this.relativeToAbsolute(path, backProjectPath));
        if (FileUtils.exists((File)bf)) {
            try {
                FileUtils.forceDelete((File)bf);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, bf.getAbsolutePath());
            }
        }
        if (FileUtils.exists((File)new File(saveJavaFilePathPrefix = this.pathStrategy.javaPathService().backProjectJava(new String[]{"bpmvisitor", path}).getLocalPath().toLowerCase()))) {
            FileUtils.forceDelete((File)new File(saveJavaFilePathPrefix));
        }
        this.resourceCascadeService.deleteModulePublishFile(id);
    }

    private void moduleDelete(File f) throws LcdpException {
        if (FileUtils.exists((File)f)) {
            try {
                FileUtils.forceDelete((File)f);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, f.getAbsolutePath());
            }
        }
    }

    private void extendModuleDelete(String rootPath, String path) throws LcdpException {
        String jsPath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendJavaScriptPath(), path});
        this.moduleDelete(new File(jsPath));
        String vuePath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendVuePath(), path});
        this.moduleDelete(new File(vuePath));
        String cssPath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendCssScriptPath(), path});
        this.moduleDelete(new File(cssPath));
    }

    private void iteratorFile(File file) throws IOException, LcdpException {
        block3: {
            JSONObject dataModelJson;
            List operationList;
            String type;
            block5: {
                block4: {
                    if (!FileUtils.exists((File)file)) break block3;
                    if (!FileUtils.isDirectory((File)file)) break block4;
                    File[] files = FileUtils.listFiles((File)file);
                    if (files == null) break block3;
                    for (File childFile : files) {
                        this.iteratorFile(childFile);
                    }
                    break block3;
                }
                if (!file.getName().endsWith(".meta")) break block3;
                JSONObject jsonObject = null;
                jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                String id = jsonObject.get((Object)"id").toString();
                type = jsonObject.get((Object)"type").toString();
                CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind(type)).cascadeDelete(id);
                if (!"WebPage".equals(type) && !"MobilePage".equals(type) && !"UniPage".equals(type)) break block5;
                this.sysQuoteRelationService.deleteQuoteRelationByReferResid(id);
                this.resourcePublishService.deleteMenu(id);
                Long resourceId = this.sysPublishRecordService.getResourceIdBySourceId(id);
                if (!ToolUtil.isNotEmpty((Object)resourceId)) break block3;
                this.resManageService.deleteResource(String.valueOf(resourceId));
                break block3;
            }
            if ("DataModel".equals(type) && ToolUtil.isNotEmpty((Object)(operationList = ToolUtil.castListMap((Object)(dataModelJson = JSONObject.parseObject((String)FileUtils.readFileToString((File)new File(file.getAbsolutePath().replace(".meta", "")), (String)"UTF-8"))).get((Object)"operations"), String.class, Object.class)))) {
                for (Map map : operationList) {
                    Long resourceId = this.sysPublishRecordService.getResourceIdBySourceId((String)map.get("id"));
                    if (!ToolUtil.isNotEmpty((Object)resourceId)) continue;
                    this.resManageService.deleteResource(String.valueOf(resourceId));
                }
            }
        }
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }
}

