${exegesisResult!}
<#if componentName?? && componentName != "">
    const { columns: list, filename } = exportOpts;
    const tableData = [];
    const tableField = [];
    // 根据导出设置列获取要导出的真正的列
    function getExportCols(cols) {
    cols.forEach((col) => {
    if (col.children && col.children.length > 0) {
    getExportCols(col.children);
    } else {
    tableData.push(col.label);
    tableField.push(col.prop);
    }
    });
    }
    list.forEach((item) => {
    if (item.children && item.children.length > 0) {
    getExportCols(item.children);
    } else {
    tableData.push(item.label);
    tableField.push(item.prop);
    }
    });
    const columns = [];
    for (let i = 0; i < tableData.length; i++) {
    const excelCol = {};
    excelCol.key = tableField[i];
    excelCol.width = 30;
    columns.push(excelCol);
    }
    const Excel = require('exceljs');
    const workbook = new Excel.Workbook();
    const worksheet = workbook.addWorksheet('sheet1');
    const fileName = (filename || 'data') + '.xlsx';
    workbook.created = new Date();
    workbook.modified = new Date();
    worksheet.columns = columns;

    let maxLevel = 1;
    const realTableHead = [];
    const realColArray = [];
    const getRealHeadAndCol = function (arr) {
    arr.forEach((child) => {
    if (child.children && child.children.length > 0) {
    getRealHeadAndCol(child.children);
    child.colspan = child.children.reduce((prev, cur) => prev + (cur.colspan || 1), 0);
    }
    realTableHead.push({
    title: child.label,
    prop: child.prop,
    level: child.level || 1,
    rowspan: 1,
    colspan: child.colspan || 1,
    ...(child.align && child.align !== 'noConfig' ? { horizontal: child.align } : { horizontal: 'center' })
    });
    if (!child.prop) return;
    const currentIndex = tableField.indexOf(child.prop);
    const letter = excelDownloadForArea(currentIndex);
    realColArray.push({
    letter,
    prop: child.prop,
    length: 0,
    dataType: dataColumns.filter((item) => item.field === child.prop)[0].dataType || 'string',
    ...(child.align && child.align !== 'noConfig' ? { horizontal: child.align } : { horizontal: 'center' })
    });
    });
    };
    // 获取需要导出的列配置项
    getRealHeadAndCol(list);
    // 获取表格最大层级
    for (let i = 0; i < realTableHead.length; i++) {
    if (realTableHead[i].level > maxLevel) {
    maxLevel = realTableHead[i].level;
    }
    }
    // 处理表头占用单元格以及样式
    for (let i = 0; i < realTableHead.length; i++) {
    if (realTableHead[i].prop) {
    realTableHead[i].rowspan = maxLevel - realTableHead[i].level + 1;
    }
    }
    const excelCell = [];
    const rows = [];
    for (let i = 0; i < tableField.length; i++) {
    for (let j = 0; j < maxLevel; j++) {
    const cell = { xAxis: i, yAxis: j, isEdit: false };
    excelCell.push(cell);
    }
    }
    for (let i = 0; i < maxLevel; i++) {
    let x = 0;
    const row = [];
    for (let j = 0; j < realTableHead.length; j++) {
    const index = excelCell.findIndex(function (value, index, arr) {
    return value.isEdit === false && value.yAxis === i;
    });
    if (index !== -1) {
    x = excelCell.find(function (value, index, arr) {
    return value.isEdit === false && value.yAxis === i;
    }).xAxis;
    }
    if (realTableHead[j].level - 1 === i) {
    const startArea = excelDownloadForArea(x) + (1 + i);
    const endArea = excelDownloadForArea(x + realTableHead[j].colspan - 1) + (realTableHead[j].rowspan + i);
    for (let k = x; k < x + realTableHead[j].colspan; k++) {
    for (let m = i; m < realTableHead[j].rowspan + i; m++) {
    excelCell.find(function (value, index, arr) {
    return value.xAxis === k && value.yAxis === m;
    }).isEdit = true;
    }
    }
    while (row.length < x) {
    row.push('');
    }
    row[x] = realTableHead[j].title;
    realTableHead[j].merge = startArea + ':' + endArea;
    }
    }
    rows.push(row);
    }
    worksheet.insertRows(1, rows);
    for (let j = 0; j < realTableHead.length; j++) {
    worksheet.mergeCells(realTableHead[j].merge);
    const headCell = worksheet.getCell(realTableHead[j].merge.split(':')[0]);
    headCell.alignment = {
    vertical: 'middle',
    horizontal: realTableHead[j].horizontal
    };
    headCell.fill = {
    type: 'pattern',
    pattern: 'solid',
    fgColor: { argb: 'FFBFBFBF' },
    bgColor: { argb: 'FFBFBFBF' }
    };
    headCell.border = {
    top: { style: 'thin' },
    left: { style: 'thin' },
    bottom: { style: 'thin' },
    right: { style: 'thin' }
    };
    }
    for (let i = 0; i < realColArray.length; i++) {
    for (let j = maxLevel + 1; j < 1000; j++) {
    // 设置1000行样式
    worksheet.getCell(realColArray[i].letter + j).alignment = { horizontal: realColArray[i].horizontal };
    if (realColArray[i].dataType === 'date') {
    const cell = worksheet.getCell(realColArray[i].letter + j);
    cell.value = cell.value !== null ? cell.value.substr(0, realColArray[i].length) : null;
    }
    }
    }
    // 调用exceljs导出方法
    for (let i = 0; i < realColArray.length; i++) {
    for (let j = maxLevel + 1; j < 1000; j++) {
    worksheet.getCell(realColArray[i].letter + j).alignment = { horizontal: realColArray[i].horizontal };
    if (realColArray[i].dataType === 'date') {
    worksheet.getCell(realColArray[i].letter + j).dataValidation = {
    type: 'date',
    operator: 'between',
    showErrorMessage: true,
    allowBlank: true,
    formulae: [new Date(1900, 1, 1), new Date(2100, 1, 1)],
    showInputMessage: true,
    promptTitle: '日期',
    prompt: '请输入日期格式数据'
    };
    } else if (realColArray[i].dataType === 'number' || realColArray[i].dataType === 'int' || realColArray[i].dataType === 'double' || realColArray[i].dataType === 'long') {
    worksheet.getCell(realColArray[i].letter + j).dataValidation = {
    type: 'decimal',
    allowBlank: true,
    showErrorMessage: true,
    showInputMessage: true,
    promptTitle: '数字',
    prompt: self.hussar_t({key: 'vfg.pleaseEnterTheDataInNumericFormat', fallbackStr: '请输入数字格式数据'})
    };
    }
    }
    }
    <#if showConfigItemInfos??>
        <#list showConfigItemInfos! as item>
            const dict${item_index} = [];
            const ${item.importName!}Obj${item_index} = {
            inValues: '',
            typeName: '${item.dictType!}',
            ${item.queryObjectAttr!}
            };
            const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
            HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
            });
            const data${item_index} = res${item_index}.data;
            <#if item.tableFieldWhere?? && item.tableFieldWhere != "" && item.mappingRelates??>
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                if (data${item_index}.data && data${item_index}.data.length > 0) {
                <#list item.mappingRelates! as mapping>
                    const ${mapping.relateField} = [];
                    for (let i = 0; i < data${item_index}.data.length; i++) {
                    ${mapping.relateField}.push(data${item_index}.data[i].${mapping.relateField});
                    }
                    dict${item_index}[${mapping_index}] = ['"' + ${mapping.relateField}.join(",") + '"'];
                </#list>
                }
                } else {
                HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.DatadisplayFailed', fallbackStr: '数据展示数据请求失败'}), 'error');
                }
                <#list item.mappingRelates! as mapping>
                    const field${item_index}${mapping_index} = '${mapping.field!}';
                    const index${item_index}${mapping_index} = tableField.indexOf(field${item_index}${mapping_index});
                    const letter${item_index}${mapping_index} = excelDownloadForArea(index${item_index}${mapping_index});
                </#list>
                for (let i = maxLevel + 1; i < 1000; i++) {
                <#list item.mappingRelates! as mapping>
                    if (letter${item_index}${mapping_index}) {
                        worksheet.getCell(letter${item_index}${mapping_index} + i).dataValidation = {
                        type: 'list',
                        allowBlank: true,
                        formulae: dict${item_index}[${mapping_index}]
                        };
                    }
                </#list>
                }
            <#elseif item.tableFieldWhere?? && item.tableFieldWhere != "" && item.dictType??>
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index} && data${item_index}.length > 0) {
                const dictLabel${item_index} = [];
                for (let i = 0; i < data${item_index}.length; i++) {
                dictLabel${item_index}.push(data${item_index}[i].label);
                }
                dict${item_index}[0] = ['"' + dictLabel${item_index}.join(",") + '"'];
                } else {
                HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.DatadisplayFailed', fallbackStr: '数据展示数据请求失败'}), 'error');
                }
                const field${item_index} = '${item.tableFieldWhere!}';
                const index${item_index} = tableField.indexOf(field${item_index});
                const letter${item_index} = excelDownloadForArea(index${item_index});
                if (letter${item_index}) {
                    for (let i = maxLevel + 1; i < 1000; i++) {
                        worksheet.getCell(letter${item_index} + i).dataValidation = {
                            type: 'list',
                            allowBlank: true,
                            formulae: dict${item_index}[0]
                        };
                    }
                }
            </#if>
        </#list>
    <#elseif translateInfo??>
        <#list translateInfo! as item>
            const dict${item_index} = [];
            const ${item.importName!}Obj${item_index} = {
            inValues: '',
            typeName: '${item.dictType!}',
            ${item.queryObjectAttr!}
            };
            const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
            HussarRouter.showMsg(self, "数据请求异常", 'error');
            });
            const data${item_index} = res${item_index}.data;
            <#if item.tableFieldWhere?? && item.tableFieldWhere != "" && item.mappingRelates??>
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                if (data${item_index}.data && data${item_index}.data.length > 0) {
                <#list item.mappingRelates! as mapping>
                    const ${mapping.relateField} = [];
                    for (let i = 0; i < data${item_index}.data.length; i++) {
                    ${mapping.relateField}.push(data${item_index}.data[i].${mapping.relateField});
                    }
                    dict${item_index}[${mapping_index}] = ['"' + ${mapping.relateField}.join(",") + '"'];
                </#list>
                }
                } else {
                HussarRouter.showMsg(self, "数据展示数据请求失败", 'error');
                }
                <#list item.mappingRelates! as mapping>
                    const field${item_index}${mapping_index} = '${item.relateTableFieldWhere!}';
                    const index${item_index}${mapping_index} = tableField.indexOf(field${item_index}${mapping_index});
                    const letter${item_index}${mapping_index} = excelDownloadForArea(index${item_index}${mapping_index});
                </#list>
                for (let i = maxLevel + 1; i < 1000; i++) {
                <#list item.mappingRelates! as mapping>
                    if (letter${item_index}${mapping_index}) {
                        worksheet.getCell(letter${item_index}${mapping_index} + i).dataValidation = {
                        type: 'list',
                        allowBlank: true,
                        formulae: dict${item_index}[${mapping_index}]
                        };
                    }
                </#list>
                }
            <#elseif item.tableFieldWhere?? && item.tableFieldWhere != "" && item.dictType??>
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index} && data${item_index}.length > 0) {
                const dictLabel${item_index} = [];
                for (let i = 0; i < data${item_index}.length; i++) {
                dictLabel${item_index}.push(data${item_index}[i].label);
                }
                dict${item_index}[0] = ['"' + dictLabel${item_index}.join(",") + '"'];
                } else {
                HussarRouter.showMsg(self, "数据展示数据请求失败", 'error');
                }
                const field${item_index} = '${item.relateTableFieldWhere!}';
                const index${item_index} = tableField.indexOf(field${item_index});
                const letter${item_index} = excelDownloadForArea(index${item_index});
                if (letter${item_index}) {
                    for (let i = maxLevel + 1; i < 1000; i++) {
                        worksheet.getCell(letter${item_index} + i).dataValidation = {
                            type: 'list',
                            allowBlank: true,
                            formulae: dict${item_index}[0]
                        };
                    }
                }
            </#if>
        </#list>
    </#if>
    workbook.xlsx.writeBuffer().then(function (buffer) {
    saveAs(new Blob([buffer], {
    type: 'application/octet-stream'
    }), fileName);
    });
</#if>