<#macro conditionList cList>
    <#list cList! as item>
        {
            <#if item.children?? && (item.children?size > 0) >
            children:[
                <@conditionList cList=item.children!></@conditionList>
            ],
            <#else>
            <#list allFields as fieldItem>
                <#if fieldItem.id == item.fromModelField>
                "name": "${fieldItem.name}",
                </#if>
            </#list>
            "symbol": "${item.symbol}",
            "queryAttrName": "${item.queryAttrName!}",
            </#if>
            "match": "${item.connect!}",
        },
    </#list>
</#macro>

const queryConditionsFields = [
<#if queryConditions?? && queryConditions.fields?? && (queryConditions.fields?size > 0) >
    <@conditionList cList=queryConditions.fields!></@conditionList>
</#if>
<#if incrementQueryConditions?? && incrementQueryConditions.fields?? && (incrementQueryConditions.fields?size > 0) >
    <@conditionList cList=incrementQueryConditions.fields!></@conditionList>
</#if>
];
return getQueryConditionsResult({
    queryConditionsFields,
    params,
    filterConfig: self.${instanceKey!}PropsData.filterConfig,
<#if customView?? && customView>
    viewFilters: self.${instanceKey!}PropsData.selectedView.filters
</#if>
});