<#macro tableHead>
    for (let i = 0; i < realTableHead.length; i++){
        if (realTableHead[i].field){
            realTableHead[i].rowspan = maxLevel - realTableHead[i].level + 1;
        }
    }
    const excelCell = [];
    const rows = [];
    for (let i = 0;i < tableField.length; i++){
        for (let j = 0; j < maxLevel; j++){
            const cell = {"xAxis":i,"yAxis":j,isEdit:false};
            excelCell.push(cell);
        }
    }
    for (let i = 0;i < maxLevel; i++){
        let x = 0;
        const row = [];
        for (let j=0;j < realTableHead.length; j++){
            const index = excelCell.findIndex(function(value, index, arr) {
                return value.isEdit === false && value.yAxis === i;
            });
            if (index !== -1) {
                x = excelCell.find(function(value, index, arr) {    
                    return value.isEdit === false && value.yAxis === i;
                }).xAxis;
            }
            if ( realTableHead[j].level - 1 === i){
                const startArea = excelDownloadForArea(x) + (1 + i);
                const endArea = excelDownloadForArea(x + realTableHead[j].colspan - 1) + (realTableHead[j].rowspan + i);
                for (let k = x; k < x + realTableHead[j].colspan; k++){
                    for (let m = i;m < realTableHead[j].rowspan + i; m++){
                        excelCell.find(function(value, index, arr) {
                            return value.xAxis === k && value.yAxis === m;
                        }).isEdit = true;
                    }
                }
                while (row.length < x){
                    row.push("");
                }
                row[x] = realTableHead[j].title;
    realTableHead[j].merge = startArea + ":" + endArea;
            }
        }
        rows.push(row);
    }
    worksheet.insertRows(1, rows);
    for (let j=0;j < realTableHead.length; j++){
        worksheet.mergeCells(realTableHead[j].merge);
        const headCell = worksheet.getCell(realTableHead[j].merge.split(":")[0]);
        headCell.alignment = {
            vertical: 'middle',
            horizontal: realTableHead[j].horizontal
        };
        headCell.fill = {
            type: 'pattern',
            pattern: 'solid',
            fgColor: { argb: 'FFBFBFBF'},
            bgColor: { argb: 'FFBFBFBF' }
        };
        headCell.border = {
            top: {style:'thin'},
            left: {style:'thin'},
            bottom: {style:'thin'},
            right: {style:'thin'}
        };
    }
    for (let i = 0; i < realColArray.length; i++){
        for (let j = maxLevel + 1; j < self.${instanceKey!}TableTotal + 100; j++) { // 设置行样式
            worksheet.getCell(realColArray[i].letter + j).alignment = { horizontal: realColArray[i].horizontal };
            if (realColArray[i].dataType === "date"){
                const cell = worksheet.getCell(realColArray[i].letter+j)
                cell.value = cell.value !== null ? cell.value.substr(0,realColArray[i].length) : null;
            }
        }
    }
</#macro>

HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.exportingData', fallbackStr: '正在导出数据...'}), 'success');
const {columns: list, filename } = options;
<#--  列表头-列名 -->
const tableData = [];
<#-- 列表头-字段值 -->
const tableField = [];
// 根据导出设置列获取要导出的真正的列
function getExportCols(cols) {
    cols.forEach((col) => {
        if (col.children && col.children.length > 0) {
            getExportCols(col.children);
        } else {
            tableData.push(col.label);
            tableField.push(col.prop);
        }
    });
}
list.forEach((item) => {
    if (item.children && item.children.length > 0) {
        getExportCols(item.children);
    } else {
        tableData.push(item.label);
        tableField.push(item.prop);
    }
});
const columns = [];
for (let i=0; i<tableData.length ; i++){
const excelCol = {};
excelCol.key = tableField[i];
excelCol.width = 30;
columns.push(excelCol);
}
const Excel = require("exceljs");
const workbook = new Excel.Workbook();
const worksheet = workbook.addWorksheet("sheet1");
const fileName = (filename || 'data') + '.xlsx';
workbook.created = new Date();
workbook.modified = new Date();
worksheet.columns = columns;
<#if showConfigItemInfos??>
<#list showConfigItemInfos! as item>
    <#if item.isConfigComplete>
        const dicts = [];
        const relates = [];
        <#break>
    <#elseif showConfigItemInfos??>
        <#list item.mappingRelates! as mapping>
            <#if mapping.field == key>
                const dicts = [];
                const relates = [];
                <#break>
            </#if>
        </#list>
    </#if>
</#list>
</#if>
<#if showConfigItemInfos??>
<#list showConfigItemInfos! as item>
    <#if item.isConfigComplete && item.commonModelType?? >
        const dict${item_index} = [];
        const relate${item_index} = [];
        <#if !item.dictType?? || item.dictType == "">
            const ${item.importName!}Obj${item_index} = {};
        <#else>
            const ${item.importName!}Obj${item_index} = {
            typeName: '${item.dictType}',
            };
        </#if>
        const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
        });
        const data${item_index} = res${item_index}.data;
        function getTreeAllItems${item.tableFieldWhere!}(data, label) {
            data.forEach((item) => {
                let resLabel;
                if(label) {
                    resLabel = label + '-' + item.label;
                } else {
                    resLabel = item.label;
                }
                dict${item_index}.push({
                    field: '${item.tableFieldWhere!}',
                    value: item.value,
                    label: resLabel,
                });
                if (item.childrenList) {
                    if (label) {
                        getTreeAllItems${item.tableFieldWhere!}(item.childrenList, label + '-' + item.label);
                    } else {
                        getTreeAllItems${item.tableFieldWhere!}(item.childrenList, item.label);
                    }
                }
            });
        }
        if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
        // 数据展示字典表
        if (data${item_index} && data${item_index}.length > 0) {
            getTreeAllItems${item.tableFieldWhere!}(data${item_index});
        relate${item_index}.push({
        tableFieldWhere: '${item.tableFieldWhere!}',
        field: '${item.tableFieldWhere!}'
        });
        }
        } else {
          HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.DatadisplayFailed', fallbackStr: '数据展示数据请求失败'}), 'error');
        }
        dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
        relates.push(relate${item_index});
    <#elseif item.isConfigComplete>
        const dict${item_index} = [];
        const relate${item_index} = [];
        const ${item.importName!}Obj${item_index} = {
        inValues: '',
        ${item.queryObjectAttr!}
        };
        const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
        });
        const data${item_index} = res${item_index}.data;
        if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
        // 数据展示数据模型
        if (data${item_index}.data && data${item_index}.data.length > 0) {
        for (let i = 0; i < data${item_index}.data.length; i++) {
        <#list item.mappingRelates! as mapping>
            dict${item_index}.push({
            field: '${item.tableFieldWhere!}',
            value: data${item_index}.data[i].${item.relateTableFieldWhere!},
            label: data${item_index}.data[i].${mapping.relateField!}
            });
        </#list>
        }
        <#list item.mappingRelates! as mapping>
            relate${item_index}.push({
            tableFieldWhere: '${item.tableFieldWhere!}',
            field: '${mapping.field!}'
            });
        </#list>
        }
        } else {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.DatadisplayFailed', fallbackStr: '数据展示数据请求失败'}), 'error');
        }
        dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
        relates.push(relate${item_index});
    </#if>
</#list>
</#if>

const exportDataFun = function() {
const orders = cloneListQyery.orders || [];
<#if customView?? && customView>
if (self.${instanceKey!}PropsData?.selectedView?.orderBy?.length) {
    self.${instanceKey!}PropsData.selectedView.orderBy.forEach((item) => {
        if (orders.findIndex((e) => e.column === item.column) > -1) return;
        orders.push(item);
    });
}
</#if>

const ${importName!}Obj = {
...cloneListQyery,
orders,
${queryAttr!}
};
<#if showFilter?? && showFilter>
const queryConditions = self.${instanceKey!}GetQueryConditions(${importName!}Obj);
if (queryConditions && queryConditions.length) {
 ${importName!}Obj.superQueryConditionDto = queryConditions;
}
</#if>
<#if isSortOverall?? && isSortOverall>
const importMethod = "${importMethodNoPage!}"
${importName!}[importMethod](${importName!}Obj).then(res => {
<#else>
${importName!}.${importMethod!}(${importName!}Obj).then(res => {
</#if>
if ((res.code === 200 || res.code === 10000) && res.data) {
const convert = [];
self.${instanceKey!}TableTotal = res.data.count || 0;
self.${instanceKey!}ReturnData = res.data.data;
(res.data.data).forEach((item) => {
<#assign map=colFields/>
<#assign keys=map?keys/>
<#list keys! as key>
    <#assign flag=false/>
    <#if (key_index != (keys?size-1))>
        <#if showConfigItemInfos??>
            <#list showConfigItemInfos! as item>
                <#if item.isConfigComplete && item.commonModelType?? >
                    <#if item.tableFieldWhere == key>
                        let ${key}${item_index} = '';
                        const ${key}${item_index}Arr = [];
                        if (item.${item.tableFieldWhere} !== null && item.${item.tableFieldWhere}.toString().includes(',')) {
                            item.${item.tableFieldWhere}.split(',').forEach(function(value) {
                                const definedValue = dicts.find(function(dictItem) {
                                    return dictItem.field == '${item.tableFieldWhere}';
                                }).dict.find(function(dictItem) {
                                    return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                }) !== undefined;
                                if (definedValue) {
                                    ${key}${item_index}Arr.push(dicts.find(function(dictItem) {
                                        return dictItem.field == '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                        return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                    }).label);
                                } else {
                                    ${key}${item_index}Arr.push(value);
                                }
                            });
                            ${key}${item_index} = ${key}${item_index}Arr.join(',');
                        } else {
                            const definedValue = dicts.find(function(dictItem) {
                                return dictItem.field == '${item.tableFieldWhere}';
                            }).dict.find(function(dictItem) {
                                return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                            }) !== undefined;
                            if (definedValue) {
                                ${key}${item_index} = dicts.find(function(dictItem) {
                                    return dictItem.field == '${item.tableFieldWhere}';
                                }).dict.find(function(dictItem) {
                                    return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                }).label;
                            } else {
                                ${key}${item_index} = item.${item.tableFieldWhere};
                            }
                        }
                        <#assign flag=true/>
                    </#if>
                <#elseif showConfigItemInfos??>
                    <#list item.mappingRelates! as mapping>
                        <#if mapping.field == key>
                            let ${key}${item_index} = '';
                            const ${key}${item_index}Arr = [];
                            if (item.${item.tableFieldWhere} !== null && item.${item.tableFieldWhere}.toString().includes(',')) {
                                item.${item.tableFieldWhere}.split(',').forEach(function(value) {
                                    const definedValue = dicts.find(function(dictItem) {
                                        return dictItem.field == '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                        return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                    }) !== undefined;
                                    if (definedValue) {
                                        ${key}${item_index}Arr.push(dicts.find(function(dictItem) {
                                            return dictItem.field == '${item.tableFieldWhere}';
                                        }).dict.find(function(dictItem) {
                                            return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                        }).label);
                                    } else {
                                        ${key}${item_index}Arr.push(value);
                                    }
                                });
                                ${key}${item_index} = ${key}${item_index}Arr.join(',');
                            } else {
                                const definedValue = dicts.find(function(dictItem) {
                                    return dictItem.field == '${item.tableFieldWhere}';
                                }).dict.find(function(dictItem) {
                                    return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                }) !== undefined;
                                if (definedValue) {
                                    ${key}${item_index} = dicts.find(function(dictItem) {
                                        return dictItem.field == '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                        return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                    }).label;
                                } else {
                                    ${key}${item_index} = item.${item.tableFieldWhere};
                                }
                            }
                            <#assign flag=true/>
                        </#if>
                    </#list>
                </#if>
            </#list>
        </#if>
    <#else>
        <#if showConfigItemInfos??>
            <#list showConfigItemInfos! as item>
                <#if item.isConfigComplete && item.commonModelType?? >
                    <#if item.tableFieldWhere == key>
                        let ${key}${item_index} = '';
                        const ${key}${item_index}Arr = [];
                        if (item.${item.tableFieldWhere} !== null && item.${item.tableFieldWhere}.toString().includes(',')) {
                            item.${item.tableFieldWhere}.split(',').forEach(function(value) {
                                const definedValue = dicts.find(function(dictItem) {
                                    return dictItem.field == '${item.tableFieldWhere}';
                                }).dict.find(function(dictItem) {
                                    return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                }) !== undefined;
                                if (definedValue) {
                                    ${key}${item_index}Arr.push(dicts.find(function(dictItem) {
                                        return dictItem.field == '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                        return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                    }).label);
                                } else {
                                    ${key}${item_index}Arr.push(value);
                                }
                            });
                            ${key}${item_index} = ${key}${item_index}Arr.join(',');
                        } else {
                            const definedValue = dicts.find(function(dictItem) {
                                return dictItem.field == '${item.tableFieldWhere}';
                            }).dict.find(function(dictItem) {
                                return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                            }) !== undefined;
                            if (definedValue) {
                                ${key}${item_index} = dicts.find(function(dictItem) {
                                    return dictItem.field == '${item.tableFieldWhere}';
                                }).dict.find(function(dictItem) {
                                    return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                }).label;
                            } else {
                                ${key}${item_index} = item.${item.tableFieldWhere};
                            }
                        }
                        <#assign flag=true/>
                    </#if>
                <#elseif showConfigItemInfos??>
                    <#list item.mappingRelates! as mapping>
                        <#if mapping.field == key>
                            let ${key}${item_index} = '';
                            const ${key}${item_index}Arr = [];
                            if (item.${item.tableFieldWhere} !== null && item.${item.tableFieldWhere}.toString().includes(',')) {
                                item.${item.tableFieldWhere}.split(',').forEach(function(value) {
                                    const definedValue = dicts.find(function(dictItem) {
                                        return dictItem.field == '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                        return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                    }) !== undefined;
                                    if (definedValue) {
                                        ${key}${item_index}Arr.push(dicts.find(function(dictItem) {
                                            return dictItem.field == '${item.tableFieldWhere}';
                                        }).dict.find(function(dictItem) {
                                            return value == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                        }).label);
                                    } else {
                                        ${key}${item_index}Arr.push(value);
                                    }
                                });
                                ${key}${item_index} = ${key}${item_index}Arr.join(',');
                            }else {
                                const definedValue = dicts.find(function(dictItem) {
                                    return dictItem.field == '${item.tableFieldWhere}';
                                }).dict.find(function(dictItem) {
                                    return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                }) !== undefined;
                                if (definedValue) {
                                    ${key}${item_index} = dicts.find(function(dictItem) {
                                        return dictItem.field == '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                        return item.${item.tableFieldWhere} == dictItem.value && dictItem.field == '${item.tableFieldWhere}';
                                    }).label;
                                } else {
                                    ${key}${item_index} = item.${item.tableFieldWhere};
                                }
                            }
                            <#assign flag=true/>
                        </#if>
                    </#list>
                </#if>
            </#list>
        </#if>
    </#if>
</#list>
// 查到的数据转换为字符串
convert.push({
            <#assign map=colFields/>
            <#assign  keys=map?keys/>
            <#list keys! as key>
                <#assign flag=false/>
                <#if (key_index != (keys?size-1))>
                    <#if showConfigItemInfos??>
                        <#list showConfigItemInfos! as item>
                            <#if item.isConfigComplete && item.commonModelType?? >
                                <#if item.tableFieldWhere == key>
                                ${key}: ${key}${item_index},
                                <#assign flag=true/>
                                </#if>
                            <#elseif showConfigItemInfos??>
                                <#list item.mappingRelates! as mapping>
                                    <#if mapping.field == key>
                                        ${key}: ${key}${item_index},
                                        <#assign flag=true/>
                                    </#if>
                                </#list>
                            </#if>
                        </#list>
                    </#if>
                    <#if flag == false>
                        ${key}: ((item.${map[key]} + '') === 'null' || (item.${map[key]} + '') === 'undefined' ? '': (item.${map[key]} + '').trim()),
                    </#if>
                <#else>
                    <#if showConfigItemInfos??>
                        <#list showConfigItemInfos! as item>
                            <#if item.isConfigComplete && item.commonModelType?? >
                                <#if item.tableFieldWhere == key>
                                    ${key}: ${key}${item_index},
                                    <#assign flag=true/>
                                </#if>
                            <#elseif showConfigItemInfos??>
                                <#list item.mappingRelates! as mapping>
                                    <#if mapping.field == key>
                                        ${key}: ${key}${item_index},
                                        <#assign flag=true/>
                                    </#if>
                                </#list>
                            </#if>
                        </#list>
                    </#if>
                    <#if flag == false>
                        ${key}: ((item.${map[key]} + '') === 'null' || (item.${map[key]} + '') === 'undefined' ? '': (item.${map[key]} + '').trim()),
                    </#if>
                </#if>
            </#list>
})
});
worksheet.insertRows(1, convert);
const colArray = [];
const tableHead = [];
// eslint-disable-next-line
let maxLevel = 1;
const realTableHead = [];
const realColArray = [];
const getRealHeadAndCol = function (arr) {
    arr.forEach((child) => {
    if (child.children && child.children.length > 0) {
    getRealHeadAndCol(child.children);
    child.colspan = child.children.reduce((prev, cur) => prev + (cur.colspan || 1), 0);
    }
    realTableHead.push({
    title: child.label,
    field: child.prop,
    level: child.level || 1,
    rowspan: 1,
    colspan: child.colspan || 1,
    ...(child.align && child.align !== 'noConfig' ? { horizontal: child.align } : { horizontal: 'center' })
    });
    if (!child.prop) return;
    const currentIndex = tableField.indexOf(child.prop);
    const letter = excelDownloadForArea(currentIndex);
    realColArray.push({
    letter,
    field: child.prop,
    length: 0,
    dataType: 'string',
    ...(child.align && child.align !== 'noConfig' ? { horizontal: child.align } : { horizontal: 'center' })
    });
    });
};
// 获取需要导出的列配置项
getRealHeadAndCol(list);
// 获取表格最大层级
for (let i = 0; i < realTableHead.length; i++){
    if (realTableHead[i].level > maxLevel){
        maxLevel = realTableHead[i].level;
    }
}
// 处理表头占用单元格以及样式
<@tableHead></@tableHead>
// 调用exceljs导出方法
workbook.xlsx.writeBuffer().then(function (buffer) {
    saveAs(new Blob([buffer], {
        type: 'application/octet-stream'
    }), fileName);
});
${asyncBodyCode!}
} else {
HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.TheRequestForTableDataIsFailed', fallbackStr: '表格数据请求失败'}), 'error');
self.${instanceKey!}TableLoading = false;
}
}).catch(function() {
HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.TheRequestForTableDataIsAbnormal', fallbackStr: '表格数据请求异常'}), 'error');
self.${instanceKey!}TableLoading = false;
});
}
// 复制查询参数
const cloneListQyery = Object.assign(
    Object.create(Object.getPrototypeOf(self.${instanceKey!}ListQuery)),
    self.${instanceKey!}ListQuery
);

exportDataFun();


