<#macro rowCalculate colList>
    <#list colList as item>
        <#if item.children?? && (item.children?size>0) >
            <@rowCalculate colList=item.children></@rowCalculate>
        <#elseif  item.rowCalculateFormula?? && item.rowCalculateFormula !="">
            ${item.field!}Fn: (scope) => {
                const self = this;
            <#if item.selectType??  && item.selectType.numberFmtSelect?? && item.selectType.numberFmtSelect !="">
                return self.$numeral(${item.rowCalculateFormula!}|| 0).format('${item.selectType.numberFmtSelect}');
            <#else >
                return ${item.rowCalculateFormula!}
            </#if>
            },
        </#if>
    </#list>
</#macro>
<#if importName != "" && dbdHaveMethod?? && dbdHaveMethod>
    if(self.<#noparse>$</#noparse>refs.${instanceKey!}TableRef) {
      self.<#noparse>$</#noparse>refs.${instanceKey!}TableRef.scrollLeft = self.<#noparse>$</#noparse>refs.${instanceKey!}TableRef.lastScroll;
    }
    const startTime = Date.now();
    self.${instanceKey!}TableDataChecked = [];
    self.${instanceKey!}TableLoadStartTime = startTime;
    <#if isPagination?? && isPagination!>
    <#--表格加载样式，若流式加载第一页时。全屏加载，防止加载时滚动造成数据丢失-->
    if (!self.${instanceKey!}CustomOptions.pageType || (self.${instanceKey!}CustomOptions.pageType && self.${instanceKey!}ListQuery.current === 1)) {
        self.${instanceKey!}TableLoading = true;
    }
    <#else>
    self.${instanceKey!}TableLoading = true;
    </#if>
    <#if inputParam??>
        ${inputParam!}
    </#if>
    const orders = [...(self.${instanceKey!}ListQuery.orders || [])];
    <#if customView?? && customView>
    if (this.${instanceKey!}PropsData?.selectedView?.orderBy?.length) {
        this.${instanceKey!}PropsData.selectedView.orderBy.forEach((item) => {
            if (orders.findIndex((e) => e.column === item.column) > -1) return;
            orders.push(item);
        });
    }
    </#if>
    <#if orders??>
      ${orders}.forEach(item => {
        if (orders.findIndex((e) => e.column === item.column) > -1) return;
        orders.push(item);
      });
    </#if>
    <#if bodyName??>
        <#if isApi>
        ${bodyName!} = {
        <#else>
        const ${bodyName!} = {
        </#if>
            <#--无分页不带分页参数-->
            <#if isPagination?? && isPagination>
            ...self.${ListQuery!},
            </#if>
            orders,
            ${queryAttr!}

        };
    </#if>
    <#if isPagination?? && isPagination>
    <#--如果是流式加载，在这里修改查询size为25-->
    <#if bodyName??>
    if (self.${instanceKey!}CustomOptions.pageType) {
            ${bodyName!}.size = 25;
    }
    </#if>
        self.${instanceKey!}UpdateKey++
    </#if>
    <#if showFilter?? && showFilter>
       const queryConditions = self.${instanceKey!}GetQueryConditions(${inputParamName!});
       if (queryConditions && queryConditions.length) {
         ${inputParamName!}.superQueryConditionDto = queryConditions;
       }
    </#if>
    <#if !isApi>
        const taskId = HussarRouter.query(self, 'taskId');
        ${inputParamName!}.taskId = taskId;
    </#if>
    const importMethod = '${importMethod!}';
    self.queryObj = {};
    <#if isTotalCalculate?? && isTotalCalculate >
    self.${instanceKey!}TotalCalculate(${inputParamName!});
    </#if>
    ${importName!}[importMethod](${inputParamName!}).then(async res => {
        const data = res.data;
        if ((res.code === 200 || res.code === 10000) && data) {
        self.queryObj = ${inputParamName!};
        const convert = [];
        (data.${data}).forEach((item) => {
        const flowRouteParamCopy = {};
        <#if primaryKey??>
            flowRouteParamCopy.businessId = item.${primaryKey!} ? item.${primaryKey!} : '';
        </#if>
        flowRouteParamCopy.taskId = item.taskId ? item.taskId : '';
        flowRouteParamCopy.definitionKey = item.processDefinitionKey ? item.processDefinitionKey : '';
        flowRouteParamCopy.taskDefinitionKey = item.taskDefinitionKey ? item.taskDefinitionKey : '';
        convert.push({
            flowRouteParam: flowRouteParamCopy,
            ...item,
            <@rowCalculate colList=tableShowFields!></@rowCalculate>
        })
        });
    <#--            <#if isPagination?? && isPagination>-->
        self.${instanceKey!}TableTotal = data.${pageTotal!} || 0;
    <#--            </#if>-->
        self.${instanceKey!}ReturnData = data.data;
    <#--数据表格数据展示,数据替换完成之后才进行表格数据的展示-->
        <#if isShowConfig?? && isShowConfig>
            <#if isPagination?? && isPagination>
            let tempData = ${dataName!};
            if (self.${instanceKey!}CustomOptions.pageType) {
                if (${dataName!}.length !== 0 && self.${instanceKey!}ListQuery.current !== 1) {
                    tempData = tempData.concat(convert);
                } else {
                    tempData = convert;
                }
            } else {
                tempData = convert;
            }
            await self.${instanceKey!}ReplaceData(tempData, startTime);
            <#else>
            await self.${instanceKey!}ReplaceData(convert, startTime);
            </#if>
        <#else >
        <#if isPagination?? && isPagination>
        if (self.${instanceKey!}CustomOptions.pageType) {
            if (${dataName!}.length !== 0 && self.${instanceKey!}ListQuery.current !== 1) {
                    ${dataName!} = ${dataName!}.concat(convert);
            } else {
                    ${dataName!} = convert;
            }
        } else {
                ${dataName!} = convert;
        }
        <#else>
        ${dataName!} = convert;
        </#if>
            self.${instanceKey!}TableLoading = false;
        </#if>
        <#--处理部门人员展示名称方法-->
        <#if isShowDepAndPerName?? && isShowDepAndPerName>
            self.${instanceKey!}ReplaceDepAndPer(${dataName!});
        </#if>
        <#--表格加载完成事件-->
        <#if isLoadedEvent?? && isLoadedEvent>
            if (self.${instanceKey!}TableLoaded) {
                self.${instanceKey!}TableLoaded();
            }
        </#if>
        ${callbackCode!}
        } else {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.TheRequestForTableDataIsFailed', fallbackStr: '表格数据请求失败'}), 'error');
        self.${instanceKey!}TableLoading = false;
        }
        }).catch(function() {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.TheRequestForTableDataIsAbnormal', fallbackStr: '表格数据请求异常'}), 'error');
        self.${instanceKey!}TableLoading = false;
        })
<#else>
    ${callbackCode!}
</#if>
