<#macro colTree colList>
    <#list colList as item>
        <#if item.dataType! ==  'date'>
            <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                fieldDateFmt.push({field:'${item.field!}',fmt:'${item.selectType.dateFmtSelect}'});
            <#else>
                fieldDateFmt.push({field:'${item.field!}',fmt:'YYYY-MM-DD HH:mm:ss'});
            </#if>
        </#if>
    </#list>
</#macro>

<#if tableInstanceKey?? && dataName?? && tableInstanceKey != "" && dataName != "">
let file = event.currentTarget.files[0];
let rABS = false;
const types = file.name.split(".")[1];
const fileType = ['xlsx', 'xlc', 'xlm', 'xls', 'xlt', 'csv'].some(
    item => item === types
);
if (!fileType) {
    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.fileFormatError', fallbackStr: '文件格式错误，请重新选择！'}), 'error');
    return;
}
const Excel = require("exceljs");
let fileReader = new FileReader();
fileReader.onload = function (ev) {
    const data = ev.target.result;
    const workbook = new Excel.Workbook();
    workbook.xlsx.load(data)
        .then(function () {
            let values = [
                <#list tableShowFields! as item>
                    <#if (item_index != (tableShowFields?size-1))>
                        "${item.title}",
                    <#else>
                        "${item.title}"
                    </#if>
                </#list>
            ];
            let prop = [
                <#list tableShowFields! as item>
                    <#if (item_index != (tableShowFields?size-1))>
                        "${item.field}",
                    <#else>
                        "${item.field}"
                    </#if>
                </#list>
            ];

            function dateFormat(fmt, date) {
                let ret;
                const opt = {
                    "Y+": date.getFullYear().toString(),        // 年
                    "M+": (date.getMonth() + 1).toString(),     // 月
                    "D+": date.getDate().toString(),            // 日
                    "H+": date.getHours().toString(),           // 时
                    "m+": date.getMinutes().toString(),         // 分
                    "s+": date.getSeconds().toString()          // 秒
                };
                for (let k in opt) {
                    ret = new RegExp("(" + k + ")").exec(fmt);
                    if (ret) {
                        fmt = fmt.replace(ret[1], (ret[1].length === 1) ? (opt[k]) : (opt[k].padStart(ret[1].length, "0")))
                    }
                }
                return fmt;
            }

            function cellValueToDict(keys, row) {
                const data = {};
                const fieldDateFmt = [];
                <@colTree colList=tableShowFields!></@colTree>
                row.eachCell(function (cell, colNumber) {
                    let value = cell.value;
                    if(cell.type === (Excel.ValueType.Date)) {
                        value = new Date(value.valueOf() - 8 * 60 * 60 * 1000);
                        if (fieldDateFmt.length !== 0){
                            const findIndex = fieldDateFmt.findIndex(function(dictItem) {
                                return dictItem.field === prop[colNumber - 1];
                            })
                            const fmt = 'YYYY-MM-DD HH:mm:ss';
                            if (findIndex !== -1){
                                const haveValue = fieldDateFmt.find(function(dictItem){
                                    return dictItem.field === prop[colNumber - 1];
                                }) !== undefined;
                                if (haveValue) {
                                    const fmt = fieldDateFmt.find(function(dictItem) {
                                        return dictItem.field === prop[colNumber - 1];
                                    }).fmt;
                                }
                            }
                            value = dateFormat(fmt, value);
                        }
                    }
                    data[prop[colNumber - 1]] = value;
                });
                return data;
            }

            let dataArray = [];
            let keys = [];
            const worksheet = workbook.getWorksheet(1); // 获取第一个worksheet
            worksheet.eachRow(function (row, rowNumber) {
                if (rowNumber === ${maxLevel!}) {
                    keys = row.values;
                } else if (rowNumber > ${maxLevel!}) {
                    const rowDict = cellValueToDict(keys, row);
                    dataArray.push(rowDict);
                }
            });
            let valuesCopy = values.slice(0);
            let keysCopy = keys.filter(function (el) {
                return el;
            }).slice(0);
            if (JSON.stringify(keysCopy.sort()) !== JSON.stringify(valuesCopy.sort())) {
                HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.importTemplateError', fallbackStr: '导入模板错误，请重新选择！'}), 'error');
                return;
            }
        <#if unReferences?? && unReferences!>
            self.$refs.${tableInstanceKey!}TableRef.insertAt(dataArray, -1);
            HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.ImportWasSuccessful', fallbackStr: '导入成功'}), 'success');
        <#else>
            ${dataName!} = ${dataName!}.concat(dataArray);
            HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.ImportWasSuccessful', fallbackStr: '导入成功'}), 'success');
        </#if>
        });
}
fileReader.readAsBinaryString(file);
</#if>