<#--定义宏递归生成动作列事件和超链接方法-->
<#macro colEvent colList>
    <#list colList as col>
        <#if col.isParent??>
            <@colEvent colList=col.children></@colEvent>
        <#elseif col.eventList?? && col.eventList.isNeedAction?? && col.eventList.isNeedAction!>
        <#--动作列事件-->
            @${col.eventList.eventName!}="${instanceKey!}${col.eventList.eventName?cap_first}"
        </#if>
    </#list>
</#macro>
<div v-show="!${instanceKey!}Hidden">
    <h-tree-table
            id="${instanceKey!}TableRef"
            ref="${instanceKey!}TableRef"
            <#if (disabled??)>
                :disabled="${instanceKey!}Disabled"
            </#if>
            <#--点击选中行-->
            <#if isSingleSelect?? && isSingleSelect!>
                highlight-current-row :current-change="${instanceKey!}SingleSelectRow"
            </#if>
            <#--单双击耦合 增加额外计算时间方法-->
            <#if (colClick?? && colClick!) && dblClick?? && dblClick!>
                :row-click="${instanceKey!}ColClickFront"
                :row-dblclick="${instanceKey!}DblClickFront"
            <#else>
            <#--单击事件-->
                <#if colClick?? && colClick>
                    :row-click="${instanceKey!}ColClick"
                </#if>
            <#--双击事件-->
                <#if dblClick?? && dblClick>
                    :row-dblclick="${instanceKey!}DblClick"
                </#if>
            </#if>
            <#--单元格单击事件-->
            <#if cellClick?? && cellClick>
                :cell-click="${instanceKey!}CellClickInfo"
                :cell-class-name="${instanceKey!}CellClassName"
            </#if>
            <#--配置动作列-->
            <@colEvent colList=tableShowFields></@colEvent>
    >
    </h-tree-table>
    <#if (isHTreeTableExport?? && isHTreeTableExport!) || (isHTreeExportTemplate?? && isHTreeExportTemplate!)>
        <export-table-template-dialog
                v-if="${instanceKey!}ExportTempalteDialogVisible"
                :dialogVisible.sync="${instanceKey!}ExportTempalteDialogVisible"
                :columns="${instanceKey!}Columns"
                :istree=true
                :propsData="${instanceKey!}PropsData"
                :dataModelName="${instanceKey!}DataModelName"
                :columnsColsData="${instanceKey!}ColumnsColsData"
                <#if isHTreeTableExport?? && isHTreeTableExport!>
                    @exportData="${instanceKey!}HandleExport"
                </#if>
                <#if isHTreeExportTemplate?? && isHTreeExportTemplate!>
                    @export="${instanceKey!}HandleExportTemplate"
                </#if>
                :isExportTemp="${instanceKey!}isExportTemp"></export-table-template-dialog>
    </#if>
</div>
