<#macro colTree colList>
    <#list colList as item>
        <#if item.dataType! ==  'date'>
            <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                fieldDateFmt.push({field:'${item.field!}',fmt:'${item.selectType.dateFmtSelect}'});
            <#else>
                fieldDateFmt.push({field:'${item.field!}',fmt:'YYYY-MM-DD HH:mm:ss'});
            </#if>
        </#if>
    </#list>
</#macro>

<#if tableInstanceKey?? && dataName?? && tableInstanceKey != "" && dataName != "">
<#--  导入文件格式校验  -->
    const file = event.currentTarget.files[0];
    const rABS = false;
    const types = file.name.split(".")[1];
    const fileType = ['xlsx', 'xlc', 'xlm', 'xls', 'xlt', 'csv'].some(
    item => item === types
    );
    if (!fileType) {
    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.fileFormatError', fallbackStr: '文件格式错误，请重新选择！'}), 'error');
    return;
    }
<#--  可编辑表格导入excel -->
    const Excel = require("exceljs");
    const fileReader = new FileReader();
    <#if translateInfo?? && !showConfigItemInfos??>
    const dicts = [];
    const relates = [];
        <#list translateInfo! as item>
            <#if item.dictType?? >
                const dict${item_index} = [];
                const relate${item_index} = [];
                <#if !item.dictType?? || item.dictType == "">
                    const ${item.importName!}Obj${item_index} = {};
                <#else>
                    const ${item.importName!}Obj${item_index} = {
                    typeName: '${item.dictType}',
                    };
                </#if>
                const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                HussarRouter.showMsg(self, "数据请求异常", 'error');
                });
                const data${item_index} = res${item_index}.data;
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                // 数据展示字典表
                if (data${item_index} && data${item_index}.length > 0) {
                for (let i = 0; i < data${item_index}.length; i++) {
                dict${item_index}.push({
                field: '${item.tableFieldWhere!}',
                value: data${item_index}[i].value,
                label: data${item_index}[i].label
                });
                }
                relate${item_index}.push({
                tableFieldWhere: '${item.tableFieldWhere!}',
                field: '${item.relateTableFieldWhere!}'
                });
                }
                } else {
                HussarRouter.showMsg(self, "数据展示数据请求失败", 'error');
                }
                dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
                relates.push(relate${item_index});
            <#elseif item.mappingRelates??>
                const dict${item_index} = [];
                const relate${item_index} = [];
                const ${item.importName!}Obj${item_index} = {
                inValues: '',
                ${item.queryObjectAttr!}
                };
                const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                HussarRouter.showMsg(self, "数据请求异常", 'error');
                });
                const data${item_index} = res${item_index}.data;
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                // 数据展示数据模型
                if (data${item_index}.data && data${item_index}.data.length > 0) {
                for (let i = 0; i < data${item_index}.data.length; i++) {
                <#list item.mappingRelates! as mapping>
                    dict${item_index}.push({
                    field: '${item.tableFieldWhere!}',
                    value: data${item_index}.data[i].${mapping.field!},
                    label: data${item_index}.data[i].${mapping.relateField!}
                    });
                </#list>
                }
                <#list item.mappingRelates! as mapping>
                    relate${item_index}.push({
                    tableFieldWhere: '${item.tableFieldWhere!}',
                    field: '${item.relateTableFieldWhere!}'
                    });
                </#list>
                }
                } else {
                HussarRouter.showMsg(self, "数据展示数据请求失败", 'error');
                }
                dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
                relates.push(relate${item_index});
            </#if>
        </#list>
    </#if>
    fileReader.onload = function (ev) {
    const data = ev.target.result;
    const workbook = new Excel.Workbook();
    workbook.xlsx.load(data)
    .then(function () {
    const values = [
    <#list tableShowFields! as item>
        <#if (item_index != (tableShowFields?size-1))>
<#--             <#assign title = item.title?eval!item.title>-->
             <#if item.title?is_hash>
                 <#if item.title.international?? && item.title.international>
                     `<#noparse>$</#noparse>{self.hussar_t({key: '${item.title.internationalCode!}', fallbackStr: '${item.title.name!}'})}`,
                 <#else>
                     "${item.title.name!}",
                 </#if>
             <#else>
                 "${item.title!}",
             </#if>
         <#else>
<#--             <#assign title = item.title?eval!item.title>-->
             <#if item.title?is_hash>
                 <#if item.title.international?? && item.title.international>
                     `<#noparse>$</#noparse>{self.hussar_t({key: '${item.title.internationalCode!}', fallbackStr: '${item.title.name!}'})}`
                 <#else>
                     "${item.title.name!}"
                 </#if>
             <#else>
                 "${item.title!}"
             </#if>
        </#if>
    </#list>
    ];
    const prop = [
    <#list tableShowFields! as item>
        <#if (item_index != (tableShowFields?size-1))>
            "${item.field}",
        <#else>
            "${item.field}"
        </#if>
    </#list>
    ];
<#if translateInfo?? && !showConfigItemInfos??>
    for (let i = 0; i < relates.length; i++) {
        if (relates[i][0]) {
            if (!prop.includes(relates[i][0].tableFieldWhere))  {
                prop.push(relates[i][0].tableFieldWhere);
            }
        } else {
           HussarRouter.showMsg(self, "数据展示数据请求失败", 'error');
        }
    }
function cellValueToDict(keys, row) {
    const data = {};
    const delCols = [];
    values.forEach((item, index) => {
        if (keys.indexOf(item) === -1) {
            delCols.push(index);
        }
    });
    row.eachCell(function(cell, colNumber) {
        let value = cell.value;
        if(cell.type === (Excel.ValueType.Date)) {
            value = new Date(value.valueOf() - 8 * 60 * 60 * 1000);
        }
        if (dicts.length !== 0) {
            let findIndex;
            if (delCols.length > 0 && values.indexOf(keys[colNumber]) > -1) {
                const index = values.indexOf(keys[colNumber]);
                findIndex = dicts.findIndex(dictItem => dictItem.field === prop[index]);
            } else {
                findIndex = dicts.findIndex(dictItem => dictItem.field === prop[colNumber - 1]);
            }
            if (findIndex !== -1) {
                if (value.toString().includes(',')) {
                    const valueArr = [];
                    value.split(',').forEach(function (val) {
                        const dictItem =
                            dicts[findIndex]
                                .dict.find(function (dictItem) {
                                    return val === dictItem.label && dictItem.field === prop[colNumber - 1];
                                });
                        if (dictItem) {
                            valueArr.push(dictItem.value);
                        } else {
                            valueArr.push(value);
                        }
                    });
                    value = valueArr.join(',');
                } else {
                    let dictItem;
                    if (delCols.length > 0 && values.indexOf(keys[colNumber]) > -1) {
                        dictItem = dicts[findIndex].dict.find(function (dictItem) {
                            return value.toString() === dictItem.label.toString() && dictItem.field === prop[values.indexOf(keys[colNumber])];
                        });
                    } else {
                        dictItem = dicts[findIndex].dict.find(function (dictItem) {
                            return value.toString() === dictItem.label.toString() && dictItem.field === prop[colNumber - 1];
                        });
                    }
                    if (dictItem) {
                        value = dictItem.value;
                    }
                }
            }
        }
        if (delCols.length > 0) {
            if (values.indexOf(keys[colNumber]) > -1) {
                data[prop[values.indexOf(keys[colNumber])]] = value;
            }
        } else {
            data[prop[colNumber - 1]] = value;
        }
    });
    row.eachCell(function (cell, colNumber) {
      let value = cell.value;
      let newField = null;
      for (let i = 0; i < relates.length; i++) {
        if (relates[i][0]) {
          if (prop[colNumber - 1] === relates[i][0].field) {
            newField = relates[i][0].tableFieldWhere;
            break;
          }
        }
      }
      for(let i = 0;i < dicts.length; i++) {
          const dictField = dicts[i].dict.find((item) => item.field === newField);
          if (dictField) {
            colNumber = prop.findIndex((dictItem) => dictItem == dicts[i].field) + 1;
            break;
          }
        }
      if (cell.type === Excel.ValueType.Date) {
        value = new Date(value.valueOf() - 8 * 60 * 60 * 1000);
      }
      if (dicts.length !== 0) {
        let findIndex;
        if (delCols.length > 0 && values.indexOf(keys[colNumber]) > -1) {
          const index = values.indexOf(keys[colNumber]);
          findIndex = dicts.findIndex((dictItem) => dictItem.field === prop[index]);
        } else {
          findIndex = dicts.findIndex((dictItem) => dictItem.field === prop[colNumber - 1]);
        }
        if (findIndex !== -1) {
          if (value.toString().includes(',')) {
            const valueArr = [];
            value.split(',').forEach(function (val) {
              const dictItem = dicts[findIndex].dict.find(function (dictItem) {
                return val === dictItem.label && dictItem.field === prop[colNumber - 1];
              });
              if (dictItem) {
                valueArr.push(dictItem.value);
              } else {
                valueArr.push(value);
              }
            });
            value = valueArr.join(',');
          } else {
            let dictItem;
            if (delCols.length > 0 && values.indexOf(keys[colNumber]) > -1) {
              dictItem = dicts[findIndex].dict.find(function (dictItem) {
                return value.toString() === dictItem.label.toString() && dictItem.field === prop[values.indexOf(keys[colNumber])];
              });
            } else {
              dictItem = dicts[findIndex].dict.find(function (dictItem) {
                return value.toString() === dictItem.label.toString() && dictItem.field === prop[colNumber - 1];
              });
            }
            if (dictItem) {
              value = dictItem.value;
            }
          }
        }
      }
      if (delCols.length > 0) {
        if (values.indexOf(keys[colNumber]) > -1) {
          data[prop[values.indexOf(keys[colNumber])]] = value;
        }
      } else {
        data[prop[colNumber - 1]] = value;
      }
    });
    return data;
}
</#if>
    function dateFormat(fmt, date) {
    let ret;
    const opt = {
    "Y+": date.getFullYear().toString(),        // 年
    "M+": (date.getMonth() + 1).toString(),     // 月
    "D+": date.getDate().toString(),            // 日
    "H+": date.getHours().toString(),           // 时
    "m+": date.getMinutes().toString(),         // 分
    "s+": date.getSeconds().toString()          // 秒
    };
    Object.keys(opt).forEach((key) => {
    ret = new RegExp('(' + key + ')').exec(fmt);
    if (ret) {
    fmt = fmt.replace(ret[1], ret[1].length === 1 ? opt[key] : opt[key].padStart(ret[1].length, '0'));
    }
    });
    return fmt;
    }
    <#if !translateInfo?? || showConfigItemInfos??>
    function cellValueToDict(keys, row) {
        const data = {};
        const fieldDateFmt = [];
        <@colTree colList=tableShowFields!></@colTree>
        row.eachCell(function (cell, colNumber) {
        let value = cell.value;
        if(cell.type === (Excel.ValueType.Date)) {
        value = new Date(value.valueOf() - 8 * 60 * 60 * 1000);
        if (fieldDateFmt.length !== 0){
        const findIndex = fieldDateFmt.findIndex(function(dictItem) {
        return dictItem.field === prop[colNumber - 1];
        })
        const fmt = 'YYYY-MM-DD HH:mm:ss';
        if (findIndex !== -1){
        const haveValue = fieldDateFmt.find(function(dictItem){
        return dictItem.field === prop[colNumber - 1];
        }) !== undefined;
        if (haveValue) {
        const fmt = fieldDateFmt.find(function(dictItem) {
        return dictItem.field === prop[colNumber - 1];
        }).fmt;
        }
        }
        value = dateFormat(fmt, value);
        }
        }
        data[prop[colNumber - 1]] = value;
        });
        return data;
        }
    </#if>

    const dataArray = [];
    let keys = [];
    const worksheet = workbook.worksheets[0]; // 获取第一个worksheet
    worksheet.eachRow(function (row, rowNumber) {
    if (rowNumber === ${maxLevel!}) {
    keys = row.values;
    } else if (rowNumber > ${maxLevel!}) {
    const rowDict = cellValueToDict(keys, row);
    dataArray.push(rowDict);
    }
    });
    const valuesCopy = values.slice(0);
    const keysCopy = keys.filter(function (el) {
    return el;
    }).slice(0);
<#--    if (JSON.stringify(keysCopy.sort()) !== JSON.stringify(valuesCopy.sort())) {-->
<#--    HussarRouter.showMsg(self, "导入模板错误，请重新选择！", 'error');-->
<#--    return;-->
<#--    }-->
    <#if unReferences?? && unReferences!>
        <#if isHEditTable?? && isHEditTable!>
            self.$refs.${tableInstanceKey!}TableRef.$refs.xTable.insertAt(dataArray, -1);
        <#else>
            self.$refs.${tableInstanceKey!}TableRef.insertAt(dataArray, -1);
        </#if>
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.ImportWasSuccessful', fallbackStr: '导入成功'}), 'success');
    <#else>
        ${dataName!} = ${dataName!}.concat(dataArray);
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.ImportWasSuccessful', fallbackStr: '导入成功'}), 'success');
    </#if>
    });
    }
    fileReader.readAsBinaryString(file);
</#if>