const seriesResult = [];
const colorValue = ${topicColorStr!};
<#assign effectScatter = effectScatter />
<#assign labelShow = labelShow />
<#assign imgRelativePath = '${imgRelativePath!}' />
<#if imgRelativePath?? && imgRelativePath != "">
  const imgRelativePathS = require('${imgRelativePath!}');
<#else>
  const imgRelativePathS = '${imgRelativePath!}';
</#if>

const cityName =  '${currentProvinceName!}';
<#--标题-->
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
    const titleLength = oldTitle.length;
    const provideLength = numberOfRow;
    const rowNumber = Math.ceil(titleLength / provideLength);
    if (titleLength > provideLength) {
        for (let i = 0; i < rowNumber; i++) {
            let tempStr = ' ';
            const start = i * provideLength;
            const end = start + provideLength;
            if (i === rowNumber - 1) {
                tempStr = oldTitle.substring(start, titleLength);
            } else {
                tempStr = oldTitle.substring(start, end)+'\n';
            }
            newTitle += tempStr;
        }
    } else {
        newTitle = oldTitle;
    }
}
const echatrsTitle = {
  textStyle: {
    color: '${titleColor!}',
    fontSize: '${titleFontSize!}',
    fontFamily: '${fontFamily!}',
    fontWeight: '${fontWeight!}',
  },
  text: newTitle,
  textVerticalAlign :'${titleVerticalAlign!}',
  left: '${titleAlign!}',
  top: '${titleTop!}',
  <#if (titleBackgroundColor?? && titleBackgroundColor != "")>
  backgroundColor: '${titleBackgroundColor!}',
  </#if>
  borderRadius: 4,
  padding: [6, 5, 3, 5],
};
<#--提示信息字体设置-->
const tooltipTextStyle = {
  color: '${toolColor!}',
  fontSize: '${toolFontSize!}',
  fontFamily: '${toolFontFamily!}',
  fontWeight: '${toolFontWeight!}',
  fontStyle: '${toolFontStyle!}',
  lineHeight: '${toolLineHeight!}',
};
<#--图例字体设置-->
const legendTextStyle ={
  color: '${legendColor!}',
  fontSize: '${legendFontSize!}',
  fontFamily: '${legendFontFamily!}',
  fontWeight: '${legendFontWeight!}',
  fontStyle: '${legendFontStyle!}',
};
<#--series系列字体设置-->
const seriesItemStyle ={
  normal:{
    color:'${markerColor!}',
    areaColor: '${areaColor!}',
    borderColor: '${areaBorderColor!}',
    borderWidth: ${areaBorderWidth!},
  },
  emphasis:{
    areaColor: '${areaEmphasisColor!}',
  },
};
<#--series系列标签设置-->
const seriesLabel ={
  normal:{
    show:false,
  },
  emphasis:{
    show:false,
    textStyle:{
      color:'#fff',
    },
  },
};
<#--地图-->
const geo = {
  map:cityName,
  show:true,
  roam:false,
  label:{
    emphasis:{
      show:false,
    },
  },
  itemStyle:{
    normal:{
      areaColor: '#091632',
      borderColor: '#1773c3',
      shadowColor: '${shadowColor!}',
      shadowBlur: '${shadowBlur!}',
    },
  },
};
<#--formatter标签-->
const formatterLabel ={
  normal:{
    formatter:'{b}',
    position:'right',
    <#if labelShow ?? && labelShow>
    show: true,
    <#else>
    show: false,
    </#if>
    color: '${labelColor!}',
    fontSize: '${labelFontSize!}',
    fontFamily: '${labelFontFamily!}',
    fontWeight: '${labelFontWeight!}',
  },
};
const formatterEmphasis ={
  scale:true,
};
const formatterLabelS ={
  normal:{
    formatter:'{b}',
    position:'right',
    <#if labelShow ?? && labelShow>
    show: true ,
    <#else>
    show: false,
    </#if>
    color: '${labelColor!}',
    fontSize: '${labelFontSize!}',
    fontFamily: '${labelFontFamily!}',
    fontWeight: '${labelFontWeight!}',
  },
};
const legend = ${optionData!}.legendData;
const values = ${optionData!}.valueData;
const citys = ${optionData!}.cityData;
const latitudes = ${optionData!}.latitudeData;
const longitudes  = ${optionData!}.longitudeData;
const geoCoordMap = [];
const data = [];
legend.forEach((item, index) => {
    const arr = [];
    const obj = {};
    citys[index].forEach( ( city, i ) => {
        obj[city] = [longitudes[index][i], latitudes[index][i]];
        arr.push({ name:city, value:values[index][i] });
    })
    geoCoordMap.push(obj);
    data.push(arr);
})

    const convertData = function(dataValue,index){
		const res = [];
		for (let i = 0; i < dataValue.length; i++) {
			const geoCoord = geoCoordMap[index][dataValue[i].name];
			if (geoCoord) {
			res.push({
				name: dataValue[i].name,
				value: geoCoord.concat(dataValue[i].value),
			});
		}
    }
    return res;
    };
    legend.forEach((e, index) => {
		seriesResult.push(...[
            {
            <#if effectScatter?? && effectScatter>
                name: '',
            <#else>
                name:legend[index],
            </#if>
                type: 'scatter',
                coordinateSystem :'geo',
                data: convertData(data[index],index),
                symbolSize:'${symbolSize!}',
            <#if imgRelativePath?? && imgRelativePath !="">
                symbol:`image://`+imgRelativePathS,
            <#else>
                symbol:'circle',
            </#if>
            label:formatterLabel,
            itemStyle:{
                normal:{
                    color: colorValue[index],
                    opacity:1,
                    },
                },
                emphasis:formatterEmphasis,
            },
            {
            <#if effectScatter?? && effectScatter>
                name:legend[index],
            <#else>
                name: '',
            </#if>
                type: 'effectScatter',
                coordinateSystem :'geo',
                data: convertData(data[index],index),
                symbolSize(){
                    <#if (effectScatter?? && effectScatter)>
                                return ${symbolSize!};
                    <#else>
                                return 0;
                    </#if>
                },
            showEffectOn: 'render',
            rippleEffect: {
            brushType: 'stroke',
            },
            hoverAnimation:true,
            label:formatterLabelS,
            itemStyle:{
                normal:{
                    color: colorValue[index],
                    shadowBlur:10,
                    shadowColor: '#333',
                    opacity:1,
                },
            },
            zlevel: 1,
            }
        ]);
	});


return {
			title: echatrsTitle,
			tooltip: {
			trigger: 'item',
			show: ${toolShow?string!},
			backgroundColor: '${tooltipBgColor!}',
			textStyle:tooltipTextStyle,
			formatter: function(param) {
			const paramValue = param.value;
			let res = param.seriesName + '<br/>';
			if (paramValue) {
			return res +=param.name +' : '+param.value[2]+'</br>';
			}
			return '';
			},
			padding:['${toolPaddingTop!}', '${toolPaddingLeft!}'],
			extraCssText: 'box-shadow: ${toolShadow!}',
			},
			legend: {
			show: ${isShowFlag?string!},
			left: '${legendLocation!}',
			textStyle:legendTextStyle,
			itemWidth: ${itemWidth!},
			itemHeight: ${itemHeight!},
			itemGap: ${itemGap!},
            <#if imgRelativePath?? && imgRelativePath !="">
				icon:`image://`+imgRelativePathS,
            <#else>
				icon: '${itemIcon!}',
            </#if>
			orient: '${itemOrient!}',
			inactiveColor: '${itemInactiveColor!}',
			bottom:5,
			borderRadius: 2,
			data:legend ,
			},
			geo:geo,
			series:
			[{
			type: 'map',
			map:cityName,
			geoIndex:1,
			aspectScale:0.75,
			showLegendSymbol:true,
			label:seriesLabel,
			roam:false,
			itemStyle:seriesItemStyle,
			},
			...seriesResult,
			],
		}







