/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LabelGroupVoidVisitor
implements VoidVisitor<LcdpComponent, Ctx> {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/labelGroup/labelGroup.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderDataValue(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        lcdpComponent.addAttr("id", lcdpComponent.getInstanceKey() + "Ref");
        JSONArray condition = (JSONArray)lcdpComponent.getProps().get("labelConditionStyle");
        JSONArray fontCondition = (JSONArray)lcdpComponent.getProps().get("labelFontConditionStyle");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
        LabelGroupVoidVisitor.extracted(lcdpComponent);
        if (!condition.isEmpty()) {
            lcdpComponent.addRenderParam("haveCondition", (Object)true);
        }
        if (!fontCondition.isEmpty()) {
            lcdpComponent.addRenderParam("haveFontCondition", (Object)true);
        }
    }

    private static void extracted(LcdpComponent lcdpComponent) {
        lcdpComponent.addAttr(":theme-name", lcdpComponent.getInstanceKey() + "ThemeName");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String instanceKey = lcdpComponent.getInstanceKey();
        String styleSchemeClassName = lcdpComponent.getStyleSchemeClassName();
        ctx.addData(instanceKey + "ThemeName: '" + styleSchemeClassName + "'", "themeName\u5c5e\u6027");
        String propsData = "";
        if (!lcdpComponent.getProps().isEmpty()) {
            HashSet<String> needParams = new HashSet<String>(Arrays.asList("labelConditionStyle", "labelFontConditionStyle"));
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String key : lcdpComponent.getProps().keySet()) {
                if (!needParams.contains(key)) continue;
                this.renderCondition(lcdpComponent, key, props);
            }
            HashMap<String, HashMap<String, Object>> renderParams = new HashMap<String, HashMap<String, Object>>();
            renderParams.put("labelGroupMaps", props);
            propsData = propsData + RenderUtil.renderTemplate((String)"/template/elementui/element/labelGroup/label-group-condition.ftl", renderParams);
        }
        if (ToolUtil.isNotEmpty((Object)propsData)) {
            ctx.addData(lcdpComponent.getInstanceKey() + "Condition: {" + propsData + " }", "\u6807\u7b7e\u7ec4\u6761\u4ef6\u5c5e\u6027");
            ArrayList<String> listParams = new ArrayList<String>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("instanceKey", instanceKey);
            listParams.add("value");
            JSONArray condition = (JSONArray)lcdpComponent.getProps().get("labelConditionStyle");
            JSONArray fontCondition = (JSONArray)lcdpComponent.getProps().get("labelFontConditionStyle");
            if (!condition.isEmpty()) {
                ctx.addMethod(lcdpComponent.getInstanceKey() + "GetLabelStyle", listParams, RenderUtil.renderTemplate((String)"/template/elementui/element/labelGroup/get_label_style.ftl", map), true);
            }
            if (!fontCondition.isEmpty()) {
                ctx.addMethod(lcdpComponent.getInstanceKey() + "GetFontStyle", listParams, RenderUtil.renderTemplate((String)"/template/elementui/element/labelGroup/get_font_style.ftl", map), true);
            }
        }
    }

    private void renderDataValue(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String defaultValue = "['\u6807\u7b7e1', '\u6807\u7b7e2', '\u6807\u7b7e3']";
        ComponentData componentData = RenderVModelUtil.renderArrayDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)defaultValue);
        String optionData = componentData.getRenderValue();
        lcdpComponent.addRenderParam("optionData", (Object)(CodePrefix._SELF.getType() + optionData));
        boolean isDefaultValue = false;
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            lcdpComponent.addRenderParam("isQuoteOrGetValue", (Object)"true");
        } else if (!ctx.getDatas().containsKey(lcdpComponent.getInstanceKey() + CodeSuffix._OPTION.getType() + ":" + defaultValue)) {
            isDefaultValue = true;
        }
        lcdpComponent.addRenderParam("isDefaultValue", (Object)isDefaultValue);
    }

    private void renderCondition(LcdpComponent lcdpComponent, String key, Map<String, Object> props) throws LcdpException {
        String value = lcdpComponent.getProps().get(key).toString();
        if (lcdpComponent.getProps().get(key) instanceof String) {
            value = "'" + value + "'";
        }
        if ("labelConditionStyle".equals(key)) {
            JSONArray condJsonArray = JSON.parseArray((String)lcdpComponent.getProps().get("labelConditionStyle").toString());
            if (ToolUtil.isNotEmpty((Object)condJsonArray)) {
                HashMap<String, JSONArray> param = new HashMap<String, JSONArray>();
                param.put("condtions", condJsonArray);
                props.put("getLabelStyle", RenderUtil.renderTemplate((String)"/template/elementui/element/labelGroup/get_condition_style.ftl", param));
            }
        } else if ("labelFontConditionStyle".equals(key)) {
            JSONArray condJsonArray = JSON.parseArray((String)lcdpComponent.getProps().get("labelFontConditionStyle").toString());
            if (ToolUtil.isNotEmpty((Object)condJsonArray)) {
                HashMap<String, JSONArray> param = new HashMap<String, JSONArray>();
                param.put("condtions", condJsonArray);
                props.put("getFontStyle", RenderUtil.renderTemplate((String)"/template/elementui/element/labelGroup/get_font_condition_style.ftl", param));
            }
        } else {
            props.put(key, value);
        }
    }
}

