<template>
    <#if isProduce?? && isProduce>
    <div class="lcdp_axe_main" v-if="alreadyLoad">
    {{ void (self = this) }}
    <#else>
    <div class="lcdp_axe_main">
    {{ void (self = this) }}
    </#if>
    <div class="lcdp_axe jxd_ins_elBaseWebPage jxd_additional ${pageName} ${rootInstanceKey} ${styleSchemeClassName}">
        ${body!}
        <#if showFlowFile?? && showFlowFile>
            <flowchart
                    v-if="${instanceKey!}ShowFlowFile"
                    class="workflow"
                    style="z-index: 3001;"
                    :businessId="${instanceKey!}ShowPicProcessKey"
                    :processKey="hussar_0ProcessKey"
                    :show="${instanceKey!}ShowFlowFile"
                    @close="${instanceKey!}ShowFlowFile=false"/>
        </#if>
        <#if showFlowFileDialog?? && showFlowFileDialog>
            <el-dialog class="flowchart-dialog"
                       :visible="${instanceKey!}ShowFlowFileDialog"
                       :show-close="false"
                       :append-to-body="true"
                       :close-on-click-modal="false"
                       :close-on-press-escape="false">
                <flowchart
                        v-if="${instanceKey!}ShowFlowFileDialog"
                        class="workflow"
                        :processKey="hussar_0ProcessKey"
                        :businessId="${instanceKey!}ShowPicProcessKey"
                        :show="${instanceKey!}ShowFlowFileDialog"
                        @close="${instanceKey!}ShowFlowFileDialog=false">
                </flowchart>
            </el-dialog>
        </#if>
        <#if participantDialog?? && participantDialog>
        <participantDialog @close="${instanceKey!}ParticipantDialogVisible = false" @comfirm="${instanceKey!}ComfirmParticipant" :selectionBackup='${instanceKey!}SelectionBackup' :tableData ='${instanceKey!}ParticipantData'  :participantDialogVisible='${instanceKey!}ParticipantDialogVisible' :taskId="${instanceKey!}ParticipantTaskId" :processDefinitionKey="${instanceKey!}ParticipantProcessDefinitionKey" :nodeId="${instanceKey!}FlowData.flowSelect" :lineCondition="${instanceKey!}LineCondition">
        </participantDialog>
            </#if>
        <#if assignParticipantDialog?? && assignParticipantDialog>
            <assignParticipantDialog @close="${instanceKey!}AssignParticipantDialogVisible = false" @comfirm="${instanceKey!}ComfirmAssignParticipant" :selectionBackup='${instanceKey!}AssignSelectionBackup' :assignParticipantData ='${instanceKey!}AssignParticipantData' :assignParticipantDialogVisible='${instanceKey!}AssignParticipantDialogVisible'>
            </assignParticipantDialog>
        </#if>
        <#if consignorDialog?? && consignorDialog>
            <consignorDialog :taskId="${instanceKey!}${consignorCurrentKey!}consignorDialogTaskId" @close="${instanceKey!}ConsignorDialogVisible = false" @comfirm="(argument)=>comfirmConsignor('${instanceKey!}', '${consignorInputIns!}', argument)" :selectionBackup='${instanceKey!}SelectedConsignorBackup' :tableData ='${instanceKey!}ConsignorData'  :consignorDialogVisible='${instanceKey!}ConsignorDialogVisible'>
            </consignorDialog>
        </#if>
        <#if customFlowNode??>
            <#list customFlowNode as currentKey>
                <customFlowNode @addCustomNodeExecuteFunction="${instanceKey!}${currentKey!}AddCustomNodeExecuteFunction" @close="${instanceKey!}${currentKey!}CustomFlowNodeVisible = false" :customFlowNodeVisible="${instanceKey!}${currentKey!}CustomFlowNodeVisible" :taskId="${instanceKey!}${currentKey!}CustomFlowNodeTaskId">
                </customFlowNode>
            </#list>
        </#if>
        <#if showSelectEndorsement??>
            <#list showSelectEndorsement as currentKey>
                <selectEndorsement @close="${instanceKey!}${currentKey!}SelectEndorsementShow = false" :selectEndorsementShow="${instanceKey!}${currentKey!}SelectEndorsementShow" @save="${instanceKey!}${currentKey!}TaskEndorsementSave" :selectEndorsementAppId="${instanceKey!}${currentKey!}SelectEndorsementAppId" <#if selectEndorsementStrategy??>:strategy="true"<#else>:strategy="false"</#if> :endorsementChecked="${instanceKey!}${currentKey!}SelectEndorsementChecked">
                </selectEndorsement>
            </#list>
        </#if>
        <#if customFlowNodeSingle??>
            <#list customFlowNodeSingle as currentKey>
                <customFlowNodeSingle @addCustomNodeSignalExecuteFunction="${instanceKey!}${currentKey!}AddCustomNodeSignalExecuteFunction" @close="${instanceKey!}${currentKey!}CustomFlowNodeSingleVisible = false" :customFlowNodeVisible="${instanceKey!}${currentKey!}CustomFlowNodeSingleVisible" :taskId="${instanceKey!}${currentKey!}CustomFlowNodeSingleTaskId">
                </customFlowNodeSingle>
            </#list>
        </#if>
        <#if showSelectParticipant??>
            <#list showSelectParticipant as currentKey>
                <selectParticipant @close="${instanceKey!}${currentKey!}SelectParticipantShow = false" :selectParticipantShow="${instanceKey!}${currentKey!}SelectParticipantShow" @save="${instanceKey!}${currentKey!}FlowFormSubmitSave" :taskId="${instanceKey!}${currentKey!}TaskId" :processDefinitionKey="${instanceKey!}${currentKey!}ProcessDefinitionKey" :doneListIdentification="${instanceKey!}${currentKey!}DoneListIdentification ? ${instanceKey!}${currentKey!}DoneListIdentification : '0'" :isGetRevokeNode="${instanceKey!}${currentKey!}isGetRevokeNode" :lineCondition="${instanceKey!}${currentKey!}LineCondition">
                </selectParticipant>
            </#list>
        </#if>
        <#if showSelectEntrust??>
            <#list showSelectEntrust as currentKey>
                <selectEntrust :taskId="${instanceKey!}${currentKey!}EntrustTaskId" @close="${instanceKey!}${currentKey!}SelectEntrustShow = false" :selectEntrustShow="${instanceKey!}${currentKey!}SelectEntrustShow" @save="${instanceKey!}${currentKey!}TaskEntrustSave">
                </selectEntrust>
            </#list>
        </#if>
        <#if showLaunchAssisted??>
            <#list showLaunchAssisted as currentKey>
                <LaunchAssisted @showLaunchAssistedExecuteFunction="${instanceKey!}${currentKey!}ShowLaunchAssistedExecuteFunction" @close="${instanceKey!}${currentKey!}LaunchAssistedShow = false" :launchAssistedShow="${instanceKey!}${currentKey!}LaunchAssistedShow" :taskId="${instanceKey!}${currentKey!}LaunchAssistedTaskId" :flowEventData="${instanceKey!}${currentKey!}FlowEventData">
                </LaunchAssisted>
            </#list>
        </#if>
        <#if showLaunchCountersigned??>
            <#list showLaunchCountersigned as currentKey>
                <LaunchCountersigned @showLaunchCountersignedExecuteFunction="${instanceKey!}${currentKey!}ShowLaunchCountersignedExecuteFunction" @close="${instanceKey!}${currentKey!}LaunchCountersignedShow = false" :launchCountersignedShow="${instanceKey!}${currentKey!}LaunchCountersignedShow" :taskId="${instanceKey!}${currentKey!}LaunchCountersignedTaskId" :flowEventData="${instanceKey!}${currentKey!}FlowEventData">
                </LaunchCountersigned>
            </#list>
        </#if>
        <#if showLaunchCirculated??>
            <#list showLaunchCirculated as currentKey>
                <LaunchCirculated @showLaunchCirculatedExecuteFunction="${instanceKey!}${currentKey!}ShowLaunchCirculatedExecuteFunction" @close="${instanceKey!}${currentKey!}LaunchCirculatedShow = false" :launchCirculatedShow="${instanceKey!}${currentKey!}LaunchCirculatedShow" :taskId="${instanceKey!}${currentKey!}LaunchCirculatedTaskId" :flowEventData="${instanceKey!}${currentKey!}FlowEventData">
                </LaunchCirculated>
            </#list>
        </#if>
        <#if showAssistedCause??>
            <#list showAssistedCause as currentKey>
                <AssistedCause @showAssistedCauseExecuteFunction="${instanceKey!}${currentKey!}ShowAssistedCauseExecuteFunction" @close="${instanceKey!}${currentKey!}AssistedCauseShow = false" :assistedCauseShow="${instanceKey!}${currentKey!}AssistedCauseShow" :taskId="${instanceKey!}${currentKey!}AssistedCauseTaskId" :flowEventData="${instanceKey!}${currentKey!}FlowEventData">
                </AssistedCause>
            </#list>
        </#if>
        <#if showAllowDeleteFlowNode??>
            <#list showAllowDeleteFlowNode as currentKey>
                <AllowDeleteFlowNode @close="${instanceKey!}${currentKey!}AllowDeleteFlowNodeShow = false" :allowDeleteFlowNodeShow="${instanceKey!}${currentKey!}AllowDeleteFlowNodeShow" :taskId="${instanceKey!}${currentKey!}AllowDeleteFlowNodeTaskId">
                </AllowDeleteFlowNode>
            </#list>
        </#if>
        <#if showAvoidFlowTask??>
            <#list showAvoidFlowTask as currentKey>
                <AvoidFlowTask @close="${instanceKey!}${currentKey!}AvoidFlowTaskShow = false" :avoidFlowTaskShow="${instanceKey!}${currentKey!}AvoidFlowTaskShow" :flowEventData="${instanceKey!}${currentKey!}FlowEventData">
                </AvoidFlowTask>
            </#list>
        </#if>
        <#if showSelectSubject??>
            <#list showSelectSubject as currentKey>
                <selectSubject @close="${instanceKey!}${currentKey!}SelectSubjectShow = false"
                                  :selectSubjectShow="${instanceKey!}${currentKey!}SelectSubjectShow"
                                  @save="${instanceKey!}${currentKey!}SelectSubjectSave"
                                  :taskId="${instanceKey!}${currentKey!}TaskId"
                                  >
                </selectSubject>
            </#list>
        </#if>
        <#if showRecallSelectSubject??>
            <#list showRecallSelectSubject as currentKey>
                <selectRecallSubject @close="${instanceKey!}${currentKey!}SelectRecallSubjectShow = false"
                                  :selectSubjectShow="${instanceKey!}${currentKey!}SelectRecallSubjectShow"
                                  @save="${instanceKey!}${currentKey!}SelectRecallSubjectSave"
                                  :taskId="${instanceKey!}${currentKey!}RecallTaskId"
                                  >
                </selectRecallSubject>
            </#list>
        </#if>
        <#if showSelectRejectNode??>
            <#list showSelectRejectNode as currentKey>
                <selectRejectNode @close="${instanceKey!}${currentKey!}SelectRejectNodeShow = false"
                                  :selectRejectNodeShow="${instanceKey!}${currentKey!}SelectRejectNodeShow"
                                  @save="${instanceKey!}${currentKey!}AnyNodeRejectSave"
                                  :taskId="${instanceKey!}${currentKey!}TaskId"
                                  :doneListIdentification="${instanceKey!}${currentKey!}DoneListIdentification ? ${instanceKey!}${currentKey!}DoneListIdentification : '0'"
                                  >
                </selectRejectNode>
            </#list>
        </#if>
        <#if showSelectRejectNodeBack??>
            <#list showSelectRejectNodeBack as currentKey>
                <selectRejectNodeBack @close="${instanceKey!}${currentKey!}selectRejectNodebackShow = false"
                       :selectRejectNodeShow="${instanceKey!}${currentKey!}selectRejectNodebackShow"
                       :selectData="${currentKey!}Data"
                       @save="${instanceKey!}${currentKey!}selectRejectNodebackSave"
                       :taskId="${instanceKey!}${currentKey!}TaskId"
                       :doneListIdentification="${instanceKey!}${currentKey!}DoneListIdentification ? ${instanceKey!}${currentKey!}DoneListIdentification : '0'"
                       >
                </selectRejectNodeBack>
            </#list>
        </#if>
        <#if showSelectRejectNodeBack??>
            <#list showSelectRejectNodeBack as currentKey>
                <selectRejectNodeBack @close="${instanceKey!}${currentKey!}selectRejectNodebackShow = false"
                       :selectRejectNodeShow="${instanceKey!}${currentKey!}selectRejectNodebackShow"
                       :selectData="${currentKey!}Data"
                       @save="${instanceKey!}${currentKey!}selectRejectNodebackSave"
                       :taskId="${instanceKey!}${currentKey!}TaskId"
                       :doneListIdentification="${instanceKey!}${currentKey!}DoneListIdentification ? ${instanceKey!}${currentKey!}DoneListIdentification : '0'"
                       >
                </selectRejectNodeBack>
            </#list>
        </#if>
        <#if showFreeReject??>
            <#list showFreeReject as currentKey>
                <freeReject @freeRejectExecuteFunction="${instanceKey!}${currentKey!}FreeRejectExecuteFunction" @close="${instanceKey!}${currentKey!}FreeRejectShow = false" :freeRejectShow="${instanceKey!}${currentKey!}FreeRejectShow" :taskId="${instanceKey!}${currentKey!}FreeRejectTaskId" :flowEventData="${instanceKey!}${currentKey!}FlowEventData">
                </freeReject>
            </#list>
        </#if>
        <#if customCommentDialog?? && customCommentDialog>
            <customComment :customCommentVisible="${instanceKey!}CustomCommentVisible" @close="${instanceKey!}CloseCustomComment" <#if customCommentStrategy??>:strategy="true"<#else>:strategy="false"</#if>>
            </customComment>
        </#if>
        ${slotCodes.default!}
        ${slot_title!}
        ${slotCodes.treeContextMenu!}
    </div>
    </div>
</template>

<script>
    <#list importScriptsList! as imp>
        ${imp}
    </#list>
    /* ${directives.definitionsBegin} */
    /* ${directives.definitionsEnd} */
    export default {
        name: "${pageName!}",
        components: {
            /* ${directives.componentsBegin} */
            /* ${directives.componentsEnd} */
                <#list componentsList as component>
                ${component}
                </#list>
        },
        props: {
            /* ${directives.propsBegin} */
            /* ${directives.propsEnd} */
        <#list props as prop>
            ${prop.paramName}: ${prop.paramDataType?cap_first},
        </#list>
            },
        data() {
            const self = this;
            return {
                <#if dicts?? && dicts?size gt 0>
                    dictOptions: [], // 字典数据
                </#if>
                <#if levelDicts?? && levelDicts?size gt 0>
                    levelDictOptions: [], // 多级字典数据
                </#if>
                <#macro generateData data key>
                    ${key}, <#if data.comments??> <#list data.comments as comment>// ${comment}</#list> </#if>
                </#macro>
                <#list datas?keys as key>
                    <#assign data=datas[key]>
                    <#if data?? && (data.annotationKey!"") == "">
                        <@generateData data=data key=key />
                    </#if>
                </#list>
                <#list annotationComponent! as annotation>
                    <#assign hasValid = false>
                    <#list datas?keys as key>
                    <#assign data=datas[key]>
                    <#if data?? && (data.annotationKey!"") == annotation>
                        <#assign hasValid = true>
                        <#break>
                    </#if>
                </#list>
                <#if hasValid>
                    /* begin datas:${annotation} */
                    <#list datas?keys as key>
                    <#assign data=datas[key]>
                    <#if data?? && (data.annotationKey!"") == annotation>
                        <@generateData data=data key=key />
                    </#if>
                    </#list>
                    /* end datas:${annotation} */
                </#if>
                </#list>
                /* ${directives.dataBegin} */
                /* ${directives.dataEnd} */
            }
        },
        computed: {
            <#macro generateComputed computed key>
            <#if computed.comments??>
            /**
             <#list computed.comments as comment>
             * ${comment}
             </#list>
             */
                </#if>
                ${key}(${computed.argBody!}){
                const self = this;
                <#list computed.bodies as body>
                ${body}
                </#list>
            },
            </#macro>
            <#list computeds?keys as key>
                <#assign computed=computeds[key]>
                <#if computed?? && (computed.annotationKey!"") == "">
                    <@generateComputed computed=computed key=key />
                </#if>
            </#list>
            <#list annotationComponent! as annotation>
                <#assign hasValid = false>
                <#list computeds?keys as key>
                <#assign computed=computeds[key]>
                <#if computed?? && (computed.annotationKey!"") == annotation>
                    <#assign hasValid = true>
                    <#break>
                </#if>
            </#list>
            <#if hasValid>
                /* begin computeds:${annotation} */
                <#list computeds?keys as key>
                <#assign computed=computeds[key]>
                <#if computed?? && (computed.annotationKey!"") == annotation>
                    <@generateComputed computed=computed key=key />
                </#if>
                </#list>
                /* end computeds:${annotation} */
            </#if>
            </#list>

            <#macro generateComputedWithGetSets computed key>
                <#if computed.comments??>
                /**
                 <#list computed.comments as comment>
                 * ${comment}
                 </#list>
                 */
                    </#if>
                    ${key}:{
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#macro>
            <#list computedWithGetSets?keys as key>
                <#assign computed=computedWithGetSets[key]>
                <#if computed?? && (computed.annotationKey!"") == "">
                    <@generateComputedWithGetSets computed=computed key=key />
                </#if>
            </#list>
            <#list annotationComponent! as annotation>
                <#assign hasValid = false>
                <#list computedWithGetSets?keys as key>
                <#assign computed=computedWithGetSets[key]>
                <#if computed?? && (computed.annotationKey!"") == annotation>
                    <#assign hasValid = true>
                    <#break>
                </#if>
            </#list>
            <#if hasValid>
                /* begin computedWithGetSets:${annotation} */
                <#list computedWithGetSets?keys as key>
                <#assign computed=computedWithGetSets[key]>
                <#if computed?? && (computed.annotationKey!"") == annotation>
                    <@generateComputedWithGetSets computed=computed key=key />
                </#if>
                </#list>
                /* end computedWithGetSets:${annotation} */
            </#if>

            </#list>
            /* ${directives.computedBegin} */
            /* ${directives.computedEnd} */
        },
        watch: {
            <#macro generateWatch watch key>
                <#if (key!?index_of('\'') > -1)>
                    <#if watch.comments??>
                    /**
                     <#list watch.comments as comment>
                    * ${comment}
                     </#list>
                    */
                     </#if>
                    ${key}:{
                    <#list watch.bodies as body>
                    ${body}
                    </#list>
                },
                <#else>
                <#if watch.comments??>
                /**
                 <#list watch.comments as comment>
                 * ${comment}
                 </#list>
                 */
                    </#if>
                    ${key}(${watch.argBody!}){
                    <#list watch.bodies as body>
                    ${body}
                    </#list>
                },
                </#if>
            </#macro>
            <#list watches?keys as key>
                <#assign watch=watches[key]>
                <#if watch?? && (watch.annotationKey!"") == "">
                    <@generateWatch watch=watch key=key />
                </#if>
            </#list>

            <#list annotationComponent! as annotation>
            <#assign hasValid = false>
            <#list watches?keys as key>
                <#assign watch=watches[key]>
                <#if watch?? && (watch.annotationKey!"") == annotation>
                    <#assign hasValid = true>
                    <#break>
                </#if>
            </#list>
            <#if hasValid>
                /* begin watches:${annotation}*/
                <#list watches?keys as key>
                <#assign watch=watches[key]>
                <#if watch?? && (watch.annotationKey!"") == annotation>
                    <@generateWatch watch=watch key=key />
                </#if>
                </#list>
                /* end watches:${annotation}*/
            </#if>
            </#list>
            /* ${directives.watchBegin} */
            /* ${directives.watchEnd} */
        },
        methods: {
            <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
            /**
             * 查询字典数据
             */
            async queryDictOptions() {
                const self = this;
                <#if dicts?? && dicts?size gt 0>
                    const queryDictObj = {
                        typeNames: '<#list dicts[0 ..! dicts?size - 1] as dict>${dict},</#list>${dicts[dicts?size - 1]}'
                    };
                    await dict.${dictMethod}(queryDictObj).then((res) => {
                        if (res.code === 10000 || res.code === 200) {
                            self.dictOptions = res.data;
                            <#list optionLoads as optionLoad>
                                ${optionLoad}
                            </#list>
                        } else {
                            HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dictionaryDataAbnormal', fallbackStr: '字典数据请求异常'}), 'error');
                        }
                    }).catch(function () {
                        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dictionaryDataAbnormal', fallbackStr: '字典数据请求异常'}), 'error');
                    });
                </#if>
                <#if levelDicts?? && levelDicts?size gt 0>
                    const queryLevelDictObj = {
                        typeNames: '<#list levelDicts[0 ..! levelDicts?size - 1] as levelDict>${levelDict},</#list>${levelDicts[levelDicts?size - 1]}'
                    };
                    await dict.${treeMethod}(queryLevelDictObj).then((res) => {
                        if (res.code === 10000 || res.code === 200) {
                            self.levelDictOptions = res.data;
                            <#list treeLoads as treeLoad>
                                ${treeLoad}
                            </#list>
                        } else {
                            HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dictionaryDataAbnormal', fallbackStr: '字典数据请求异常'}), 'error');
                        }
                    }).catch(function () {
                        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dictionaryDataAbnormal', fallbackStr: '字典数据请求异常'}), 'error');
                    });
                </#if>
            },
            </#if>
            <#macro generateMethod method key>
                <#assign importName=key>
                <#if async?? && async?size gt 0>
                    <#list async! as async_importName>
                        <#if async_importName == key>
                            <#assign importName=("async " + key)?string>
                        </#if>
                    </#list>
                </#if>
                <#if method.comments??>
                /**
                 <#list method.comments as comment>
                * ${comment}
                 </#list>
                 */
                </#if>
                <#if method.notNeedMethodBody??>
                    ${importName},
                <#else>
                    ${importName}(${method.argBody!}){
                        const self = this;
                        <#list method.bodies![] as body>
                        ${body}
                        </#list>
                    },
                </#if>
            </#macro>
            <#list methods?keys as key>
                <#assign method=methods[key]>
                <#if method?? && (method.annotationKey!"") == "">
                    <@generateMethod method=method key=key />
                </#if>
            </#list>
            <#list annotationComponent! as annotation>
                <#assign hasValid = false>
                <#list methods?keys as key>
                <#assign method = methods[key]>
                <#if method?? && (method.annotationKey!"") == annotation>
                    <#assign hasValid = true>
                    <#break>
                </#if>
            </#list>
            <#if hasValid>
                /* begin methods:${annotation} */
                <#list methods?keys as key>
                <#assign method=methods[key]>
                <#if method?? && (method.annotationKey!"") == annotation>
                    <@generateMethod method=method key=key />
                </#if>
                </#list>
                /* end methods:${annotation} */
            </#if>
            </#list>
            /* custom-methods # 二次开发自定义方法代码开始 */
            <#if customMethods??>
                <#list customMethods as method>
                    <#if method.methodInfo??>
                    <#assign methodInfo=method.methodInfo>
                        <#if methodInfo.methodBody?? && methodInfo.methodBody != "">
                            ${methodInfo.methodBody},
                        </#if>
                    </#if>
                </#list>
            </#if>
            /* custom-methods # 二次开发自定义方法代码结束*/
            /* ${directives.methodsBegin} */
            /* ${directives.methodsEnd} */
        },
        <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
        async </#if> created() {
            const self = this;
            // ${directives.createdBeforeBegin}
            // ${directives.createdBeforeEnd}
            <#list createds! as created>
            ${created}
            </#list>
            <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
            // 查询字典数据
            await self.queryDictOptions();
            </#if>
            // 附件上传通过window.EventBus调用即将废弃
            // if (window.EventBus !== undefined) {
            //     window.EventBus.$on('call-grandparent-method', (data) => {
            //         self.querydict();
            //     });
            // } else {
            //     self.$store.$on('call-grandparent-method', self.querydict);
            // }
            // ${directives.createdAfterBegin}
            // ${directives.createdAfterEnd}
        },
        beforeDestroy() {
            const self = this;
            // 附件上传通过window.EventBus调用即将废弃
            // if (window.EventBus !== undefined) {
            //     EventBus.$off('call-grandparent-method');
            // } else {
            //     // self.$store.$off('call-grandparent-method', self.querydict);
            //     <#list beforeDestroyeds! as destroyed>
            //         ${destroyed}
            //     </#list>
            // }
        },
        async mounted() {
            const self = this;
            this.process = {
                env: window.env,
            };
            // ${directives.mountedBeforeBegin}
            // ${directives.mountedBeforeEnd}
            <#if customMounteds?? && customMounteds?size gt 0>
                <#list customMounteds! as customMounted>
                        ${customMounted}
                </#list>
            </#if>
            <#list mounteds! as mounted>
                ${mounted}
            </#list>
            <#if isOnload?? && isOnload>
                self.${rootInstanceKey!}Onload();
            </#if>
            <#list mountedAfterOnloads! as mountedAfterOnload>
            ${mountedAfterOnload}
            </#list>
            <#if pollSwitchMethod>
                <#if polls?? && (polls?size>0)>
                    <#list polls as poll>
                        <#assign str = poll.eventName?cap_first/>
                        <#list methods?keys as key>
                            <#if key == rootInstanceKey + str>
                            self.${key}Destroy = setInterval(() => {
                            const self = this;
                                self.${key}();
                                },<#if poll.pollTime??>${poll.pollTime?c}</#if>);
                            </#if>
                        </#list>
                    </#list>
                </#if>
            </#if>
            <#-- 不重启环境下，实现页面局部刷新 -->
            if (self.$compilationMetadata.strategy) {
                window.curPageSelfFresh = function () {
                    if (self.${rootInstanceKey!}Activated) {
                        self.${rootInstanceKey!}Activated && self.${rootInstanceKey!}Activated();
                    }
                };
            }
            // ${directives.mountedAfterBegin}
            // ${directives.mountedAfterEnd}
        },
        filters: {
            <#macro generateFilter filter key>
                <#if filter.comments??>
                /**
                 <#list filter.comments as comment>
                 * ${comment}
                 </#list>
                 */
                    </#if>
                    ${key}(${filter.argBody!}){
                    <#list filter.bodies as body>
                    ${body}
                    </#list>
                },
            </#macro>
            <#list filters?keys as key>
                <#assign filter=filters[key]>
                <#if filter?? && (filter.annotationKey!"") == "">
                    <@generateFilter filter=filter key=key />
                </#if>
            </#list>
            <#list annotationComponent! as annotation>
                <#assign hasValid = false>
                <#list filters?keys as key>
                <#assign filter = filters[key]>
                    <#if filter?? && (filter.annotationKey!"") == annotation>
                        <#assign hasValid = true>
                        <#break>
                </#if>
                </#list>
                <#if hasValid>
                    /* begin filters:${annotation} */
                    <#list filters?keys as key>
                    <#assign filter = filters[key]>
                    <#if filter?? && (filter.annotationKey!"") == annotation>
                        <@generateFilter filter=filter key=key />
                    </#if>
                    </#list>
                    /* end filters:${annotation} */
                </#if>
            </#list>
        },
        destroyed() {
            const self = this;
            // ${directives.destroyedBeforeBegin}
            // ${directives.destroyedBeforeEnd}
            <#list destroyeds! as destroyed>
                ${destroyed}
            </#list>
            <#if pollSwitchMethod>
                <#if destroyPolls?? && (destroyPolls?size>0)>
                    <#list destroyPolls! as destroyPoll>
                        clearInterval(self.${destroyPoll});
                    </#list>
                </#if>
            </#if>
            // ${directives.destroyedAfterBegin}
            // ${directives.destroyedAfterEnd}
        },
        activated() {
            const self = this;
            // ${directives.activatedBeforeBegin}
            // ${directives.activatedBeforeEnd}
            <#list activateds! as activated>
            ${activated}
            </#list>
            <#if isActivated?? && isActivated>
                if(HussarRouter.query(self, 'refresh')){
                    self.${rootInstanceKey!}Activated();
                }
            </#if>
            // ${directives.activatedAfterBegin}
            // ${directives.activatedAfterEnd}
        },
        <#-- 重启环境下，实现页面局部刷新 -->
        beforeRouteUpdate(to, from, next){
            const self = this;
            next();
            if (to.query && to.query.systemParams && JSON.parse(to.query.systemParams).refresh === 1) {
                if (self.${rootInstanceKey!}Activated) {
                    self.${rootInstanceKey!}Activated && self.${rootInstanceKey!}Activated();
                }
            }
        },
        deactivated() {
            const self = this;
            // ${directives.deactivatedBeforeBegin}
            // ${directives.deactivatedBeforeEnd}
            <#list deactivateds! as deactivated>
            ${deactivated}
            </#list>
            // ${directives.deactivatedAfterBegin}
            // ${directives.deactivatedAfterEnd}
        },
        /* ${directives.optionsBegin} */
        /* ${directives.optionsEnd} */
}
</script>

<!-- ${directives.styleBeforeBegin} -->
<!-- ${directives.styleBeforeEnd} -->

<style scoped>
    /*公共，用于固定*/
    .lcdp_axe_main{transform: scale(1);height: 100%;overflow: auto}
    /*公共，用于设置文字提示的最大宽度*/
    .el-tooltip__popper{
        max-width: 500px;
    }
    ${styles!}
    <#if message_twinkle_css?? && message_twinkle_css>
    .twinkle {
        -webkit-animation: twinkle 1.5s infinite;
        animation: twinkle 1.5s infinite;
    }
    @-webkit-keyframes twinkle {
        0%, 100%, 50% {
            opacity: 1
        }
        25%, 75% {
            opacity: 0.4
        }
    }
    @keyframes twinkle {

        0%, 100%, 50% {
            opacity: 1
        }
        25%, 75% {
            opacity: 0.4
        }
    }
    </#if>
    ${hyperlinksSpan}
</style>
<#list extendScopedStyles! as extendScopedStyle>
    ${extendScopedStyle}
</#list>
<#if hasNonScopedStyles>
<style>
    ${nonScopedStyles!}
</style>
</#if>

<!-- ${directives.styleAfterBegin} -->
<!-- ${directives.styleAfterEnd} -->
