const inResult = [];
const outResult = [];
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
    const titleLength = oldTitle.length;
    const provideLength = numberOfRow;
    const rowNumber = Math.ceil(titleLength / provideLength);
    if (titleLength > provideLength) {
        for (let i = 0; i < rowNumber; i++) {
            let tempStr = ' ';
            const start = i * provideLength;
            const end = start + provideLength;
            if (i === rowNumber - 1) {
                tempStr = oldTitle.substring(start, titleLength);
            } else {
                tempStr = oldTitle.substring(start, end) + '\n';
            }
            newTitle += tempStr;
        }
    } else {
        newTitle = oldTitle;
    }
}
const echatrsTitle = {
    text: newTitle,
    textStyle: {
        color: '${titleColor!}',
        fontSize: '${titleFontSize!}',
        fontFamily: '${fontFamily!}',
        fontWeight: '${fontWeight!}',
        fontStyle: '${fontStyle!}',
    },
    left: '${titleAlign!}',
    top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
};
const echatrsTooltip = {
    formatter: '{b} : {c} ({d}%)',
    trigger: 'item',
    backgroundColor: '${tooltipBgColor!}',
    textStyle: {
        color: '${toolColor!}',
        fontSize: '${toolFontSize!}',
        fontFamily: '${toolFontFamily!}',
        fontWeight: '${toolFontWeight!}',
        fontStyle: '${toolFontStyle!}',
        lineHeight: '${toolLineHeight!}',
    },
};
const textStyle = {
    color: '${legendColor!}',
    fontSize: '${legendFontSize!}',
    fontFamily: '${legendFontFamily!}',
    fontWeight: '${legendFontWeight!}',
    fontStyle: '${legendFontStyle!}',
};
const topicColorStr = ${topicColorStr!};
 for (let m = 0; m < ${optionData!}.outNameData.length; m++) {
    inResult.push({
        name: ${optionData!}.outNameData[m],
        value: ${optionData!}.outValueData[m],
    });
}
for (let n = 0; n < ${optionData!}.inNameData.length; n++) {
    outResult.push({
        name: ${optionData!}.inNameData[n],
        value: ${optionData!}.seriesData[n],
    });
}
return {
    color: topicColorStr,
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    legend: [{
    <#if (isShowFlag?? && isShowFlag)>
        show: true,
    <#elseif (!isShowFlag?? || !isShowFlag)>
        show: false,
    </#if>
        <#--data: ${optionData!}.outNameData,-->
        left: '${legendLocation!}',
        textStyle: textStyle,
        <#--bottom: ${legendBottom!},-->
        bottom: 10,

    }
    <#--,{-->
    <#--<#if (isShowFlag?? && isShowFlag)>-->
    <#--    show: true,-->
    <#--<#elseif (!isShowFlag?? || !isShowFlag)>-->
    <#--    show: false,-->
    <#--</#if>-->
    <#--    data: ${optionData!}.inNameData,-->
    <#--    left: '${legendLocation!}',-->
    <#--    textStyle: textStyle,-->
    <#--    bottom: 10,-->
    <#--    }-->
        ],
    series: [
        {
            radius: '${radius!}%',
            type: 'pie',
            label: {
                position: 'inner',
                fontSize: ${withinSize!},
            },
            selectedMode: 'single',
            data: inResult,
        }, {
            radius: ['${withinRadius!}%', '${outsideRadius!}%'],
            type: 'pie',
            selectedMode: 'single',
            label: {
                formatter: '{b}:{c} {d}%',
                fontSize: ${outsideSize!},
            },
            data: outResult,
        },
    ],
}