const totalDomWidth = ${width!};
const total = Math.abs(${progressMax!} - ${progressMin!});
<#if progressReverse??>
    let ratio = (Math.abs(self.${value!} - ${progressMax!}) / total);
<#else>
    let ratio = (Math.abs(self.${value!} - ${progressMin!}) / total);
</#if>
if (ratio > 1) {
ratio = 1;
}
const cubeWidth = Math.floor((totalDomWidth / cubeCount) + 1);
let cubeDomArr = [];
for (let i = 0; i < cubeCount; i++) {
    const cubeDom = document.createElement('span');
    cubeDom.style.background = '#EBEEF5';
    cubeDom.style.width = `${r'${cubeWidth}'}px`;
    this.$refs.${instanceKey!}Total.appendChild(cubeDom);
}
const nowCubeCount = Math.floor(cubeCount * ratio);
cubeDomArr = this.$refs.${instanceKey!}Total.children;
for (let i = 0; i < nowCubeCount; i++) {
    cubeDomArr[i].style.background = "${progressColor!}";
}
<#if isThreshold??>
    self.${instanceKey!}ThresholdList.forEach((item) => {
    const color = item.thresholdColor; // 阈值颜色
    <#if progressReverse??>
        const greaterValue = Math.abs(item.lessValue - ${progressMax!}); // 大于阈值
        const lessValue = Math.abs(item.greaterValue - ${progressMax!}); // 小于阈值
    <#else>
        const greaterValue = Math.abs(item.greaterValue - ${progressMin!}); // 大于阈值
        const lessValue = Math.abs(item.lessValue - ${progressMin!}); // 小于阈值
    </#if>
    const gPercentage = greaterValue / total;
    const gThreshold = Math.floor(cubeCount * gPercentage);
    const lPercentage = lessValue / total;
    const lThreshold = Math.floor(cubeCount * lPercentage);
    const { greaterCondition } = item; // 大于或大于等于
    const { lessCondition } = item; // 小于或小于等于
    let isProgress = false;
    if (greaterCondition === 'greater' && lessCondition === 'less') {
        if (nowCubeCount > gThreshold && nowCubeCount < lThreshold) {
            isProgress = true;
        }
    } else if (greaterCondition === 'greaterEqual' && lessCondition === 'less') {
        if ((nowCubeCount > gThreshold || nowCubeCount === gThreshold) && nowCubeCount < lThreshold) {
            isProgress = true;
        }
    } else if (greaterCondition === 'greater' && lessCondition === 'lessEqual') {
        if (nowCubeCount > gThreshold && (nowCubeCount < lThreshold || nowCubeCount === lThreshold)) {
            isProgress = true;
        }
    } else if ((nowCubeCount > gThreshold || nowCubeCount === gThreshold) && (nowCubeCount < lThreshold || nowCubeCount === lThreshold)) {
        isProgress = true;
    }
    if (isProgress) {
        for (let i = 0; i < nowCubeCount; i++) {
            cubeDomArr[i].style.background = color;
        }
    }
    });
</#if>
