/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.publish;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.common.visitor.ClientPathResolver;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@ClientKind(kind="com.jxdinfo.WebPage.path.resolve")
@Component(value="com.jxdinfo.WebPage.path.resolve")
public class VuePathResolver
implements ClientPathResolver {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);

    public String apiRelativePath() {
        return this.pathStrategy.vuePathService().getFrontApiPath();
    }

    public ResourcePath projectApiPath() {
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String localPrefix = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getFrontApiPath()});
        return ResourcePath.of((String)"", (String)localPrefix, (String)"");
    }

    public ResourcePath projectApiFullPath(String fileRelativePath) {
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String localPrefix = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getFrontApiPath()});
        return ResourcePath.of((String)fileRelativePath, (String)localPrefix, (String)"");
    }

    public Map<String, String> imports() {
        HashMap<String, String> imports = new HashMap<String, String>();
        imports.put("dateFormatPublic", "@/pages/index/utils/lowcode/dateFormatUtil");
        imports.put("getQueryConditionsResult", "@/pages/index/utils/lowcode/queryConditionUtils");
        imports.put("caching", "hussar-base");
        return imports;
    }

    public Map<String, String> paths() {
        HashMap<String, String> paths = new HashMap<String, String>();
        paths.put("EXTEND_JS_PATH", VfgModeTool.isRemote() ? FileUtil.systemPath((String[])new String[]{"/extend/js"}) : FileUtil.systemPath((String[])new String[]{"/src/pages/index/extend/js"}));
        paths.put("EXTEND_JS_PATH_AB", FileUtil.systemPath((String[])new String[]{"/src/pages/index/extend/js"}));
        paths.put("EXTEND_WRITE_JS_PATH", FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getExtendScriptPath(), this.formDesignProperties.getExtendJavaScriptPath()}));
        paths.put("EXTEND_VUE_PATH", VfgModeTool.isRemote() ? FileUtil.systemPath((String[])new String[]{"/extend/views"}) : FileUtil.systemPath((String[])new String[]{"/src/pages/index/extend/views"}));
        paths.put("EXTEND_VUE_PATH_AB", FileUtil.systemPath((String[])new String[]{"/src/pages/index/extend/views"}));
        paths.put("EXTEND_WRITE_VUE_PATH", FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getExtendScriptPath(), this.formDesignProperties.getExtendVuePath()}));
        paths.put("EXTEND_WRITE_CSS_PATH", FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getExtendScriptPath(), this.formDesignProperties.getExtendCssScriptPath()}));
        paths.put("META_TYPE", FileUtil.systemPath((String[])new String[]{".cpd.meta"}));
        paths.put("JS_META_TYPE", FileUtil.systemPath((String[])new String[]{".jsd.meta"}));
        paths.put("FRONT_PROJECT_PATH", this.pathStrategy.vuePathService().getCloudFrontProjectPath(this.pathStrategy.vuePathService().getFrontProjectPath(), new String[0]));
        return paths;
    }

    public Map<String, String> others(Map<String, String> map) {
        HashMap<String, String> others = new HashMap<String, String>();
        others.put(DataFromEnum.PAGE_PARAM.getValue(), "HussarRouter.query(self, '" + map.get(DataFromEnum.PAGE_PARAM.getValue()) + "')");
        return others;
    }
}

