/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.extend.cascade;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import java.io.File;
import java.io.IOException;

@ClientKind(kind="com.jxdinfo.VueScript.cascade")
public class CustomVueCascadeImpl
implements ResourceCascadeVisitor {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    public static final String KIND = "com.jxdinfo.VueScript.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldfilePath = this.getOldVuePath(baseFile.getId(), strategy);
        String newFilePath = this.getNeWVuePath(baseFile.getId(), baseFile.getName(), strategy);
        File newFile = new File(newFilePath);
        File oldFile = new File(oldfilePath);
        if (FileUtils.exists((File)oldFile) && !FileUtils.exists((File)newFile)) {
            this.fixName(oldFile, newFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
    }

    public void cascadeDelete(String id) throws LcdpException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldVueFilePath = this.getOldVuePath(id, strategy);
        File file = new File(oldVueFilePath);
        if (FileUtils.exists((File)file)) {
            try {
                FileUtils.forceDelete((File)file);
                this.deleteAncestor(id);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldVueFilePath);
            }
        }
    }

    String getOldVuePath(String id, Integer strategy) throws LcdpException {
        String modelPath = this.fileMappingService.getFormatPath(id);
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String extendScriptPath = this.pathStrategy.vuePathService().getExtendScriptPath();
        String rootPath = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{extendScriptPath});
        return FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendVuePath(), modelPath + ".vue"});
    }

    String getNeWVuePath(String id, String pageName, Integer strategy) throws LcdpException {
        String modelPath = this.fileMappingService.getFormatParentPath(id);
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String extendScriptPath = this.pathStrategy.vuePathService().getExtendScriptPath();
        String rootPath = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{extendScriptPath});
        return FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendVuePath(), modelPath, pageName + ".vue"});
    }

    protected boolean fixName(File oldFile, File newFile) {
        return FileUtils.fixName((File)oldFile, (File)newFile);
    }

    void deleteAncestor(String id) throws IOException {
        String publishPath = FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath(), "/publish/version/ancestor", id.replace("_", "/")});
        if (FileUtils.exists((File)new File(publishPath))) {
            FileUtils.forceDelete((File)new File(publishPath));
        }
    }
}

