<#if tableInstanceKey?? && tableInstanceKey != "">
    let file = event.currentTarget.files[0];
    const types = file.name.split(".")[1];
    const fileType = ["xlsx", "xlc", "xlm", "xls", "xlt"].some(
        item => item === types
    );
    if (!fileType) {
        self.$message.error('文件格式错误，请重新选择！');
        return;
    }
    const Excel = require("exceljs");
    const fileReader = new FileReader();
    const dicts = [];
    <#if showConfigItemInfos??>
        const relates = [];
        <#list showConfigItemInfos! as item>
            const dict${item_index} = [];
            const relate${item_index} = [];
            const ${item.importName!}Obj${item_index} = {
                inValues: '',
                ${item.queryObjectAttr!}
            };
            const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                self.$message.error('数据请求异常');
            });
            const data${item_index} = res${item_index}.data;
            if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                if (data${item_index}.data && data${item_index}.data.length > 0) {
                    for (let i = 0; i < data${item_index}.data.length; i++) {
                        <#list item.mappingRelates! as mapping>
                            dict${item_index}.push({
                                field: '${item.tableFieldWhere!}',
                                value: data${item_index}.data[i].${item.relateTableFieldWhere!},
                                label: data${item_index}.data[i].${mapping.relateField!}
                            });
                        </#list>
                    }
                    <#list item.mappingRelates! as mapping>
                        relate${item_index}.push({
                            tableFieldWhere: '${item.tableFieldWhere!}',
                            field: '${mapping.field!}'
                        });
                    </#list>
                }
            } else {
                self.$message.error('数据展示数据请求失败');
            }
            dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
            relates.push(relate${item_index});
        </#list>
    </#if>
    fileReader.onload = function (ev) {
        const data = ev.target.result;
        const workbook = new Excel.Workbook();
        workbook.xlsx.load(data)
            .then(function() {
                let values = [
                <#list tableShowFields! as item>
                    <#if (item_index != (tableShowFields?size-1))>
                        "${item.title}",
                    <#else>
                        "${item.title}"
                    </#if>
                </#list>
                ];
                let prop = [
                <#list tableShowFields! as item>
                    <#if (item_index != (tableShowFields?size-1))>
                        "${item.field}",
                    <#else>
                        "${item.field}"
                    </#if>
                </#list>
                ];
                <#if showConfigItemInfos??>
                    for (let i = 0; i < relates.length; i++) {
                        const tableFieldWhere = relates[i][0].tableFieldWhere;
                        prop.splice(prop.findIndex(function (item) {
                            return item === relates[i][0].field
                        }), 1, tableFieldWhere);
                    }
                </#if>
                function cellValueToDict(keys, row) {
                    const data = {};
                    row.eachCell(function(cell, colNumber) {
                        let value = cell.value;
                        if(cell.type === (Excel.ValueType.Date)) {
                            value = new Date(value.valueOf() - 8 * 60 * 60 * 1000);
                        }
                        if (dicts.length !== 0) {
                            const findIndex = dicts.findIndex(function(dictItem) {
                                return dictItem.field === prop[colNumber - 1];
                            });
                            if (findIndex !== -1) {
                                const haveValue = dicts.find(function(dictItem){
                                    return dictItem.field === prop[colNumber - 1];
                                }).dict.find(function(dictItem) {
                                    return value === dictItem.label && dictItem.field === prop[colNumber - 1];
                                }) !== undefined;
                                if (haveValue) {
                                    value = dicts.find(function(dictItem) {
                                        return dictItem.field === prop[colNumber - 1];
                                    }).dict.find(function(dictItem) {
                                        return value === dictItem.label && dictItem.field === prop[colNumber - 1];
                                    }).value;
                                }
                            }
                        }
                        data[prop[colNumber - 1]] = value;
                    });
                    return data;
                }
                const dataArray = [];
                let keys = [];
                const worksheet = workbook.getWorksheet(1); //获取第一个worksheet
                worksheet.eachRow(function(row, rowNumber) {
                    if (rowNumber == 1) {
                        keys = row.values;
                    }
                    else if (rowNumber > 1) {
                        let rowDict = cellValueToDict(keys, row);
                        dataArray.push(rowDict);
                    }
                });
                let valuesCopy = values.slice(0);
                let keysCopy = keys.filter(function(el) {
                    return el;
                }).slice(0);
                if (JSON.stringify(keysCopy.sort()) !== JSON.stringify(valuesCopy.sort())) {
                    self.$message.error('导入模板错误，请重新选择！');
                    return;
                }
        <#if unReferences?? && unReferences!>
            <#if importName?? && importName != "">
            ${importName!}['${importMethod!}']({
                    importList: JSON.stringify(dataArray)
                }).then(res => {
                    if(res) {
                        self.$message.success("导入成功");
                        if (callback && typeof callback === 'function') {
                            callback();
                        }
                        self.${tableInstanceKey}TableLoad();
                    } else {
                        self.$message.error("导入失败");
                    }
                }
                ).catch(function () {
                    self.$message.error('数据请求异常');
                })
            <#else>
            // 表格未绑定数据模型，该动作及后续动作未成功生成
            </#if>
        <#else>
            ${dataName!} = ${dataName!}.concat(dataArray);
            self.$message.success("导入成功");
        </#if>
            });
    }
    fileReader.readAsBinaryString(file);
</#if>