<#-- 根据 type 的不同，渲染不同展示格式的日期时间选择器 -->
<#if (type! == "time")>
    <h-date-time-picker
        type="${type!}"
        format="HH:mm:ss"
        popper-class="vxe-table--ignore-clear"
        <#if valueType! == "string">
            value-format="yyyy-MM-dd HH:mm:ss"
        <#else>
            value-format="yyyy-MM-dd HH:mm:ss"
        </#if>
        prefix-icon="el-icon-date"
        style="display: flex"
        <#if (placeholder??)>
            placeholder="${placeholder!}"
        </#if>
        <#if (attributes??)>
            <#list attributes! as attribute>
                ${attribute}
            </#list>
        </#if>
        <#if rangeDisabled??>
            :picker-options="{disabledDate: ${instanceKey!}DisabledDate}"
        </#if>
        <#if isRange?? && isRange>
            is-range
            :range-separator="'${rangeSeparator!}'"
            :start-placeholder="'${startPlaceholder!}'"
            :end-placeholder="'${endPlaceholder!}'"
        </#if>
    ></h-date-time-picker>
<#elseif (type! == "year")>
    <h-date-time-picker
        type="${type!}"
        format="yyyy"
        popper-class="vxe-table--ignore-clear"
    <#if valueType! == "string">
        value-format="yyyy-MM-dd HH:mm:ss"
    <#else>
        value-format="yyyy-MM-dd HH:mm:ss"
    </#if>
        prefix-icon="el-icon-date"
        style="display: flex"
        <#if (placeholder??)>
            placeholder="${placeholder!}"
        </#if>
        <#if rangeDisabled??>
            :picker-options="{disabledDate: ${instanceKey!}DisabledDate}"
        </#if>
        <#if (attributes??)>
            <#list attributes! as attribute>
                ${attribute}
            </#list>
        </#if>
    ></h-date-time-picker>
<#elseif (type! == "week")>
    <h-date-time-picker
    type="${type!}"
    format="yyyy-WW周"
    popper-class="vxe-table--ignore-clear date-range-picker week-picker shortcut-bottom"
    <#if valueType! == "string">
        value-format="yyyy-MM-dd HH:mm:ss"
    <#else>
        value-format="yyyy-MM-dd HH:mm:ss"
    </#if>
    prefix-icon="el-icon-date"
    :picker-options="{
    <#if rangeDisabled??>
        disabledDate: ${instanceKey!}DisabledDate,
    </#if>
    firstDayOfWeek: 1
    }"
    style="display: flex"
    <#if (placeholder??)>
        placeholder="${placeholder!}"
    </#if>
    <#if (attributes??)>
        <#list attributes! as attribute>
            ${attribute}
        </#list>
    </#if>
    ></h-date-time-picker>
<#elseif (type! == "month")>
    <h-date-time-picker
    type="<#if isRange?? && isRange>monthrange<#else>${type!}</#if>"
    format="yyyy-MM"
    popper-class="vxe-table--ignore-clear"
    <#if valueType! == "string">
        value-format="yyyy-MM-dd HH:mm:ss"
    <#else>
        value-format="yyyy-MM-dd HH:mm:ss"
    </#if>
    prefix-icon="el-icon-date"
    style="display: flex"
    <#if (placeholder??)>
        placeholder="${placeholder!}"
    </#if>
    <#if (attributes??)>
        <#list attributes! as attribute>
            ${attribute}
        </#list>
    </#if>
    <#if rangeDisabled??>
        :picker-options="{disabledDate: ${instanceKey!}DisabledDate}"
    </#if>
    <#if isRange?? && isRange>
        :range-separator="'${rangeSeparator!}'"
        :start-placeholder="'${startPlaceholder!}'"
        :end-placeholder="'${endPlaceholder!}'"
    </#if>
    ></h-date-time-picker>
<#elseif (type! == "date")>
    <h-date-time-picker
    type="<#if isRange?? && isRange>daterange<#else>${type!}</#if>"
    format="yyyy-MM-dd"
    popper-class="vxe-table--ignore-clear"
    <#if valueType! == "string">
        value-format="yyyy-MM-dd HH:mm:ss"
    <#else>
        value-format="yyyy-MM-dd HH:mm:ss"
    </#if>
    prefix-icon="el-icon-date"
    style="display: flex"
    <#if (placeholder??)>
        placeholder="${placeholder!}"
    </#if>
    <#if (attributes??)>
        <#list attributes! as attribute>
            ${attribute}
        </#list>
    </#if>
    <#if rangeDisabled??>
        :picker-options="{disabledDate: ${instanceKey!}DisabledDate}"
    </#if>
    <#if isRange?? && isRange>
        :range-separator="'${rangeSeparator!}'"
        :start-placeholder="'${startPlaceholder!}'"
        :end-placeholder="'${endPlaceholder!}'"
    </#if>
    ></h-date-time-picker>
<#elseif (type! == "datetime")>
    <h-date-time-picker
    type="<#if isRange?? && isRange>datetimerange<#else>${type!}</#if>"
    <#if  format?? && format! == "hourmin">
        format="yyyy-MM-dd HH:mm"
    <#elseif format?? && format! == "hour">
        format="yyyy-MM-dd HH"
    <#elseif format?? && format! == "custom" && customFormat?? && customFormat! != "">
        format="${customFormat!}"
    <#else>
        format="yyyy-MM-dd HH:mm:ss"
    </#if>
    <#if isHour?? && isHour>
        popper-class="vxe-table--ignore-clear only-hour"
    <#else>
        popper-class="vxe-table--ignore-clear"
    </#if>
    <#if valueType! == "string">
        value-format="yyyy-MM-dd HH:mm:ss"
    <#else>
        value-format="yyyy-MM-dd HH:mm:ss"
    </#if>
    prefix-icon="el-icon-date"
    style="display: flex"
    <#if (placeholder??)>
        placeholder="${placeholder!}"
    </#if>
    <#if (attributes??)>
        <#list attributes! as attribute>
            ${attribute}
        </#list>
    </#if>
    <#if rangeDisabled??>
        :picker-options="{disabledDate: ${instanceKey!}DisabledDate}"
        @input="${instanceKey!}DisableTime"
    </#if>
    <#if isRange?? && isRange>
        :range-separator="'${rangeSeparator!}'"
        :start-placeholder="'${startPlaceholder!}'"
        :end-placeholder="'${endPlaceholder!}'"
    </#if>
    ></h-date-time-picker>
</#if>
