/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IoTVisitor
implements VoidVisitor<LcdpComponent, Ctx> {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/IoT/el_IoT.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMounted(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderWatch(lcdpComponent, ctx);
        this.renderDataLoad(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        lcdpComponent.addAttr(":type", lcdpComponent.getInstanceKey() + "Type");
        ctx.addData(lcdpComponent.getInstanceKey() + "Type:'" + lcdpComponent.getProps().get("select") + "'", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"type\u5c5e\u6027"));
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMounted(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormMounted(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)String.valueOf(37.2));
        lcdpComponent.addRenderParam("valueData", (Object)valueData);
        ctx.addData(lcdpComponent.getInstanceKey() + "ThresholdList: " + lcdpComponent.getProps().get("thresholdList"), MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"thresholdList\u5c5e\u6027"));
        ctx.addData(lcdpComponent.getInstanceKey() + "Gauge: null", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"gauge\u5c5e\u6027"));
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map props = lcdpComponent.getProps();
        Integer width = lcdpComponent.getWidth();
        params.put("width", width);
        params.put("value", lcdpComponent.getRenderParams().get("valueData"));
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        params.put("progressColor", props.get("progressColor"));
        params.put("unit", props.get("unit"));
        params.put("toFixed", props.get("toFixed"));
        params.put("name", props.get("name"));
        params.put("axisLabelDistance", props.get("axisLabelDistance"));
        params.put("axisLabelColor", props.get("axisLabelColor"));
        params.put("axisLabelSize", props.get("axisLabelSize"));
        params.put("gaugeTitleColor", props.get("gaugeTitleColor"));
        params.put("gaugeTitleFontSize", props.get("gaugeTitleFontSize"));
        params.put("gaugeTitleFontWeight", props.get("gaugeTitleFontWeight"));
        params.put("gaugeTitleFontFamily", props.get("gaugeTitleFontFamily"));
        params.put("gaugeValueFontSize", props.get("gaugeValueFontSize"));
        params.put("gaugeValueFontWeight", props.get("gaugeValueFontWeight"));
        params.put("gaugeValueFontFamily", props.get("gaugeValueFontFamily"));
        params.put("isThreshold", props.get("isThreshold"));
        Integer min = (Integer)props.get("progressMin");
        Integer max = (Integer)props.get("progressMax");
        if (ToolUtil.isNotEmpty((Object)min) && ToolUtil.isNotEmpty((Object)max) && min < max) {
            params.put("progressMax", max);
            params.put("progressMin", min);
        } else {
            params.put("progressMax", min);
            params.put("progressMin", max);
            params.put("progressReverse", true);
        }
        if ("progressBarStyle".equals(props.get("changeStyle"))) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "InitStatus", Collections.singletonList("cubeCount"), RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/ioT_initProgress.ftl", params), false);
            ctx.addMounted("self." + lcdpComponent.getInstanceKey() + "InitStatus(100);");
        }
        if ("gaugeStyle".equals(props.get("changeStyle"))) {
            ctx.addImports("Echarts5", "@/utils/echartsUi");
            ctx.addComputed(lcdpComponent.getInstanceKey() + "Option", RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/ioT_option.ftl", params), false, MultilineExegesisUtil.dealComputedExegesis((LcdpComponent)lcdpComponent));
            ctx.addImports("DrawGaugePublic", "@/pages/index/utils/lowcode/loTUtil");
            ctx.addMounted("DrawGaugePublic('" + lcdpComponent.getInstanceKey() + "', self);");
        }
    }

    private void renderWatch(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map props = lcdpComponent.getProps();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        params.put("gaugeValueColor", props.get("gaugeValueColor"));
        String valueColor = "#348FE0";
        if (ToolUtil.isNotEmpty(lcdpComponent.getInnerStyles().get("valueColor"))) {
            valueColor = (String)lcdpComponent.getInnerStyles().get("valueColor");
        }
        params.put("valueColor", valueColor);
        params.put("gaugeStyle", props.get("changeStyle"));
        List eventConfigs = lcdpComponent.getEvents();
        if (lcdpComponent.haveTriggerByTriggerName("threshold")) {
            params.put("isThresholdEvent", true);
            if (ToolUtil.isNotEmpty((Object)eventConfigs)) {
                for (EventConfig eventConfig : eventConfigs) {
                    if (!"threshold".equals(eventConfig.getTrigger())) continue;
                    lcdpComponent.getTriggers().remove("threshold");
                }
            }
        }
        if ("gaugeStyle".equals(props.get("changeStyle"))) {
            ctx.addData(lcdpComponent.getInstanceKey() + "Color:'" + props.get("gaugeValueColor") + "'", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"color\u5c5e\u6027"));
        }
        ctx.addWatch(lcdpComponent.getInstanceKey() + "Data", Collections.singletonList("n"), RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/ioT_watch.ftl", params), MultilineExegesisUtil.dealWatchExegesis((LcdpComponent)lcdpComponent));
    }

    private void renderDataLoad(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Map props = lcdpComponent.getProps();
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
            Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
            String valueField = "";
            if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                        List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                        valueField = dataSFieldAnalysis.getFieldName();
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)valueField)) {
                String sortConditionName;
                DataSortConditionAnalysis dataSortConditionAnalysis;
                String querySelectionName;
                List conditionList;
                String operationName = "hussarQuery";
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = dataSModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getImportPath(dataModelId);
                }
                if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                    param.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                    param.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                }
                if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                    operationName = operationName + querySelectionName;
                }
                if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                    operationName = operationName + sortConditionName;
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                param.put("dbdHaveMethod", DataModelUtil.judgeDataModelHasOperation((String)dataModelId, (String)operationName));
                param.put("importName", apiFileName);
                param.put("importMethod", operationName);
                param.put("ioTValue", valueField);
                param.put("toFixed", props.get("toFixed"));
                param.put("changeStyle", props.get("changeStyle"));
                param.put("instanceKey", lcdpComponent.getInstanceKey());
                param.put("valueData", lcdpComponent.getRenderParams().get("valueData"));
                ctx.addMethod(lcdpComponent.getInstanceKey() + "IoTDataLoad", RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/el_IoT_data.ftl", param), false);
                ctx.addMounted("self." + lcdpComponent.getInstanceKey() + "IoTDataLoad();");
                ctx.addMounted("self." + lcdpComponent.getInstanceKey() + "PollNameDestroy = setInterval(() => {const self = this;self." + lcdpComponent.getInstanceKey() + "IoTDataLoad();}, " + props.get("refreshFrequency") + "000);");
                ctx.addDestroyeds("clearInterval(self." + lcdpComponent.getInstanceKey() + "PollNameDestroy);");
            }
        }
    }
}

