/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.elementui.utils.TextAlignForVertical;
import com.jxdinfo.hussar.formdesign.elementui.visitor.element.ButtonVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class Button
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.elementui.JXDElButton";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"focus", (String)".button_additional:focus:not(.is-disabled):not(:active)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"active", (String)".button_additional:active:not(.is-disabled):not(.focus-within)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)".is-disabled:not(.jxd_ins_elButtonReadonly)");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_elButton");
    }

    public VoidVisitor visitor() {
        return new ButtonVoidVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("iconFontWeight", "${prefix} span i{font-weight:${val};}");
        map.put("buttonMarginLeft", "${prefix} {margin-left:${val};}");
        map.put("iconFontSize", "${prefix} span i{font-size:${val};letter-spacing:0;}");
        map.put("itemAlign", "${prefix} > span {align-items:${val};}");
        map.put("itemJustifyContent", "${prefix} > span {justify-content:${val};}");
        map.put("itemDisplay", "${prefix} > span {display:${val};}");
        map.put("buttonDisplay", "${prefix} span {display:${val};}");
        map.put("textAlign", "${prefix} {text-align:${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isBorderRadiusNew", "dynamicStyleTemplate");
        map.put("isShadowNew", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border: none}";
            }
            return "";
        });
        map.put("isBorderRadiusNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border-radius: unset}";
            }
            return "";
        });
        map.put("isShadowNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {box-shadow: none}";
            }
            return "";
        });
        return (Function)map.get(key);
    }

    public static Button newComponent(JSONObject jsonObject) {
        String marginLeft;
        Button button = (Button)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)Button.class.getName()));
        Object backgroundImg = button.getStyles().get("backgroundImageBack");
        button.getStyles().remove("backgroundImageBack");
        button.getInnerStyles().put("buttonDisplay", "unset");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            button.getStyles().put("backgroundImage", backgroundImg);
        }
        if (ToolUtil.isNotEmpty((Object)(marginLeft = (String)button.getStyles().get("margin-left")))) {
            button.getInnerStyles().put("buttonMarginLeft", marginLeft);
        } else {
            button.getInnerStyles().put("buttonMarginLeft", "0");
        }
        TextAlignForVertical.setTextAlign(button, "styles");
        button.getStyles().remove("vertical");
        Object fontSize = button.getStyles().get("fontSize");
        button.getInnerStyles().put("iconFontSize", fontSize);
        button.addClassName("button_additional");
        return button;
    }
}

