<#if filterOption.type == 'CommonModel'>
    const params = {
        typeName: '${filterOption.dictType!}',
    };
    try {
        const res = await ${filterOption.apiFileName!}.${filterOption.importMethod!}(params);
        let options = [];
        if (res.code === 200 || res.code === 10000) {
            const data = res.data;
            options = formatDictToTreeData(data);
        }
        return options;
    } catch (e) {
        console.log(e);
    }
<#else>
    const params = {
    ${filterOption.queryAttr!}
    <#if filterOption.orders??>
        ${filterOption.orders}
    </#if>
    }
    <#if filterOption.lazy?? && filterOption.lazy>
      if (nodeData?.id || nodeData?.id === 0) {
        params.${filterOption.queryAttrName!} = nodeData.id;
      }
    </#if>
    <#if filterOption.queryConditions??>
        const queryConditions = self.${instanceKey!}${filterOption.value!?cap_first}ColGetQueryConditions(params);
        if (queryConditions && queryConditions.length) {
        params.superQueryConditionDto = queryConditions;
        }
    </#if>
    try {
        const res = await ${filterOption.apiFileName!}.${filterOption.importMethod!}(params);
        let options = [];
        if (res.code === 200 || res.code === 10000) {
            const data = res.data.data;
            <#if filterOption.selectValue?? && filterOption.selectValue != '' &&
            filterOption.selectLabel?? && filterOption.selectLabel != '' &&
            filterOption.selectParentId?? && filterOption.selectParentId != ''>
                options = formatModelToTreeData(data, (item)=>{
                return {
                id: item.${filterOption.selectValue!},
                label: item.${filterOption.selectLabel!},
                pid: item.${filterOption.selectParentId!},
                <#if filterOption.selectPath?? && filterOption.selectPath != ''>
                    path: item.${filterOption.selectPath!},
                </#if>
                children: []
                }
                });
            </#if>
        }
        return options;
    } catch (e) {
        console.log(e);
    }
</#if>
