${instanceKey!}PropsData: {
    <#if props??>
        <#--为了防止覆盖公共样式，仅输出修改过的props值-->
        <#if props.showIndex??> <#--序号列-->
            showIndex: ${props.showIndex?c},
        </#if>
        <#if props.indexCount??> <#--序号递增-->
            indexCount: ${props.indexCount?c},
        </#if>
        <#if props.indexWidth??> <#--序号列宽-->
            indexWidth: ${props.indexWidth!},
        </#if>
        <#if props.fixOperaColumn??> <#--固定序号列-->
            fixOperaColumn: ${props.fixOperaColumn?c},
        </#if>
        <#if props.needOperation??> <#--是否显示操作列-->
            needOperation: ${props.needOperation?c},
        </#if>
        <#if props.needOperations?? && props.needOperation?? && props.needOperation> <#--操作列菜单-->
            needOperations: [
            <#list props.needOperations as needOperation>
                <#assign keys = needOperation?keys>
                {
                <#list keys as key>
                    <#if key! == "showCondition">
                    <#--展示条件配置-->
                        showFn: (scope) => {
                        const self = this;
                        return ${needOperation[key]!};
                        },
                    <#elseif needOperation[key]?is_boolean>
                    <#--如果是布尔类型-->
                        ${key!}: ${needOperation[key]?c},
                    <#elseif key! == "label">
                        <#--操作按钮名-->
                        <#if key == "label" && needOperation.labelType == "object">
                            label: this.${needOperation[key]!},
                        <#else>
                            label: '${needOperation[key]!}',
                        </#if>
                    <#elseif needOperation[key]?is_hash && key != 'color' && key != 'bg' && key != 'borderColor'>
                    <#--如果是对象类型-->
                        <#assign needOperationKeys = needOperation[key]?keys>
                        buttonWidth: {
                        <#list needOperationKeys as needOperationKey>
                            <#if needOperation[key][needOperationKey]?is_boolean>
                                ${needOperationKey!}: ${needOperation[key][needOperationKey]?c},
                            <#else>
                                ${needOperationKey!}: ${needOperation[key][needOperationKey]!},
                            </#if>
                        </#list>
                        },
                    <#elseif needOperation[key]?? && (key == 'color' || key == 'bg' || key == 'borderColor') && needOperation[key]?is_hash>
                        ${key!}: {
                          color: '${needOperation[key].color!}',
                          related: {
                            color: '${needOperation[key].related.color!}'
                          },
                          useRelated: ${needOperation[key].useRelated?c},
                        },
                    <#elseif needOperation[key]?? && ((needOperation[key]?index_of("{") == 0 && needOperation[key]?index_of("}") == (needOperation[key]?length - 1))
                    || needOperation[key]?is_number)>
                        <#--如果是对象和数字，就不需要加引号-->
                        ${key!}: ${needOperation[key]!},
                    <#else>
                        ${key!}: '${needOperation[key]!}',
                    </#if>
                </#list>
                },
            </#list>
            ],
        </#if>
        <#if filterColumns??> <#--可条件筛选的列-->
            filterColumns: [
            <#list filterColumns as filterColumn>
                <#assign keys = filterColumn?keys>
                {
                <#list keys as key>
                    ${key!}:
                    <#if filterColumn.titleType == "object" && key == 'title'>
                        ${filterColumn[key]!}
                    <#elseif key != 'options' && key != 'checkStrictly' && key != 'lazy'>
                        '${filterColumn[key]!}'
                    <#elseif key == 'options' >
                        [
                        <#list filterColumn.options as option>
                            {
                                name: '${option.name}',
                                value: <#if option.type == 'string'>'${option.value}'<#else >${option.value}</#if>
                            },
                        </#list>
                        ]
                    <#else>
                        ${filterColumn[key]!}
                    </#if>,
                    <#if key == 'componentType' && (filterColumn[key] == 'JXDNSelectTree' || filterColumn[key] == 'JXDNSelectTreeMulti')>
                        load: this.${instanceKey!}${filterColumn.field!?cap_first}ColReplaceFilterOptions,
                        <#if filterColumn.lazy?? && filterColumn.lazy == 'true'>
                            echo: this.${instanceKey!}${filterColumn.field!?cap_first}ColEchoValue,
                        </#if>
                    </#if>
                </#list>
                },
            </#list>
            ],
        </#if>
        <#if props.needOperationAutoWidth??> <#--操作列是否默认列宽-->
            needOperationAutoWidth: ${props.needOperationAutoWidth?c},
        </#if>
        <#if props.needOperationWidth??> <#--操作列列宽-->
            needOperationWidth: ${props.needOperationWidth!},
        </#if>
        <#if props.needOperationAdaptionWidth??> <#--操作列是否自适应列宽-->
            needOperationAdaptionWidth: ${props.needOperationAdaptionWidth?c},
        </#if>
        <#if props.needOperationComputedAdaptionWidth??> <#--操作列自适应列宽-->
            needOperationComputedAdaptionWidth: ${props.needOperationComputedAdaptionWidth!},
        </#if>
        <#if props.needOperationFixed??> <#--操作列是否固定-->
            needOperationFixed: ${props.needOperationFixed?c},
        </#if>
        <#if props.needOperationBtnAutoWidth??> <#--操作列按钮宽度自适应-->
            needOperationBtnAutoWidth: ${props.needOperationBtnAutoWidth?c},
        </#if>
        <#if props.needOperationName??> <#--操作列列名-->
            needOperationName: hussar_t({key: '${props.needOperationName.internationalCode!}', fallbackStr: '${props.needOperationName.name!}'}),
        </#if>
        <#if props.showSelection??> <#--复选框-->
            showSelection: ${props.showSelection?c},
        </#if>
        <#if props.showToolbar?? && isApp?? && isApp> <#--工具栏-->
            showToolbar: false,
        <#elseif props.showToolbar??> <#--工具栏-->
            showToolbar: ${props.showToolbar?c},
        </#if>
        <#if props.showCustomList??> <#--自定义显示方案-->
            showCustomList: ${props.showCustomList?c},
        </#if>
        <#if props.isPagination??> <#--是否开启分页-->
            isPagination: ${props.isPagination?c},
        </#if>
        <#if props.showFilter?? && props.showFilter> <#--查询管理-->
            showFilter: ${props.showFilter?c},
            filterConfig: [],
            selectFilterId: '',
        </#if>
        <#if props.complexFilter??> <#--高级查询-->
            complexFilter: ${props.complexFilter?c},
        </#if>
        <#if props.showControlFilter??> <#--控制查询方案显隐-->
            showControlFilter: ${props.showControlFilter?c},
        </#if>
        <#if props.showExport??> <#--导出-->
            showExport: ${props.showExport?c},

        </#if>
        <#if props.showSort??> <#--高级查询-->
            showSort: ${props.showSort?c},
        </#if>
        hiddenCols: [
        <#if props.hidden_cols??>
            <#list props.hidden_cols as col>
                {
                title: '${col.title!}',
                field: '${col.field!}',
                },
            </#list>
        </#if>
        ],
        isVfg: true,
    </#if>
},
${instanceKey!}InnerStyles: {
    <#if isCheckedXHeadBorderColor??> <#--表头横边框-->
        isCheckedXHeadBorderColor: ${isCheckedXHeadBorderColor?c},
    </#if>
    <#if isCheckedYHeadBorderColor??> <#--表头竖边框-->
        isCheckedYHeadBorderColor: ${isCheckedYHeadBorderColor?c},
    </#if>
    <#if isCheckedXBodyBorderColor??> <#--表体横边框-->
        isCheckedXBodyBorderColor: ${isCheckedXBodyBorderColor?c},
    </#if>
    <#if isCheckedYBodyBorderColor??> <#--表体竖边框-->
        isCheckedYBodyBorderColor: ${isCheckedYBodyBorderColor?c},
    </#if>
}