<#if tableInstanceKey?? && tableInstanceKey != "" && maxLevel??>
    const file = event.currentTarget.files[0];
    let success = false;
    const startIndex = file.name.lastIndexOf(".");
    if (startIndex < 0) {
        HussarRouter.showMsg(self, "文件格式错误，请重新选择！", 'error');
        return;
    }
    const types = file.name.slice(startIndex + 1);
    const fileType = ["xlsx"].some(
        item => item === types
    );
    if (!fileType) {
        HussarRouter.showMsg(self, "文件格式错误，请重新选择！", 'error');
        return;
    }
    const Excel = require("exceljs");
    const fileReader = new FileReader();
    const dicts = [];
    const relates = [];
    <#if showConfigItemInfos??>
        <#list showConfigItemInfos! as item>
            <#if item.isConfigComplete && item.commonModelType?? >
                const dict${item_index} = [];
                const relate${item_index} = [];
                <#if !item.dictType?? || item.dictType == "">
                    const ${item.importName!}Obj${item_index} = {};
                <#else>
                    const ${item.importName!}Obj${item_index} = {
                    typeName: '${item.dictType}',
                    };
                </#if>
                const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                HussarRouter.showMsg(self, "数据请求异常", 'error');
                });
                const data${item_index} = res${item_index}.data;
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                // 数据展示字典表
                if (data${item_index} && data${item_index}.length > 0) {
                for (let i = 0; i < data${item_index}.length; i++) {
                dict${item_index}.push({
                field: '${item.tableFieldWhere!}',
                value: data${item_index}[i].value,
                label: data${item_index}[i].label
                });
                }
                relate${item_index}.push({
                tableFieldWhere: '${item.tableFieldWhere!}',
                field: '${item.tableFieldWhere!}'
                });
                }
                } else {
                HussarRouter.showMsg(self, "数据展示数据请求失败", 'error');
                }
                dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
                relates.push(relate${item_index});
            <#elseif item.isConfigComplete>
                const dict${item_index} = [];
                const relate${item_index} = [];
                const ${item.importName!}Obj${item_index} = {
                inValues: '',
                ${item.queryObjectAttr!}
                };
                const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                HussarRouter.showMsg(self, "数据请求异常", 'error');
                });
                const data${item_index} = res${item_index}.data;
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                // 数据展示数据模型
                if (data${item_index}.data && data${item_index}.data.length > 0) {
                for (let i = 0; i < data${item_index}.data.length; i++) {
                <#list item.mappingRelates! as mapping>
                    dict${item_index}.push({
                    field: '${item.tableFieldWhere!}',
                    value: data${item_index}.data[i].${item.relateTableFieldWhere!},
                    label: data${item_index}.data[i].${mapping.relateField!}
                    });
                </#list>
                }
                <#list item.mappingRelates! as mapping>
                    relate${item_index}.push({
                    tableFieldWhere: '${item.tableFieldWhere!}',
                    field: '${mapping.field!}'
                    });
                </#list>
                }
                } else {
                HussarRouter.showMsg(self, "数据展示数据请求失败", 'error');
                }
                dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
                relates.push(relate${item_index});
            </#if>
        </#list>
    </#if>
    fileReader.onload = function (ev) {
        const data = ev.target.result;
        const workbook = new Excel.Workbook();
        workbook.xlsx.load(data)
            .then(function() {
                const values = [
                <#list tableShowFields! as item>
                    <#if (item_index != (tableShowFields?size-1))>
                        "${item.title}",
                    <#else>
                        "${item.title}"
                    </#if>
                </#list>
                ];
                const prop = [
                <#list tableShowFields! as item>
                    <#if (item_index != (tableShowFields?size-1))>
                        "${item.field}",
                    <#else>
                        "${item.field}"
                    </#if>
                </#list>
                ];
                <#if showConfigItemInfos??>
                    for (let i = 0; i < relates.length; i++) {
                        if (relates[i][0]) {
                            const tableFieldWhere = relates[i][0].tableFieldWhere;
                            prop.splice(prop.findIndex(function (item) {
                                return item === relates[i][0].field
                            }), 1, tableFieldWhere);
                        } else {
                           HussarRouter.showMsg(self, "数据展示数据请求失败", 'error');
                        }
                    }
                </#if>
                function cellValueToDict(keys, row) {
                    const data = {};
                    const delCols = [];
                    values.forEach((item, index) => {
                        if (keys.indexOf(item) === -1) {
                            delCols.push(index);
                        }
                    });
                    row.eachCell(function(cell, colNumber) {
                        let value = cell.value;
                        if(cell.type === (Excel.ValueType.Date)) {
                            value = new Date(value.valueOf() - 8 * 60 * 60 * 1000);
                        }
                        if (dicts.length !== 0) {
                            let findIndex;
                            if (delCols.length > 0 && values.indexOf(keys[colNumber]) > -1) {
                                const index = values.indexOf(keys[colNumber]);
                                findIndex = dicts.findIndex(dictItem => dictItem.field === prop[index]);
                            } else {
                                findIndex = dicts.findIndex(dictItem => dictItem.field === prop[colNumber - 1]);
                            }
                            if (findIndex !== -1) {
                                if (value.toString().includes(',')) {
                                    const valueArr = [];
                                    value.split(',').forEach(function (val) {
                                        const dictItem =
                                            dicts[findIndex]
                                                .dict.find(function (dictItem) {
                                                    return val === dictItem.label && dictItem.field === prop[colNumber - 1];
                                                });
                                        if (dictItem) {
                                            valueArr.push(dictItem.value);
                                        } else {
                                            valueArr.push(value);
                                        }
                                    });
                                    value = valueArr.join(',');
                                } else {
                                    let dictItem;
                                    if (delCols.length > 0 && values.indexOf(keys[colNumber]) > -1) {
                                        dictItem = dicts[findIndex].dict.find(function (dictItem) {
                                            return value.toString() === dictItem.label.toString() && dictItem.field === prop[values.indexOf(keys[colNumber])];
                                        });
                                    } else {
                                        dictItem = dicts[findIndex].dict.find(function (dictItem) {
                                            return value.toString() === dictItem.label.toString() && dictItem.field === prop[colNumber - 1];
                                        });
                                    }
                                    if (dictItem) {
                                        value = dictItem.value;
                                    }
                                }
                            }
                        }
                        if (delCols.length > 0) {
                            if (values.indexOf(keys[colNumber]) > -1) {
                                data[prop[values.indexOf(keys[colNumber])]] = value;
                            }
                        } else {
                            data[prop[colNumber - 1]] = value;
                        }
                    });
                    return data;
                }
                const dataArray = [];
                let keys = [];
                const worksheet = workbook.worksheets[0]; // 获取第一个worksheet
                worksheet.eachRow(function(row, rowNumber) {
                    if (rowNumber === ${maxLevel!}) {
                        keys = row.values;
                    }
                    else if (rowNumber > ${maxLevel!}) {
                        const rowDict = cellValueToDict(keys, row);
                        dataArray.push(rowDict);
                    }
                });
                const valuesCopy = values.slice(0);
                const keysCopy = keys.filter(function(el) {
                    return el;
                }).slice(0);
<#--                if (JSON.stringify(keysCopy.sort()) !== JSON.stringify(valuesCopy.sort())) {-->
<#--                    HussarRouter.showMsg(self, "导入模板错误，请重新选择！", 'error');-->
<#--                    return;-->
<#--                }-->
        <#if unReferences?? && unReferences!>
            <#if importName?? && importName != "" && dbdHaveMethod?? && dbdHaveMethod>
                //  处理时间格式问题开始
                dataArray.forEach(function (item) {
                    for (const val in item) {
                        if (item[val] instanceof Date) {
                            item[val] = dateFormatPublic('datetime', item[val]);
                        }
                    }
                })
                // 处理时间格式问题结束
            const loading = self.$loading({
            lock: true,
            text: '导入中...',
            spinner: 'el-icon-loading',
            background: 'rgba(0, 0, 0, 0.7)'
            });
            ${importName!}.${importMethod!}({
                    importList: JSON.stringify(dataArray)
                }).then(res => {
                    if(res.success) {
                        success = true;
                        HussarRouter.showMsg(self, "导入成功", 'success');
                        loading.close();
                        self.${tableInstanceKey}TableLoad();
                    } else {
                       loading.close();
                       HussarRouter.showMsg(self, "导入失败", 'error');
                }
                    ${callbackCode!}
                }
                ).catch(function () {
                    loading.close();
                    HussarRouter.showMsg(self, "数据请求异常", 'error');
                })
            <#else>
                ${callbackCodeWithoutData!}
            </#if>
        <#elseif dataName??>
            ${dataName!} = ${dataName!}.concat(dataArray);
            HussarRouter.showMsg(self, "导入成功", 'success');
        </#if>
            });
    }
    fileReader.readAsBinaryString(file);
</#if>