/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.publish;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.VueCodeGenerateService;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueCodeResult;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueGenerateResult;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.file.VuePathService;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfigInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolCacheUtile;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.common.visitor.CodePublisher;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.StyleScheme;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseConfig;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@ClientKind(kind="com.jxdinfo.WebPage.publish")
@Component(value="com.jxdinfo.WebPage.publish")
public class VueCodePublishImpl
implements CodePublisher {
    private final PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    public static final String KIND = "com.jxdinfo.WebPage.publish";
    private final VersionManageService versionManageService = (VersionManageService)SpringContextHolder.getBean(VersionManageService.class);
    private final FilePublishService filePublishService = (FilePublishService)SpringContextHolder.getBean(FilePublishService.class);
    private final CodeMergeService codeMergeService = (CodeMergeService)SpringContextHolder.getBean(CodeMergeService.class);
    private final VueCodeGenerateService vueCodeGenerateService = (VueCodeGenerateService)SpringContextHolder.getBean(VueCodeGenerateService.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final IHussarThemeConfigService iHussarThemeConfigService = (IHussarThemeConfigService)SpringContextHolder.getBean(IHussarThemeConfigService.class);
    private final CodePublishTool codePublishTool = (CodePublishTool)SpringContextHolder.getBean(CodePublishTool.class);
    public static final String JS = ".js";
    private static final String PREFIX_COMMON_JS = "prefixCommon.js";
    private static final String PREFIX_PATH = "/src/pages/index";

    public void publish(PublishCtx<CodeResult> publishCtx, ThemeVars themeVars) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        PageInfo pageInfo = (PageInfo)publishCtx.getBaseFile();
        String id = pageInfo.getId();
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(pageInfo.getId());
        String pageName = pageInfo.getName();
        String pageInfoDataJson = pageInfo.getData();
        JSONObject pageInfoDataJsonObject = JSON.parseObject((String)pageInfoDataJson);
        StyleScheme styleScheme = this.iHussarThemeConfigService.getCurrentSysThemeInfo();
        ThemeBaseConfig themeBaseConfig = styleScheme.getThemeBase().getWebPage();
        Map scssVars = styleScheme.getScssVars().getWebPage();
        VueGenerateResult codeFormatResult = this.vueCodeGenerateService.vueGenerate(pageInfoDataJsonObject, pageName, pageInfo, themeVars.getWebPage(), strategy, themeBaseConfig, scssVars);
        String newContent = codeFormatResult.getCodeFormatCode();
        UpgradeConfigInfo upgradeConfigInfo = codeFormatResult.getUpgradeConfigInfo();
        ToolCacheUtile.evict((String)("upgrade" + id), (String)("replacedId" + id));
        ToolCacheUtile.evict((String)("upgrade" + id), (String)("configInfo" + id));
        if (HussarUtils.isNotEmpty((Object)upgradeConfigInfo) && HussarUtils.isNotEmpty((Object)upgradeConfigInfo.getUpgradeConfigs())) {
            List listOfIds = upgradeConfigInfo.getUpgradeConfigs().stream().map(UpgradeConfig::getUpgradeId).collect(Collectors.toList());
            ToolCacheUtile.put((String)("upgrade" + id), (String)("replacedId" + id), listOfIds);
            ToolCacheUtile.put((String)("upgrade" + id), (String)("configInfo" + id), (Object)upgradeConfigInfo);
        }
        if (!codeFormatResult.isSucceed()) {
            String projectPagePath = this.webProjectVue(strategy, this.fileMappingService.getFormatPath(id) + this.formDesignProperties.getPageSuffix()).getLocalPath();
            VueCodeResult codeResult = new VueCodeResult();
            codeResult.setId(id);
            codeResult.setDataId(id);
            codeResult.setNewCode(newContent);
            codeResult.setResultType(ResultBeanEnum.VUE_RESULT);
            codeResult.setType("vue");
            codeResult.setFilePath(projectPagePath);
            codeResult.setCodeFormatSucceed(codeFormatResult.isSucceed());
            codeResult.setCodeFormatMessages(codeFormatResult.getMessages());
            codeResult.setMsg(codeFormatResult.getMsg());
            publishCtx.addCodeResult((CodeResult)codeResult);
            return;
        }
        newContent = CodeSplitUtil.removeEmptyLines((String)newContent);
        this.filePublishService.writePublishSourceToCache(id, "web");
        if (ToolUtil.isNotEmpty((Object)strategy)) {
            this.finallyWrite(publishCtx, newContent);
            this.compile(moduleRelatePath, pageInfo.getName(), strategy);
            return;
        }
        String ifEnvIp = (String)BaseSecurityUtil.getUser().getExtendUserMap().get("ifEnvIp");
        if (VfgModeTool.isRemote()) {
            boolean codeComparison = true;
            if ("0".equals(ifEnvIp) || "1".equals(ifEnvIp) && !codeComparison) {
                this.finallyWrite(publishCtx, newContent);
                return;
            }
        }
        this.merge(publishCtx, newContent);
    }

    public void gitPush() {
        if (VfgModeTool.isRemote()) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStore(new String[0]).getLocalPath());
            paths.add(((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().backProjectJava(new String[0]).getLocalPath());
            VuePathService vuePathService = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).vuePathService();
            paths.add(vuePathService.getCloudFrontProjectPath(vuePathService.getFrontProjectPath(), new String[]{"src"}));
            VfgModeTool.pushToRemoteImmediately((String)String.format("\u63d0\u4ea4\u4ee3\u7801\uff1a%s", paths), paths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(PublishCtx<CodeResult> publishCtx, String newContent) throws LcdpException, IOException {
        PageInfo pageInfo = (PageInfo)publishCtx.getBaseFile();
        String id = pageInfo.getId();
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(pageInfo.getId());
        String pageName = pageInfo.getName();
        Optional<String> ancestorContent = Optional.ofNullable(this.versionManageService.getAncestorCodeById(id));
        Optional<String> lastFileContent = Optional.ofNullable(this.versionManageService.getLastFileCode(id));
        String pagePath = this.webProjectVue(null, moduleRelatePath, pageName + this.formDesignProperties.getPageSuffix()).getLocalPath();
        Optional<String> currentContent = Optional.ofNullable(this.filePublishService.readCurrentPublishedFile(pagePath));
        if (ancestorContent.isPresent() && currentContent.isPresent()) {
            MergeResult mergeResult;
            boolean isConflict;
            String lastPulishCode = ancestorContent.get();
            String currentFileCode = currentContent.get();
            String lastFile = "";
            if (lastFileContent.isPresent()) {
                lastFile = lastFileContent.get();
            }
            if (!(isConflict = (mergeResult = this.codeMergeService.structuralMerge(pagePath, ExtractFileType.VUE, lastPulishCode, currentFileCode, newContent, lastFile, true)).isConflict())) {
                try {
                    this.genWebCode(pageInfo, mergeResult.getMergedCode(), null, publishCtx);
                }
                finally {
                    this.versionManageService.saveLastPublishCode(id, newContent);
                    this.versionManageService.saveLastFileCode(id, mergeResult.getMergedCode());
                }
            } else {
                String projectPagePath = this.webProjectVue(null, this.fileMappingService.getFormatPath(id) + this.formDesignProperties.getPageSuffix()).getLocalPath();
                this.codePublishTool.assembleCode(id, publishCtx, newContent, currentContent, mergeResult, projectPagePath, false);
                this.genWebCode(pageInfo, newContent, null, publishCtx);
            }
        } else {
            this.finallyWrite(publishCtx, newContent);
        }
    }

    private void finallyWrite(PublishCtx<CodeResult> publishCtx, String newContent) throws IOException, LcdpException {
        PageInfo pageInfo = (PageInfo)publishCtx.getBaseFile();
        String id = pageInfo.getId();
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        this.genWebCode(pageInfo, newContent, strategy, publishCtx);
        this.versionManageService.saveLastPublishCode(id, newContent);
        this.versionManageService.saveLastFileCode(id, newContent);
    }

    private void genWebCode(PageInfo pageInfo, String code, Integer strategy, PublishCtx<CodeResult> publishCtx) throws LcdpException, IOException {
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(pageInfo.getId());
        this.writeVueCode(code, moduleRelatePath, pageInfo.getName(), strategy, publishCtx.getBaseFile().getId());
        String pageId = pageInfo.getId();
        this.filePublishService.writePublishResourceToCache(pageId, pageInfo, publishCtx.getPublishDTO());
        this.getCommon(pageInfo);
    }

    public void writeVueCode(String fileContent, String modulePath, String pageName, Integer strategy, String pageId) throws IOException {
        String filePath = this.webProjectVue(strategy, modulePath, pageName + this.formDesignProperties.getPageSuffix()).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        this.filePublishService.writeStringToFile(fileContent, filePath, pageId);
    }

    private void getCommon(PageInfo pageInfo) throws LcdpException, IOException {
        VuePathService vuePathService = this.pathStrategy.vuePathService();
        String pageId = pageInfo.getId();
        HashMap<String, String> map = new HashMap<String, String>(2);
        String prefix = AppContextUtil.getUnionPrefix();
        prefix = ToolUtil.isNotEmpty((Object)prefix) ? FileUtil.posixPath((String[])new String[]{prefix}) : prefix;
        map.put("name", VfgModeTool.isModularization() ? String.format("%s/%s", this.formDesignProperties.getEnvServeName(), prefix) : prefix);
        map.put("pathName", ToolUtil.isEmpty((Object)prefix) ? "" : FileUtil.posixPath((String[])new String[]{"/", prefix}));
        map.put("pathName", this.pathStrategy.vuePathService().getPathName());
        String newCode = RenderUtil.renderTemplate((String)"prefixCommon/prefixCommon.ftl", map);
        String filePath = this.webProject(vuePathService.posixFilePathPrefix(PREFIX_PATH, new String[]{PREFIX_COMMON_JS})).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        this.filePublishService.writeStringToFile(newCode, filePath, pageId);
        if (VfgModeTool.isModularization()) {
            String mainJsPath = FileUtil.posixPath((String[])new String[]{vuePathService.getFrontProjectPath(), "src", "main.js"});
            String mainContent = FileUtils.readFileToString((File)new File(mainJsPath), (Charset)StandardCharsets.UTF_8);
            String moduleRelatePath = this.fileMappingService.getFormatParentPath(pageId);
            String pageName = pageInfo.getName();
            String vueRelativePath = FileUtil.posixPath((String[])new String[]{vuePathService.getVueCodePath(null), moduleRelatePath, pageName}).replace("/src", "");
            String vueAbsolutePath = FileUtil.posixPath((String[])new String[]{vuePathService.prefix(), moduleRelatePath, pageName});
            String onlyVar = FileUtil.systemPath((String[])new String[]{FileUtil.posixPath((String[])new String[]{moduleRelatePath, pageName})}).replace(File.separator, "_");
            String importVue = String.format("const %s = () => import('.%s')", onlyVar, vueRelativePath);
            String constructVue = String.format("\t'%s': %s", vueAbsolutePath, onlyVar);
            String importVueUpdate = ToolUtil.parseAndUpdate((String)mainContent, (String)importVue, (String)"/* @import vue start */", (String)"/* @import vue end */", (String)";");
            String constructUpdate = ToolUtil.parseAndUpdate((String)importVueUpdate, (String)constructVue, (String)"/* @construct vue start */", (String)"/* @construct vue end */", (String)",");
            this.filePublishService.writeStringToFile(constructUpdate, mainJsPath, pageId);
        }
    }

    private void compile(String moduleRelatePath, String pageName, Integer strategy) throws LcdpException {
        HashMap<String, String> compileParams = new HashMap<String, String>();
        String pageJSName = "__" + pageName;
        String tmpCompileJsPath = this.webProjectVue(strategy, moduleRelatePath, pageJSName + JS).getLocalPath();
        String publishVueRelativePath = FileUtil.posixPath((String[])new String[]{".", pageName});
        if (ToolUtil.isNotEmpty((Object)moduleRelatePath)) {
            moduleRelatePath = moduleRelatePath.substring(0, 1).equals("/") ? moduleRelatePath.substring(1) : moduleRelatePath;
        }
        String tmpCompileJs = ToolUtil.loadResource(this.getClass(), (String)"/template/compileTemplate.js");
        tmpCompileJs = tmpCompileJs.replace("${vuePath}", publishVueRelativePath);
        this.filePublishService.writeStringToFile(tmpCompileJs, tmpCompileJsPath);
        compileParams.put("entry", tmpCompileJsPath);
        compileParams.put("template", this.webProject(this.formDesignProperties.getFrontCompileHtmlPath()).getLocalPath());
        compileParams.put("output", FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getFrontCompilePath(), AppContextUtil.getUnionPrefix(), moduleRelatePath, File.separator}));
        compileParams.put("name", pageName);
        compileParams.put("path", moduleRelatePath);
        this.codePublishTool.compile(publishVueRelativePath, compileParams, this.formDesignProperties.getFrontCompileServer());
    }

    private ResourcePath webProjectVue(Integer strategy, String ... pathSegments) {
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String localPrefix = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{this.pathStrategy.vuePathService().getVueCodePath(strategy)});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private ResourcePath webProject(String ... pathSegments) {
        String frontProjectPath = this.pathStrategy.vuePathService().getFrontProjectPath();
        String localPrefix = this.pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[0]);
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }
}

