/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.elementui.visitor.element.CameraVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class Camera
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.elementui.Camera";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"focus", (String)":focus");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)":disabled");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_camera");
    }

    public VoidVisitor visitor() {
        return new CameraVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("playButton", "${prefix} video::-webkit-media-controls-play-button {display:${val};}");
        map.put("timeline", "${prefix} video::-webkit-media-controls-timeline {display:${val};}");
        map.put("currentTimeDisplay", "${prefix} video::-webkit-media-controls-current-time-display {display:${val};}");
        map.put("timeRemainingDisplay", "${prefix} video::-webkit-media-controls-time-remaining-display {display:${val};}");
        map.put("volumeSlider", "${prefix} video::-webkit-media-controls-volume-slider {display:${val};}");
        map.put("top", "${prefix} .el-dialog {top:${val};}");
        map.put("left", "${prefix} .el-dialog {left:${val};}");
        map.put("dialogBody", "${prefix} .el-dialog__body { padding: 0;font-size: 0;}");
        map.put("dialogHeader", "${prefix} .el-dialog__header {padding: 0;}");
        map.put("dialog", "${prefix} .el-dialog{ display: flex;flex-direction: column;margin: 0 !important;position: absolute;}");
        map.put("button", "${prefix} .el-dialog__header .el-dialog__headerbtn {z-index: 1;top: 5px;right: 5px;}${prefix} .el-dialog__headerbtn:focus .el-dialog__close {color: #909399;} ${prefix} .el-dialog__headerbtn:hover .el-dialog__close {color: #909399;}");
        map.put("cursor", "${prefix} {cursor:${val};}");
        map.put("fontSize", "${prefix} .jxd-el-camera {font-size:${val};}");
        map.put("closeButtonSize", "${prefix} .jxd-el-close {font-size:${val};}${prefix} .el-icon-close {font-size:${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isBorderRadiusNew", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border: none}";
            }
            return "";
        });
        map.put("isBorderRadiusNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border-radius: unset}";
            }
            return "";
        });
        return (Function)map.get(key);
    }

    public static Camera newComponent(JSONObject jsonObject) {
        Camera camera = (Camera)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)Camera.class.getName()));
        Object backgroundImg = camera.getStyles().get("backgroundImageBack");
        camera.getStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            camera.getStyles().put("backgroundImage", backgroundImg);
        }
        Boolean showIcon = (Boolean)camera.getProps().get("showIcon");
        String dialogLocation = "";
        String dialogHeight = "";
        String dialogWidth = "";
        if (showIcon.booleanValue()) {
            dialogLocation = camera.getProps().get("dialogLocation").toString();
            dialogHeight = camera.getProps().get("dialogHeight").toString();
            dialogWidth = camera.getProps().get("dialogWidth").toString();
        }
        String top = "";
        String left = "";
        if ("left".equals(dialogLocation)) {
            top = "calc((100% - " + dialogHeight + "px) / 2);";
            left = "2%";
        } else if ("leftTop".equals(dialogLocation)) {
            top = "2%";
            left = "2%";
        } else if ("top".equals(dialogLocation)) {
            top = "2%";
            left = "calc((100% - " + dialogWidth + "px) / 2);";
        } else if ("center".equals(dialogLocation)) {
            top = "calc((100% - " + dialogHeight + "px) / 2);";
            left = "calc((100% - " + dialogWidth + "px) / 2);";
        } else if ("rightTop".equals(dialogLocation)) {
            top = "2%";
            left = "calc(98% - " + dialogWidth + "px)";
        } else if ("right".equals(dialogLocation)) {
            top = "calc((100% - " + dialogHeight + "px) / 2);";
            left = "calc(98% - " + dialogWidth + "px)";
        } else if ("rightBottom".equals(dialogLocation)) {
            top = "calc(98% - " + dialogHeight + "px)";
            left = "calc(98% - " + dialogWidth + "px)";
        } else if ("bottom".equals(dialogLocation)) {
            top = "calc(98% - " + dialogHeight + "px)";
            left = "calc((100% - " + dialogWidth + "px) / 2);";
        } else if ("leftBottom".equals(dialogLocation)) {
            top = "calc(98% - " + dialogHeight + "px)";
            left = "2%";
        }
        camera.getInnerStyles().put("playButton", "none");
        camera.getInnerStyles().put("timeline", "none");
        camera.getInnerStyles().put("currentTimeDisplay", "none");
        camera.getInnerStyles().put("timeRemainingDisplay", "none");
        camera.getInnerStyles().put("volumeSlider", "none");
        camera.getInnerStyles().put("dialogBody", "none");
        camera.getInnerStyles().put("dialogHeader", "none");
        camera.getInnerStyles().put("dialog", "none");
        camera.getInnerStyles().put("top", top);
        camera.getInnerStyles().put("left", left);
        camera.getInnerStyles().put("cursor", "pointer");
        camera.getInnerStyles().put("button", "none");
        String fs = "";
        fs = camera.getStyles().containsKey("fontSize") ? camera.getStyles().get("fontSize").toString() : "48px";
        camera.getInnerStyles().put("fontSize", fs);
        camera.getStyles().remove("vertical");
        return camera;
    }
}

