/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.cascade;

import com.alibaba.fastjson.JSONObject;
import com.google.common.io.Files;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;

@ClientKind(kind="com.jxdinfo.Workflow.cascade")
public class WorkflowCascadeImpl
implements ResourceCascadeVisitor {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    public static final String KIND = "com.jxdinfo.Workflow.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException {
    }

    public void cascadeCopy(String id, String newId, String newName, String parentPath) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        String rootPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath()});
        String parentPath = this.getMetaPath(parentId);
        try {
            WorkflowInfo workflowInfo = (WorkflowInfo)JSONObject.parseObject((String)FileUtils.readFileToString((File)new File(this.relativeToAbsolute(this.fileMappingService.getDataPath(id) + ".meta", rootPath)), (String)"UTF-8"), WorkflowInfo.class);
            String eName = workflowInfo.geteName();
            this.deleteAncestor(eName);
            String workFlowName = eName.split(":")[0].replace("_", "");
            String saveJavaFilePathPrefix = ((ResourcePathService)SpringContextUtil.getBean(ResourcePathService.class)).backProjectJava(new String[]{AppContextUtil.getServiceID().replace("-", ""), "bpmvisitor", this.fileMappingService.getFormatParentPath(id), workFlowName}).getLocalPath().toLowerCase();
            String bpmToPath = ((ResourcePathService)SpringContextUtil.getBean(ResourcePathService.class)).backProjectJava(new String[]{AppContextUtil.getServiceID().replace("-", ""), "bpmvisitor", parentPath}).getLocalPath().toLowerCase();
            File bpmFrom = new File(saveJavaFilePathPrefix);
            File bpmTo = new File(bpmToPath);
            if (bpmFrom.exists()) {
                if (!bpmTo.exists()) {
                    FileUtils.forceMkdir((File)bpmTo);
                }
                if (!workFlowName.isEmpty()) {
                    bpmTo = new File(bpmToPath + File.separator + workFlowName);
                    if (!bpmTo.exists()) {
                        FileUtils.moveDirectory((File)bpmFrom, (File)bpmTo);
                    } else {
                        FileUtils.moveDirectoryToDirectory((File)bpmFrom, (File)bpmTo, (boolean)false);
                    }
                    this.iteratorFile(bpmTo, this.fileMappingService.getFormatParentPath(id), parentPath);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void iteratorFile(File file, String oldName, String newName) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorFile(childFile, oldName, newName);
                    }
                }
            } else {
                List lines = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
                String packagePath = (String)lines.get(0);
                lines.remove(0);
                lines.add(0, packagePath.replace(".bpmvisitor" + oldName.replace("/", ".").replace("\\", ".").replace("//", ".").replace("\\\\", "."), ".bpmvisitor" + newName.replace("/", ".").replace("\\", ".").replace("//", ".").replace("\\\\", ".")));
                System.out.println((String)lines.get(0));
                FileOutputStream outputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                for (String line : lines) {
                    bufferedWriter.write(line + "\r\n");
                }
                bufferedWriter.close();
                outputStreamWriter.close();
                outputStream.close();
            }
        }
    }

    public void cascadeDelete(String id) throws LcdpException {
        String rootPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath()});
        try {
            WorkflowInfo workflowInfo = (WorkflowInfo)JSONObject.parseObject((String)FileUtils.readFileToString((File)new File(this.relativeToAbsolute(this.fileMappingService.getDataPath(id) + ".meta", rootPath)), (String)"UTF-8"), WorkflowInfo.class);
            String eName = workflowInfo.geteName();
            this.deleteAncestor(eName);
            String workFlowName = eName.split(":")[0].replace("_", "");
            String saveJavaFilePathPrefix = ((ResourcePathService)SpringContextUtil.getBean(ResourcePathService.class)).backProjectJava(new String[]{AppContextUtil.getServiceID().replace("-", ""), "bpmvisitor", this.fileMappingService.getFormatParentPath(id), workFlowName}).getLocalPath().toLowerCase();
            if (new File(saveJavaFilePathPrefix).exists()) {
                FileUtils.forceDelete((File)new File(saveJavaFilePathPrefix));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    void deleteAncestor(String id) throws IOException {
        String publishPath = this.getPublishVersionFilePathById(id);
        if (new File(publishPath).exists()) {
            FileUtils.forceDelete((File)new File(publishPath));
        }
    }

    String getPublishVersionFilePathById(String id) {
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), "/publish/version/ancestor", id.replace("_", "/") + "hussar"});
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }
}

