/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.cascade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.publishrecord.service.ISysPublishRecordService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CascadeClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.formdesign.publish.service.ResourcePublishService;
import com.jxdinfo.hussar.quote.relation.service.SysQuoteRelationService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

@ClientKind(kind="com.jxdinfo.Module.cascade")
public class ModuleCascadeImpl
implements ResourceCascadeVisitor {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextHolder.getBean(MobileUniProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final ResourcePathService resourcePathService = (ResourcePathService)SpringContextHolder.getBean(ResourcePathService.class);
    private final ResourcePublishService resourcePublishService = (ResourcePublishService)SpringContextHolder.getBean(ResourcePublishService.class);
    private final ISysResManageService resManageService = (ISysResManageService)SpringContextHolder.getBean(ISysResManageService.class);
    private final ISysPublishRecordService sysPublishRecordService = (ISysPublishRecordService)SpringContextHolder.getBean(ISysPublishRecordService.class);
    private final SysQuoteRelationService sysQuoteRelationService = (SysQuoteRelationService)SpringContextHolder.getBean(SysQuoteRelationService.class);
    public static final String KIND = "com.jxdinfo.Module.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String rootPath = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getVueCodePath(strategy)});
        String path = this.getMetaPath(baseFile.getId());
        String parentPath = this.getMetaPath(baseFile.getParentId());
        File newFile = new File(this.relativeToAbsolute(parentPath + File.separator + baseFile.getName(), rootPath));
        File oldFile = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        this.moduleEdit(oldFile, newFile);
        String unirootPath = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniVueCodePath(strategy)});
        String unipath = this.getMetaPath(baseFile.getId());
        String uniparentPath = this.getMetaPath(baseFile.getParentId());
        File uninewFile = new File(this.relativeToAbsolute(uniparentPath + File.separator + baseFile.getName(), unirootPath));
        File unioldFile = new File(FileUtil.systemPath((String[])new String[]{unirootPath, unipath}));
        this.moduleEdit(unioldFile, uninewFile);
        String mobilerootPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileVueCodePath(strategy)});
        String mobilepath = this.getMetaPath(baseFile.getId());
        String mobileparentPath = this.getMetaPath(baseFile.getParentId());
        File mobilenewFile = new File(this.relativeToAbsolute(mobileparentPath + File.separator + baseFile.getName(), mobilerootPath));
        File mobileoldFile = new File(FileUtil.systemPath((String[])new String[]{mobilerootPath, mobilepath}));
        this.moduleEdit(mobileoldFile, mobilenewFile);
        File code = new File(FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath(), path}));
        this.iteratorMobileFile(code);
        String apiRootPath = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getFrontApiPath()});
        String apiPath = this.getMetaPath(baseFile.getId());
        String apiParentPath = this.getMetaPath(baseFile.getParentId());
        File apiNewFile = new File(this.relativeToAbsolute(apiParentPath + File.separator + baseFile.getName(), apiRootPath));
        File apiOldFile = new File(FileUtil.systemPath((String[])new String[]{apiRootPath, apiPath}));
        this.moduleEdit(apiOldFile, apiNewFile);
        String uniapiRootPath = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniFrontApiPath()});
        String uniapiPath = this.getMetaPath(baseFile.getId());
        String uniapiParentPath = this.getMetaPath(baseFile.getParentId());
        File uniapiNewFile = new File(this.relativeToAbsolute(uniapiParentPath + File.separator + baseFile.getName(), uniapiRootPath));
        File uniapiOldFile = new File(FileUtil.systemPath((String[])new String[]{uniapiRootPath, uniapiPath}));
        this.moduleEdit(uniapiOldFile, uniapiNewFile);
        String mobileapiRootPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileFrontApiPath()});
        String mobileapiPath = this.getMetaPath(baseFile.getId());
        String mobileapiParentPath = this.getMetaPath(baseFile.getParentId());
        File mobileapiNewFile = new File(this.relativeToAbsolute(mobileapiParentPath + File.separator + baseFile.getName(), mobileapiRootPath));
        File mobileapiOldFile = new File(FileUtil.systemPath((String[])new String[]{mobileapiRootPath, mobileapiPath}));
        this.moduleEdit(mobileapiOldFile, mobileapiNewFile);
        String extendRootPath = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getExtendScriptPath()});
        File extendnewFile = new File(extendRootPath);
        this.iteratorDirectory(extendnewFile, baseFile, this.fileMappingService.getFileName(baseFile.getId()));
        String uniextendRootPath = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.formDesignProperties.getMobileExtendScriptPath()});
        File uniextendnewFile = new File(uniextendRootPath);
        this.iteratorDirectory(uniextendnewFile, baseFile, this.fileMappingService.getFileName(baseFile.getId()));
        String mobileextendRootPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileExtendScriptPath()});
        File mobileextendnewFile = new File(mobileextendRootPath);
        this.iteratorDirectory(mobileextendnewFile, baseFile, this.fileMappingService.getFileName(baseFile.getId()));
        String oldbackJavaPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getJavaGeneratePath(), this.fileMappingService.getFormatPath(baseFile.getId())});
        File oldJavaPath = new File(oldbackJavaPath);
        String newbackJavaPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getJavaGeneratePath(), this.getMetaPath(baseFile.getParentId()), baseFile.getName()});
        File newJavaPath = new File(newbackJavaPath);
        this.moduleEdit(oldJavaPath, newJavaPath);
    }

    public void iteratorDirectory(File extendnewFile, BaseFile baseFile, String oldName) {
        if (ToolUtil.isNotEmpty((Object)extendnewFile) && ToolUtil.isNotEmpty((Object)extendnewFile.listFiles())) {
            for (File file : extendnewFile.listFiles()) {
                if (!file.isDirectory()) continue;
                if (file.getName().equals(oldName)) {
                    File newFile = new File(file.getParent() + File.separator + baseFile.getName());
                    if (newFile.exists()) continue;
                    this.fixName(file, newFile);
                    continue;
                }
                this.iteratorDirectory(file, baseFile, oldName);
            }
        }
    }

    public void moduleEdit(File oldFile, File newFile) {
        if (oldFile.exists() && !newFile.exists()) {
            this.fixName(oldFile, newFile);
        }
    }

    public void cascadeCopy(String id, String newId, String newName, String parentId) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String rootPath = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getVueCodePath(strategy)});
        String path = this.getMetaPath(id);
        String parentPath = this.getMetaPath(parentId);
        File from = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
        if (parentPath.contains(path) && parentPath.length() > path.length()) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (from.exists()) {
            if (!to.exists()) {
                FileUtils.forceMkdir((File)to);
            }
            FileUtils.copyDirectory((File)from, (File)to, (boolean)false);
        }
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String rootPath = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getVueCodePath(strategy)});
        String parentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, parentPath, rootPath, newName, parentId);
        String unirootPath = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniVueCodePath(strategy)});
        String uniparentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, uniparentPath, unirootPath, newName, parentId);
        String mobilerootPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileVueCodePath(strategy)});
        String mobileparentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, mobileparentPath, mobilerootPath, newName, parentId);
        File code = new File(FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath(), this.getMetaPath(id)}));
        this.iteratorMobileFile(code);
        String apiRootPath = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getFrontApiPath()});
        String apiParentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, apiParentPath, apiRootPath, newName, parentId);
        String uniapiRootPath = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniFrontApiPath()});
        String uniapiParentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, uniapiParentPath, uniapiRootPath, newName, parentId);
        String mobileapiRootPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileFrontApiPath()});
        String mobileapiParentPath = this.getMetaPath(parentId);
        this.moveFrontFile(id, mobileapiParentPath, mobileapiRootPath, newName, parentId);
        String backJavaPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getJavaGeneratePath(), this.fileMappingService.getFormatPath(id)});
        File javaFrom = new File(backJavaPath);
        File javaTo = new File(this.relativeToAbsolute(parentPath, this.formDesignProperties.getJavaGeneratePath()));
        if (javaFrom.exists()) {
            if (!javaTo.exists()) {
                FileUtils.forceMkdir((File)javaTo);
            }
            if (!(javaTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName, this.formDesignProperties.getJavaGeneratePath()))).exists()) {
                FileUtils.moveDirectory((File)javaFrom, (File)javaTo);
            } else {
                FileUtils.moveFileToDirectory((File)javaFrom, (File)javaTo, (boolean)false);
            }
        }
    }

    public void moveFrontFile(String id, String parentPath, String rootPath, String newName, String parentId) throws LcdpException, IOException {
        String path = this.getMetaPath(id);
        File from = new File(FileUtil.systemPath((String[])new String[]{rootPath, path}));
        File to = new File(this.relativeToAbsolute(parentPath + File.separator + newName, rootPath));
        if (parentPath.contains(path) && (id.equals(parentId) || this.copyCheck(id, parentId))) {
            throw new LcdpException(LcdpExceptionEnum.BAN_FOLDER, path);
        }
        if (from.exists()) {
            if (!to.exists()) {
                FileUtils.moveDirectory((File)from, (File)to);
            } else {
                FileUtils.moveDirectoryToDirectory((File)from, (File)to, (boolean)false);
            }
        }
    }

    private boolean copyCheck(String id, String parentId) throws IOException, LcdpException {
        BaseFile baseFile = this.fileMappingService.getPageInfoById(parentId);
        if (ToolUtil.isNotEmpty((Object)baseFile) && !"#".equals(baseFile.getParentId())) {
            if (id.equals(baseFile.getId())) {
                return true;
            }
            return this.copyCheck(id, baseFile.getParentId());
        }
        return false;
    }

    public void cascadeDelete(String id) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String rootPath = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getVueCodePath(strategy)});
        if (ToolUtil.isEmpty((Object)id)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        String path = this.getMetaPath(id);
        File f = new File(this.relativeToAbsolute(path, rootPath));
        this.moduleDelete(f);
        String unirootPath = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniVueCodePath(strategy)});
        File unif = new File(this.relativeToAbsolute(path, unirootPath));
        this.moduleDelete(unif);
        String mobilerootPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileVueCodePath(strategy)});
        File mobilef = new File(this.relativeToAbsolute(path, mobilerootPath));
        this.moduleDelete(mobilef);
        String apiRootPath = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getFrontApiPath()});
        File apif = new File(this.relativeToAbsolute(path, apiRootPath));
        this.moduleDelete(apif);
        String uniapiRootPath = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniFrontApiPath()});
        File uniapif = new File(this.relativeToAbsolute(path, uniapiRootPath));
        this.moduleDelete(uniapif);
        String mobileapiRootPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileFrontApiPath()});
        File mobileapif = new File(this.relativeToAbsolute(path, mobileapiRootPath));
        this.moduleDelete(mobileapif);
        String extendRootPath = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getExtendScriptPath()});
        this.extendModuleDelete(extendRootPath, path);
        String uniextendRootPath = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.formDesignProperties.getMobileExtendScriptPath()});
        this.extendModuleDelete(uniextendRootPath, path);
        String mobileextendRootPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileExtendScriptPath()});
        this.extendModuleDelete(mobileextendRootPath, path);
        File code = new File(FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath(), path}));
        this.iteratorFile(code);
        this.iteratorMobileFile(code);
        String backProjectPath = this.resourcePathService.backProjectJava(new String[]{AppContextUtil.getServiceID().replace("-", "")}).getLocalPath();
        File bf = new File(this.relativeToAbsolute(path, backProjectPath));
        if (bf.exists()) {
            try {
                FileUtils.forceDelete((File)bf);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, bf.getAbsolutePath());
            }
        }
    }

    private void moduleDelete(File f) throws LcdpException {
        if (f.exists()) {
            try {
                FileUtils.forceDelete((File)f);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, f.getAbsolutePath());
            }
        }
    }

    private void extendModuleDelete(String rootPath, String path) throws LcdpException {
        String jsPath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendJavaScriptPath(), path});
        this.moduleDelete(new File(jsPath));
        String vuePath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendVuePath(), path});
        this.moduleDelete(new File(vuePath));
        String cssPath = FileUtil.systemPath((String[])new String[]{rootPath, this.formDesignProperties.getExtendCssScriptPath(), path});
        this.moduleDelete(new File(cssPath));
    }

    private void iteratorFile(File file) throws IOException, LcdpException {
        block3: {
            JSONObject dataModelJson;
            List operationList;
            String type;
            block5: {
                block4: {
                    if (!file.exists()) break block3;
                    if (!file.isDirectory()) break block4;
                    File[] files = file.listFiles();
                    if (files == null) break block3;
                    for (File childFile : files) {
                        this.iteratorFile(childFile);
                    }
                    break block3;
                }
                if (!file.getName().endsWith(".meta")) break block3;
                JSONObject jsonObject = null;
                jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                String id = jsonObject.get((Object)"id").toString();
                type = jsonObject.get((Object)"type").toString();
                CascadeClientConverter.cascadeResources((String)ClientKindEnum.CLIET_RESOURCE_CASCADE.kind(type)).cascadeDelete(id);
                if (!"WebPage".equals(type) && !"MobilePage".equals(type) && !"UniPage".equals(type)) break block5;
                this.sysQuoteRelationService.deleteQuoteRelationByReferResid(id);
                this.resourcePublishService.deleteMenu(id);
                Long resourceId = this.sysPublishRecordService.getResourceIDBySourceId(id);
                if (!ToolUtil.isNotEmpty((Object)resourceId)) break block3;
                this.resManageService.deleteResource(String.valueOf(resourceId));
                break block3;
            }
            if ("DataModel".equals(type) && ToolUtil.isNotEmpty((Object)(operationList = ToolUtil.castListMap((Object)(dataModelJson = JSONObject.parseObject((String)FileUtils.readFileToString((File)new File(file.getAbsolutePath().replace(".meta", "")), (String)"UTF-8"))).get((Object)"operations"), String.class, Object.class)))) {
                for (Map map : operationList) {
                    Long resourceId = this.sysPublishRecordService.getResourceIDBySourceId((String)map.get("id"));
                    if (!ToolUtil.isNotEmpty((Object)resourceId)) continue;
                    this.resManageService.deleteResource(String.valueOf(resourceId));
                }
            }
        }
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }

    void dealRouter(String id, String newPageName, String newModuleRelatePath, boolean isDelete) throws IOException, LcdpException {
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(id);
        String projectPath = this.mobileProject(this.mobileUniProperties.getUniFrontProjectPath(), new String[0]).getLocalPath();
        String path = this.getMetaPath(id);
        File file = new File(FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getBackProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath(), path + ".meta"}));
        JSONObject jsonObject = null;
        jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
        String pageName = jsonObject.get((Object)"name").toString();
        String desc = jsonObject.get((Object)"desc").toString();
        String component = FileUtil.posixPath((String[])new String[]{AppContextUtil.posixFilePathPrefix(), "views", moduleRelatePath, pageName});
        String newComponent = FileUtil.posixPath((String[])new String[]{AppContextUtil.posixFilePathPrefix(), "views", newModuleRelatePath, ToolUtil.isNotEmpty((Object)newPageName) ? newPageName : pageName});
        String routerExport = "{\n 'path': '" + newComponent + "',\n'style': {\n'navigationBarTitleText': '" + desc + "'\n}\n}";
        this.mobileUniRouterCode(component, newComponent, routerExport, projectPath, isDelete);
    }

    private ResourcePath mobileProject(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getWorkspace(), name});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private void mobileUniRouterCode(String component, String newComponent, String fileContent, String vueRootPath, boolean isDelete) throws IOException {
        vueRootPath = FileUtil.complementFilePath((String)vueRootPath);
        String filePath = vueRootPath + "/src/pages.json";
        File file = new File(filePath);
        String fileMsg = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        JSONObject parse = JSON.parseObject((String)fileMsg, (Feature[])new Feature[]{Feature.OrderedField});
        JSONArray jsonArray = JSON.parseArray((String)parse.get((Object)"pages").toString());
        boolean type = true;
        for (Object o : jsonArray) {
            String path = JSON.parseObject((String)o.toString()).get((Object)"path").toString();
            if (!path.equals(component)) continue;
            jsonArray.remove(o);
            break;
        }
        parse.put("pages", (Object)jsonArray);
        if (file.exists()) {
            if (ToolUtil.isEmpty((Object)parse)) {
                FileUtils.writeStringToFile((File)file, (String)"", (String)"UTF-8", (boolean)false);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)parse), (String)"UTF-8", (boolean)false);
            }
        }
    }

    private void iteratorMobileFile(File file) throws IOException, LcdpException {
        block8: {
            block9: {
                if (!file.exists()) break block8;
                if (!file.isDirectory()) break block9;
                File[] files = file.listFiles();
                if (files == null) break block8;
                for (File childFile : files) {
                    this.iteratorMobileFile(childFile);
                }
                break block8;
            }
            if (file.getName().endsWith(".meta")) {
                JSONObject jsonObject = null;
                jsonObject = JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"));
                String id = jsonObject.get((Object)"id").toString();
                String type = jsonObject.get((Object)"type").toString();
                String parentId = jsonObject.get((Object)"parentId").toString();
                String parentPath = this.getMetaPath(parentId);
                if ("UniPage".equals(type)) {
                    this.dealRouter(id, null, parentPath, false);
                } else if ("MobilePage".equals(type)) {
                    String path = this.fileMappingService.getFormatParentPath(id);
                    String oldFileJsPath = this.formDesignProperties.getMobileFrontProjectPath() + "/src/router/" + path;
                    File oldFileJs = new File(oldFileJsPath = ToolUtil.pathFomatterByOS((String)oldFileJsPath));
                    if (oldFileJs.exists()) {
                        try {
                            FileUtils.forceDelete((File)oldFileJs);
                        }
                        catch (IOException e) {
                            throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldFileJsPath);
                        }
                    }
                }
            }
        }
    }

    protected boolean fixName(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }
}

