/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.cascade;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.MobileUniProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

@ClientKind(kind="com.jxdinfo.DataModel.cascade")
public class ModelCascadeImpl
implements ResourceCascadeVisitor {
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final MobileUniProperties mobileUniProperties = (MobileUniProperties)SpringContextHolder.getBean(MobileUniProperties.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    public static final String KIND = "com.jxdinfo.DataModel.cascade";

    public void cascadeEdit(BaseFile baseFile) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldfilePath = this.getOldJSPath(baseFile.getId(), strategy);
        String newFilePath = this.getNewJSPath(baseFile.getId(), baseFile.getName().toLowerCase(), strategy);
        File newFile = new File(newFilePath);
        File oldFile = new File(oldfilePath);
        if (oldFile.exists() && !newFile.exists()) {
            this.fixName(oldFile, newFile);
        }
        String oldMobilefilePath = this.getOldMobileJSPath(baseFile.getId(), strategy);
        String newMobileFilePath = this.getNewMobileJSPath(baseFile.getId(), baseFile.getName(), strategy);
        File newMobileFile = new File(newMobileFilePath);
        File oldMobileFile = new File(oldMobilefilePath);
        if (oldMobileFile.exists() && !newMobileFile.exists()) {
            this.fixName(oldMobileFile, newMobileFile);
        }
        String oldUnifilePath = this.getOldUniJSPath(baseFile.getId(), strategy);
        String newUniFilePath = this.getNewUniJSPath(baseFile.getId(), baseFile.getName(), strategy);
        File newUniFile = new File(newUniFilePath);
        File oldUniFile = new File(oldUnifilePath);
        if (oldUniFile.exists() && !newUniFile.exists()) {
            this.fixName(oldUniFile, newUniFile);
        }
        String backJavaPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getJavaGeneratePath(), this.fileMappingService.getFormatPath(baseFile.getId())});
        File backJavaFile = new File(backJavaPath);
        String oldName = backJavaPath.substring(backJavaPath.lastIndexOf(File.separator) + 1);
        this.iteratorFile(backJavaFile, oldName, baseFile.getName());
        File newBackJavaFile = new File(FileUtil.systemPath((String[])new String[]{backJavaPath.substring(0, backJavaPath.lastIndexOf(File.separator)), baseFile.getName()}));
        if (backJavaFile.exists() && !newBackJavaFile.exists()) {
            this.fixName(backJavaFile, newBackJavaFile);
        }
        File publishFile = new File(this.getPublishFilePathById());
        this.iteratorDirectory(publishFile, oldName, baseFile.getName(), baseFile.getId().replace("_", "/"));
    }

    public void cascadeCopy(String id, String newId, String newName, String parentPath) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        String oldName;
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String parentPath = this.getMetaPath(parentId);
        String oldfilePath = this.getOldJSPath(id, strategy);
        File jsFrom = new File(oldfilePath);
        String rootPath = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getFrontApiPath()});
        File jsTo = new File(this.relativeToAbsolute(parentPath, rootPath));
        this.modelMove(jsFrom, jsTo, newName, parentPath, rootPath);
        String oldunifilePath = this.getOldUniJSPath(id, strategy);
        File uniJsFrom = new File(oldunifilePath);
        String uniRootPath = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniFrontApiPath()});
        File uniJsTo = new File(this.relativeToAbsolute(parentPath, uniRootPath));
        this.modelMove(uniJsFrom, uniJsTo, newName, parentPath, uniRootPath);
        String oldmobilefilePath = this.getOldMobileJSPath(id, strategy);
        File mobileJsFrom = new File(oldmobilefilePath);
        String mobileRootPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileFrontApiPath()});
        File mobileJsTo = new File(this.relativeToAbsolute(parentPath, mobileRootPath));
        this.modelMove(mobileJsFrom, mobileJsTo, newName, parentPath, mobileRootPath);
        String backJavaPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getJavaGeneratePath(), this.fileMappingService.getFormatPath(id)});
        File javaFrom = new File(backJavaPath);
        File javaTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName, this.formDesignProperties.getJavaGeneratePath()));
        if (javaFrom.exists()) {
            if (!javaTo.exists()) {
                FileUtils.moveDirectory((File)javaFrom, (File)javaTo);
            } else {
                FileUtils.moveDirectoryToDirectory((File)javaFrom, (File)javaTo, (boolean)false);
            }
        }
        if (ToolUtil.isNotEmpty((Object)(oldName = backJavaPath.substring(backJavaPath.lastIndexOf(File.separator) + 1))) && ToolUtil.isNotEmpty((Object)newName) && !oldName.equals(newName)) {
            this.iteratorFile(javaTo, oldName, newName);
            File publishFile = new File(this.getPublishFilePathById());
            this.iteratorDirectory(publishFile, oldName, newName, id.replace("_", "/"));
        }
    }

    public void modelMove(File jsFrom, File jsTo, String newName, String parentPath, String rootPath) throws IOException, LcdpException {
        if (jsFrom.exists()) {
            if (!jsTo.exists()) {
                FileUtils.forceMkdir((File)jsTo);
            }
            if (newName != null && !newName.isEmpty()) {
                jsTo = new File(this.relativeToAbsolute(parentPath + File.separator + newName + ".js", rootPath));
                if (!jsTo.exists()) {
                    try {
                        FileUtils.moveFile((File)jsFrom, (File)jsTo);
                    }
                    catch (IOException e) {
                        throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, jsFrom.getAbsolutePath());
                    }
                }
            } else {
                try {
                    FileUtils.moveFileToDirectory((File)jsFrom, (File)jsTo, (boolean)false);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.FILE_MOVE_FAIL, jsFrom.getAbsolutePath());
                }
            }
        }
    }

    public void cascadeDelete(String id) throws LcdpException {
        File publishFile;
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        String oldJSFilePath = this.getOldJSPath(id, strategy);
        File file = new File(oldJSFilePath);
        this.modelJsDel(file, oldJSFilePath);
        String oldmobileJSFilePath = this.getOldMobileJSPath(id, strategy);
        File mobilefile = new File(oldmobileJSFilePath);
        this.modelJsDel(mobilefile, oldmobileJSFilePath);
        String olduniJSFilePath = this.getOldUniJSPath(id, strategy);
        File unifile = new File(olduniJSFilePath);
        this.modelJsDel(unifile, olduniJSFilePath);
        String backJavaPath = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getJavaGeneratePath(), this.fileMappingService.getFormatPath(id)});
        File backJavaFile = new File(backJavaPath);
        if (backJavaFile.exists()) {
            try {
                FileUtils.forceDelete((File)backJavaFile);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, backJavaFile.getAbsolutePath());
            }
        }
        if ((publishFile = new File(this.getPublishFilePathById())).exists()) {
            for (File f : Objects.requireNonNull(publishFile.listFiles())) {
                if (!f.getName().contains(id.replace("_", "/"))) continue;
                try {
                    FileUtils.forceDelete((File)f);
                }
                catch (IOException e) {
                    throw new LcdpException(LcdpExceptionEnum.DIRECTORY_DELETE_FAIL, f.getAbsolutePath());
                }
            }
        }
    }

    public void modelJsDel(File file, String oldJSFilePath) throws LcdpException {
        if (file.exists()) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new LcdpException(LcdpExceptionEnum.FILE_DELETE_FAIL, oldJSFilePath);
            }
        }
    }

    String getOldJSPath(String id, Integer strategy) throws LcdpException {
        String oldJsPath = this.fileMappingService.getFormatPath(id);
        String localPrefix = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getFrontApiPath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldJsPath + this.formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNewJSPath(String id, String pageName, Integer strategy) throws LcdpException {
        String localPrefix = FileUtil.systemPath((String[])new String[]{AppContextUtil.getServiceID((String)this.formDesignProperties.getFrontProjectPath()), this.formDesignProperties.getFrontApiPath()});
        String newJsPath = FileUtil.systemPath((String[])new String[]{this.fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newJsPath + this.formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getOldMobileJSPath(String id, Integer strategy) throws LcdpException {
        String oldJsPath = this.fileMappingService.getFormatPath(id);
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileFrontApiPath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldJsPath + this.formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNewMobileJSPath(String id, String pageName, Integer strategy) throws LcdpException {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getMobileFrontProjectPath(), this.formDesignProperties.getMobileFrontApiPath()});
        String newJsPath = FileUtil.systemPath((String[])new String[]{this.fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newJsPath + this.formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getOldUniJSPath(String id, Integer strategy) throws LcdpException {
        String oldJsPath = this.fileMappingService.getFormatPath(id);
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniFrontApiPath()});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{oldJsPath + this.formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    String getNewUniJSPath(String id, String pageName, Integer strategy) throws LcdpException {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.mobileUniProperties.getUniProjectAbsolutePath(), this.mobileUniProperties.getUniFrontApiPath()});
        String newJsPath = FileUtil.systemPath((String[])new String[]{this.fileMappingService.getFormatParentPath(id), pageName});
        return ResourcePath.of((String)FileUtil.posixPath((String[])new String[]{newJsPath + this.formDesignProperties.getJsSuffix()}), (String)localPrefix, (String)"").getLocalPath();
    }

    protected boolean fixName(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getPublishFilePathById() {
        return FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getProjectPath(), AppContextUtil.getServiceID(), this.formDesignProperties.getProjectRootPath(), "/publish/version/ancestor"});
    }

    private void iteratorFile(File file, String oldName, String newName) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorFile(childFile, oldName, newName);
                    }
                }
            } else if (!file.getName().contains(this.getBackFileName(oldName + "SysTask"))) {
                if (file.getName().contains(this.getBackFileName(oldName + "Master"))) {
                    oldName = oldName + "Master";
                    newName = newName + "Master";
                    if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                        oldName = oldName + "VO";
                        newName = newName + "VO";
                    }
                } else if (file.getName().contains(this.getBackFileName(oldName + "Task"))) {
                    oldName = oldName + "Task";
                    newName = newName + "Task";
                    if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                        oldName = oldName + "VO";
                        newName = newName + "VO";
                    } else if (file.getName().contains(this.getBackFileName(oldName + "TotalQuery"))) {
                        oldName = oldName + "TotalQuery";
                        newName = newName + "TotalQuery";
                    }
                } else if (file.getName().contains(this.getBackFileName(oldName + "TotalQuery"))) {
                    oldName = oldName + "TotalQuery";
                    newName = newName + "TotalQuery";
                } else if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                    oldName = oldName + "VO";
                    newName = newName + "VO";
                }
                oldName = this.getBackFileName(oldName);
                newName = this.getBackFileName(newName);
                if (file.exists() && file.isFile()) {
                    String oldPath = file.getAbsolutePath();
                    String newPath = oldPath.replaceFirst(oldName, newName);
                    File newFile = new File(newPath);
                    file.renameTo(newFile);
                }
            }
        }
    }

    private void iteratorDirectory(File file, String oldName, String newName, String id) throws IOException {
        if (file.exists() && file.isDirectory()) {
            if (file.getName().contains(id)) {
                if (!file.getName().contains(this.getBackFileName(oldName + "SysTask"))) {
                    if (file.getName().contains(this.getBackFileName(oldName + "Master"))) {
                        oldName = oldName + "Master";
                        newName = newName + "Master";
                        if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                            oldName = oldName + "VO";
                            newName = newName + "VO";
                        }
                    } else if (file.getName().contains(this.getBackFileName(oldName + "Task"))) {
                        oldName = oldName + "Task";
                        newName = newName + "Task";
                        if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                            oldName = oldName + "VO";
                            newName = newName + "VO";
                        }
                    } else if (file.getName().contains(this.getBackFileName(oldName + "TotalQuery"))) {
                        oldName = oldName + "TotalQuery";
                        newName = newName + "TotalQuery";
                    } else if (file.getName().contains(this.getBackFileName(oldName + "VO"))) {
                        oldName = oldName + "VO";
                        newName = newName + "VO";
                    }
                    String oldPath = file.getAbsolutePath();
                    String newPath = oldPath.replace(oldName, newName);
                    oldName = this.getBackFileName(oldName);
                    newName = this.getBackFileName(newName);
                    newPath = newPath.replace(oldName, newName);
                    File newFile = new File(newPath);
                    file.renameTo(newFile);
                }
            } else {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorDirectory(childFile, oldName, newName, id);
                    }
                }
            }
        }
    }

    String getBackFileName(String name) {
        return ToolUtil.firstLetterToUpper((String)NamingStrategy.underlineToCamel((String)name));
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }
}

