<#list filterOptions! as item>
    <#if item.type == 'CommonModel'>
        const params${item_index} = {
          typeName: '${item.dictType!}',
        };
        ${item.apiFileName!}.${item.importMethod!}(params${item_index}).then(res => {
            if (res.code === 200 || res.code === 10000) {
                const data = res?.data;
                if(data?.length){
                    <#if item.componentModelType?? && item.componentModelType == 'select'>
                    const options = data.map(opt => {
                        return {
                            name: opt.label,
                            value: opt.value
                        }
                    })
                    <#elseif item.componentModelType?? && item.componentModelType == 'tree'>
                    const options = formatDictToTreeData(data);
                    </#if>
                    self.${instanceKey!}PropsData.filterColumns.find(col=>{
                        if(col.field === '${item.value}'){
                            col.options = options;
                            return true;
                        }
                    })
                }
            }
        })
    <#else>
        const params${item_index} = {
            ${item.queryAttr!}
        }
        ${item.apiFileName!}.${item.importMethod!}(params${item_index}).then(res => {
            if (res.code === 200 || res.code === 10000) {
                const data = res?.data?.data;
                if(data?.length){
                <#if item.componentModelType?? && item.componentModelType == 'select' &&
                   item.selectValue?? && item.selectValue != '' &&
                   item.selectLabel?? && item.selectLabel != ''>
                    const options = data.map(opt => {
                        return {
                            name: opt.${item.selectLabel!},
                            value: opt.${item.selectValue!}
                        }
                    })
                <#elseif item.componentModelType?? && item.componentModelType == 'tree' &&
                    item.selectValue?? && item.selectValue != '' &&
                    item.selectLabel?? && item.selectLabel != '' &&
                    item.selectParentId?? && item.selectParentId != ''>
                    const options = formatModelToTreeData(data, (item)=>{
                     return {
                        id: item.${item.selectValue!},
                        label: item.${item.selectLabel!},
                        pid: item.${item.selectParentId!},
                        children: []
                     }
                    });
                <#else>
                    const options = [];
                </#if>
                    self.${instanceKey!}PropsData.filterColumns.find(col=>{
                        if(col.field === '${item.value}'){
                            col.options = options;
                            return true;
                        }
                    })
                }
            }
        })
    </#if>
</#list>
