<#macro colTree colList>
    <#list colList as item>
        <#--前代码块占位符-->
        <#if item.codeBlockBefore?? && item.codeBlockBefore>
            <!-- @begin ${instanceKey!}_${item.field!}_before -->
            <!-- @end ${instanceKey!}_${item.field!}_before -->
        </#if>
    <#--是否为多级表头-->
        <#if item.isParent??>
        <el-table-column label="${item.title!}"
                <#if item.headAlignIsEdit?? && item.headAlignIsEdit>
                    header-align="${item.align!}"
                    <#else>
                        header-align="noConfig"
                </#if>
        >
            <@colTree colList=item.children></@colTree>
        </el-table-column>
        <#elseif item.rowSummary?? && item.rowSummary>
            <el-table-column
                    <#if item.auth?? && item.auth! != ''>
                        <#--TODO:权限暂不生成，分开提测-->
                        <#--v-if="$hasColumnAuth(${instanceKey!}Data, '${item.auth!}')"-->
                    </#if>
                    label="${item.title!}"
                    prop="${item.field!}"
                    <#if (item.sort?? && item.sort!) && (isSortChange?? && isSortChange)>
                            sortable="custom"
                    <#elseif (item.sort?? && item.sort!)>
                            sortable
                    </#if>
                    <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                        <#if (item.fixed.left?? && item.fixed.left)>
                            fixed="left"
                        <#else>
                            fixed="right"
                        </#if>
                    </#if>
                    <#if (item.colWidth.selfCustom!)>
                        <#if (item.colWidth.isMinWidth??) && (item.colWidth.isMinWidth!)>
                            <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                            :min-width="${item.colWidth.number!}"
                            </#if>
                        <#else>
                            <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                            width="${item.colWidth.number!}"
                            </#if>
                        </#if>
                    </#if>
                    <#if item.bodyAlignIsEdit?? && item.bodyAlignIsEdit>
                        align="${item.bodyAlign!}"
                    <#else>
                        align="noConfig"
                    </#if>
                    <#if item.headAlignIsEdit?? && item.headAlignIsEdit>
                        header-align="${item.align!}"
                    <#else>
                        header-align="noConfig"
                    </#if>
<#--                     align="${item.bodyAlign!}"-->
<#--                     header-align="${item.align!}"-->
                     <#if item.showOverflowTooltip??>
                     :show-overflow-tooltip="${item.showOverflowTooltip?c}"
                     </#if>
                     <#if item.resizable??>
                     :resizable="${item.resizable?c}"
                     </#if>
                     >
                <#if item.rowCalculateFormula?? && item.rowCalculateFormula! != ''>
                <template slot-scope="scope">
                    <#if item.columnStyles??>
                        <h-table-column-component :config="${instanceKey!}${item.field!}ConditionStyleFn(scope)" <#if item.columnStyles.type == "Rate" || item.columnStyles.type == "HSwitch">:cell="scope.row['${item.field!}']"</#if>>
                            {{scope.row.${item.field!}Fn(scope)}}
                        </h-table-column-component>
                    <#else>
                    {{scope.row.${item.field!}Fn(scope)}}
                    </#if>
                </template>
                </#if>
                <template slot="header" slot-scope="scope">
                    <span class="label-class">{{scope.column.label}}</span>
                    <h-table-column-filter
                            :column="scope"
                            <#if showFilter?? && showFilter!>
                                :filter-config="${instanceKey!}PropsData.filterConfig"
                            </#if>
                            <#if (!item.headAlignIsEdit?? || !item.headAlignIsEdit) && (!item.bodyAlignIsEdit?? || !item.bodyAlignIsEdit) && item.bodyAlign! == item.align!>
                                tableAlign="${item.align!}"
                            </#if>
                    >
                    </h-table-column-filter>
                </template>
            </el-table-column>
        <#elseif item.colsMode?? && item.colsMode == 'colsCustom'>
            <#if item.customCols?? && item.customCols != ''>
                <!-- ${instanceKey!}-${item.fieldName} #自定义表格列代码开始 -->
                ${item.customCols}
                <!-- #自定义表格列代码结束 -->
            </#if>
        <#else>
            <el-table-column
                    <#if item.auth?? && item.auth! != ''>
                        <#--TODO:权限暂不生成，分开提测-->
                        <#--v-if="$hasColumnAuth(${instanceKey!}Data, '${item.auth!}')"-->
                    </#if>
                    <#if isCheckedYHeadBorderColor??>
                        class-name="head-borderY"
                    </#if>
                    prop="${item.field!}"
                    label="${item.title!}"
                    <#if (item.sort?? && item.sort!) && (isSortChange?? && isSortChange)>
                            sortable="custom"
                    <#elseif (item.sort?? && item.sort!)>
                            sortable
                    </#if>
                    <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                        <#if (item.fixed.left?? && item.fixed.left)>
                            fixed="left"
                        <#else>
                            fixed="right"
                        </#if>
                    </#if>
                    <#if (item.colWidth.selfCustom!)>
                        <#if (item.colWidth.isMinWidth??) && (item.colWidth.isMinWidth!)>
                            <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                            :min-width="${item.colWidth.number!}"
                            </#if>
                        <#else>
                            <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                            width="${item.colWidth.number!}"
                            </#if>
                        </#if>
                    </#if>
                    <#if item.bodyAlignIsEdit?? && item.bodyAlignIsEdit>
                        align="${item.bodyAlign!}"
                    <#else>
                        align="noConfig"
                    </#if>
                    <#if item.headAlignIsEdit?? && item.headAlignIsEdit>
                        header-align="${item.align!}"
                    <#else>
                        header-align="noConfig"
                    </#if>
<#--                    align="${item.bodyAlign!}"-->
<#--                    header-align="${item.align!}"-->
                    <#if item.showOverflowTooltip??>
                     :show-overflow-tooltip="${item.showOverflowTooltip?c}"
                     </#if>
                     <#if item.resizable??>
                     :resizable="${item.resizable?c}"
                     </#if>
                    >
                <#if item.field == "">
                    <template>
                    <#if item.eventList?? && item.eventList.isNeedAction?? && item.eventList.isNeedAction!>
                        <span class="jxd_hyperlinks_span" <#if item.eventList.eventName?? && item.eventList.eventName!= "">@click="${instanceKey!}${item.eventList.eventName?cap_first}"></#if></span>
                    <#else>
                        <#if item.hyperlinks?? && item.hyperlinks.fileId?? && item.hyperlinks.fileId! != "">
                            <span @click="${instanceKey!}${item.field!}CLICK"></span>
                        <#else>
                        </#if>
                    </#if>
                    </template>
                <#else>
                    <template slot-scope="scope">
                        <#if  item.eventList?? && item.eventList.isNeedAction?? && item.eventList.isNeedAction!>
                            <span class="jxd_hyperlinks_span" <#if item.eventList.eventName?? && item.eventList.eventName!= "" && item.eventList.isEvent?? && item.eventList.isEvent>@click="${instanceKey!}${item.eventList.eventName?cap_first}(scope.row, scope.column.property)<#if item.hyperlinks?? && item.hyperlinks.fileId?? && item.hyperlinks.fileId! != "">,${instanceKey!}${item.field!}CLICK(scope.row)"</#if>"</#if>>
                            <#if item.columnStyles??>
                            <h-table-column-component :config="${instanceKey!}${item.field!}ConditionStyleFn(scope)" <#if item.columnStyles.type == "Rate" || item.columnStyles.type == "HSwitch">:cell="scope.row['${item.field!}']"</#if>>
                            </#if>
                            <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                                {{(scope.row['${item.field!}']) ? $dayjs(scope.row['${item.field!}']).format('${item.selectType.dateFmtSelect!}') : '--'}}
                            <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                                {{(scope.row['${item.field!}']) || (scope.row['${item.field!}']) === 0 ? $numeral(scope.row['${item.field!}']).format('${item.selectType.numberFmtSelect!}') : '--'}}
                            <#elseif item.colComponent! == 'img'>
                                <blob-img class="flex-img__image" :src="/attachment/showPicture?image=<#noparse>$</#noparse>{scope.row['${item.field!}']}`" style="height: 150px;width: 150px;"></blob-img>
                            <#else>
                                {{scope.row['${item.field!}']}}
                            </#if>
                            <#if item.columnStyles??>
                            </h-table-column-component>
                            </#if>
                            </span>
                        <#elseif item.hyperlinks?? && item.hyperlinks.fileId?? && item.hyperlinks.fileId! != "">
                            <span class="jxd_hyperlinks_span" @click="${instanceKey!}${item.field!}CLICK(scope.row)">
                            <#if item.columnStyles??>
                            <h-table-column-component :config="${instanceKey!}${item.field!}ConditionStyleFn(scope)" <#if item.columnStyles.type == "Rate" || item.columnStyles.type == "HSwitch">:cell="scope.row['${item.field!}']"</#if>>
                            </#if>
                            <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                                {{(scope.row['${item.field!}']) ? $dayjs(scope.row['${item.field!}']).format('${item.selectType.dateFmtSelect!}') : '--'}}
                            <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                                {{(scope.row['${item.field!}']) || (scope.row['${item.field!}']) === 0 ? $numeral(scope.row['${item.field!}']).format('${item.selectType.numberFmtSelect!}') : '--'}}
                            <#elseif item.colComponent! == 'img'>
                                <blob-img class="flex-img__image" :src="`/attachment/showPicture?image=<#noparse>$</#noparse>{scope.row['${item.field!}']}`" style="height: 150px;width: 150px;"></blob-img>
                            <#else>
                                {{scope.row['${item.field!}']}}
                            </#if>
                            <#if item.columnStyles??>
                            </h-table-column-component>
                            </#if>
                            </span>
                        <#elseif item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                            <#if item.columnStyles??>
                            <h-table-column-component :config="${instanceKey!}${item.field!}ConditionStyleFn(scope)" <#if item.columnStyles.type == "Rate" || item.columnStyles.type == "HSwitch">:cell="scope.row['${item.field!}']"</#if>>
                            </#if>
                                {{(scope.row['${item.field!}']) ? $dayjs(scope.row['${item.field!}']).format('${item.selectType.dateFmtSelect!}') : '--'}}
                            <#if item.columnStyles??>
                            </h-table-column-component>
                            </#if>
                        <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                            <#if item.columnStyles??>
                            <h-table-column-component :config="${instanceKey!}${item.field!}ConditionStyleFn(scope)" <#if item.columnStyles.type == "Rate" || item.columnStyles.type == "HSwitch">:cell="scope.row['${item.field!}']"</#if>>
                            </#if>
                            {{(scope.row['${item.field!}']) || (scope.row['${item.field!}']) === 0 ? $numeral(scope.row['${item.field!}']).format('${item.selectType.numberFmtSelect!}') : '--'}}
                            <#if item.columnStyles??>
                            </h-table-column-component>
                            </#if>
                        <#elseif item.colComponent! == 'img'>
                            <#if item.columnStyles??>
                            <h-table-column-component :config="${instanceKey!}${item.field!}ConditionStyleFn(scope)" <#if item.columnStyles.type == "Rate" || item.columnStyles.type == "HSwitch">:cell="scope.row['${item.field!}']"</#if>>
                            </#if>
                            <blob-img class="flex-img__image" :src="scope.row['${item.field!}'] ? `/attachment/showPicture?image=<#noparse>$</#noparse>{scope.row['${item.field!}']}` : ''" style="height: 150px;width: 150px;"></blob-img>
                            <#if item.columnStyles??>
                            </h-table-column-component>
                            </#if>
                        <#else>
                            <#if item.columnStyles??>
                            <h-table-column-component :config="${instanceKey!}${item.field!}ConditionStyleFn(scope)" <#if item.columnStyles.type == "Rate" || item.columnStyles.type == "HSwitch">:cell="scope.row['${item.field!}']"</#if>>
                            </#if>
                            {{scope.row['${item.field!}']}}
                            <#if item.columnStyles??>
                            </h-table-column-component>
                            </#if>
                        </#if>
                    </template>
                </#if>
                <template slot="header" slot-scope="scope">
                    <span class="label-class">{{scope.column.label}}</span>
                    <h-table-column-filter
                        :column="scope"
                        <#if showFilter?? && showFilter!>
                            :filter-config="${instanceKey!}PropsData.filterConfig"
                        </#if>
                        <#if (!item.headAlignIsEdit?? || !item.headAlignIsEdit) && (!item.bodyAlignIsEdit?? || !item.bodyAlignIsEdit) && item.bodyAlign! == item.align!>
                            tableAlign="${item.align!}"
                        </#if>
                    >
                    </h-table-column-filter>
                </template>
            </el-table-column>
        </#if>
        <#--后代码块占位符-->
        <#if item.codeBlockAfter?? && item.codeBlockAfter>
            <!-- @begin ${instanceKey!}_${item.field!}_after -->
            <!-- @end ${instanceKey!}_${item.field!}_after -->
        </#if>
    </#list>
</#macro>
<div
    <#if showCustomList?? && showCustomList!>
        v-if="${instanceKey!}IsShow"
    </#if>
    v-show="!${instanceKey!}Hidden">
    <#if isExportTemplate?? && isExportTemplate!>
        <export-table-template-dialog  v-if="${instanceKey!}ExportTempalteDialogVisible"
                                       :dialogVisible.sync="${instanceKey!}ExportTempalteDialogVisible"
                                       :columns="${instanceKey!}Columns"
                                       :propsData="${instanceKey!}PropsData"
                                       :dataModelName="${instanceKey!}dataModelName"
                                       @export="${instanceKey!}HandleExportTemplate"></export-table-template-dialog>
    </#if>
    <h-table-v1
            :key="${instanceKey!}Refresh"
            theme-name="${styleSchemeClassName!}"
            :props="${instanceKey!}PropsData"
            :inner-styles="${instanceKey!}InnerStyles"
            <#--列表loading-->
            v-loading="${instanceKey!}TableLoading"
            <#--表格高度（分页）-->
            <#if isPagination?? && isPagination>
                :isPagination="${isPagination?c}"
            </#if>
            <#--列表合计-->
            <#if columnSummary?? && columnSummary>
                :summary-method="${instanceKey!}ColumnSummaryEvent"
                show-summary
            </#if>
            <#--选择项变化-->
            <#if crossPageSelect?? && crossPageSelect>
                @select="${instanceKey!}SelectRow" @select-all="${instanceKey!}SelectAll"
            <#else>
                @selection-change="${instanceKey!}SelectRow"
            </#if>
            <#--是否复选框只能选择一个-->
            ref="${instanceKey!}TableRef"
            <#if isRadio?? && isRadio!>
                 @select="${instanceKey!}Select" @select-all="${instanceKey!}SelectAll"
            </#if>
            <#--行单选，选中后该行高亮-->
            <#if isSingleSelect?? && isSingleSelect!>
                highlight-current-row @current-change="${instanceKey!}SingleSelectRow"
            </#if>
            <#--单双击耦合 增加额外计算时间方法-->
            <#if (colClick?? && colClick!) && dblClick?? && dblClick!>
                @row-click="${instanceKey!}ColClickFront"
                @row-dblclick="${instanceKey!}DblClickFront"
            <#else>
                <#--单击事件-->
                <#if colClick?? && colClick>
                    @row-click="${instanceKey!}ColClick"
                </#if>
                <#--双击事件-->
                <#if dblClick?? && dblClick>
                    @row-dblclick="${instanceKey!}DblClick"
                </#if>
            </#if>
            <#--用户自定义配置-->
            :isUserCustom="${instanceKey!}IsUserCustom"
            :customOptions="${instanceKey!}CustomOptions"
            @saveCustomOptions="${instanceKey!}SaveCustomOptions"
            <#--条件筛选-->
            <#if showFilter?? && showFilter!>
                <#--自定义筛选列保存-->
                :selectFilterId.sync="${instanceKey!}PropsData.selectFilterId"
                :customFilterQueryList="${instanceKey!}CustomFilterList"
                @saveCustomFilterOptions="${instanceKey!}SaveCustomFilterOptions"
                @deleteCustomFilterOptions="${instanceKey!}DeleteCustomFilterOptions"
                @getDeleteCustomId="${instanceKey!}DeleteCustomFilterOptions"
                @custom-filter-change="${instanceKey!}CustomFilterChange"
                @setDefaultFilter="${instanceKey!}SetDefaultFilter"
                @cancelDefaultFilter="${instanceKey!}CancelDefaultFilter"
            </#if>
            <#--导出-->
            <#if showExport?? && showExport!>
                @export="${instanceKey!}Export"
            </#if>
            <#--综合排序-->
            <#if showSort?? && showSort!>
                :multi-sort-option="${instanceKey!}MultiSortOption"
                @multi-sort="${instanceKey!}MultiSort"
            </#if>
            <#--滚动分页-->
            <#if (showCustomList?? && showCustomList!) && (isPagination?? && isPagination!)>
                @next-page="${instanceKey!}NextPage"
                :tableTotal="${TableTotal!}"
            </#if>
            <#if cellClick?? && cellClick>
                @cell-click="${instanceKey!}CellClickInfo"
                :cell-class-name="${instanceKey!}CellClassNAme"
            </#if>
            <#if columnStyle?? && columnStyle>
                :cell-style="${instanceKey!}CellStyle"
            </#if>
            <#if isSortChange?? && isSortChange>
                @sort-change="${instanceKey!}SortChange"
            </#if>
            <#if mergeHead?? && mergeHead>
                :header-cell-style="${instanceKey!}HandMethod"
            </#if>
            <#if showHead?? && !showHead>
                :show-header="${instanceKey!}ShowHeader"
            </#if>
            <#if mergeCol?? && mergeCol>
                :span-method="${instanceKey!}MergeCol"
            </#if>
            <#--循环生成超链接事件-->
            <#list needOperations as item>
                <#if item.isEvent?? && item.isEvent>
                    @${item.eventName}="${instanceKey!}${item.eventName?cap_first}"
                </#if>
            </#list>
    >
    <#--列表列-->
    <@colTree colList=tableShowFields!></@colTree>
    <#if (emptyImageRelativePath?? && emptyImageRelativePath != "") || (emptyText?? && emptyText != "")>
     <div slot="empty">
        <#if emptyImageRelativePath?? && emptyImageRelativePath != "">
          <el-image :src="require('${emptyImageRelativePath}')" style="width: ${emptyImageWidth?c!}px" />
        </#if>
        <#if emptyText?? && emptyText != "">
          <p style="line-height: 1.2">${emptyText!}</p>
        </#if>
     </div>
    </#if>
    </h-table-v1>
    <#--分页组件-->
    <#if isPagination?? && isPagination>
        <div
            class="page"
        <#if showCustomList?? && showCustomList!>
            v-if="!${instanceKey!}CustomOptions.pageType"
        </#if>
        >
            <el-pagination
                background
                @size-change="${instanceKey!}HandleSizeChange"
                @current-change="${instanceKey!}HandleCurrentChange"
                :page-size="${ListQuery}.size"
                :key="${instanceKey!}UpdateKey"
                <#if size?? && size! lt 10>
                :page-sizes="[${size?c!}, 10, 20, 50]"
                <#elseif size?? && size! gt 10 && size! lt 20>
                :page-sizes="[10, ${size?c!}, 20, 50]"
                <#elseif size?? && size! gt 20 && size! lt 50>
                :page-sizes="[10, 20, ${size?c!}, 50]"
                <#elseif size?? && size! gt 50>
                :page-sizes="[10, 20, 50, ${size?c!}]"
                </#if>
                <#if (layout??)>
                    :layout="${instanceKey!}Layout"
                </#if>
                :total="${TableTotal!}"
                :current-page.sync="${CurrentPage!}">
            </el-pagination>
        </div>
    </#if>
</div>
