/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.DataConfigConstant;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.component.RootComponent;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.style.DefaultStyleCacheServiceImpl;
import com.jxdinfo.hussar.formdesign.codegenerator.core.model.CssFileModel;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ExtendCommonUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ExtendFormulaUtil;
import com.jxdinfo.hussar.formdesign.common.constant.SectionConstants;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.params.ComponentPageParams;
import com.jxdinfo.hussar.formdesign.common.model.variables.PageVariables;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.properties.EnvVarsProperties;
import com.jxdinfo.hussar.formdesign.common.service.DefaultStyleCacheService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaCompileReferMethod;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.DefaultStyle;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FrameworkVoidVisitor
implements VoidVisitor<LcdpComponent, Ctx> {
    private static DefaultStyleCacheService defaultStyleCacheService = (DefaultStyleCacheService)SpringUtil.getBean(DefaultStyleCacheServiceImpl.class);
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);
    private static final EnvVarsProperties envVarsProperties = (EnvVarsProperties)SpringUtil.getBean(EnvVarsProperties.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        this.renderState(lcdpComponent, ctx);
        this.renderStyles(ctx);
        this.renderExtendScopedStyles(lcdpComponent, ctx);
        lcdpComponent.registerTemplatePath("/template/elementui/element/framework/framework.ftl");
        lcdpComponent.addRenderParam("datas", (Object)ctx.getDatas());
        lcdpComponent.addRenderParam("methods", (Object)ctx.getMethods());
        lcdpComponent.addRenderParam("computeds", (Object)ctx.getComputeds());
        lcdpComponent.addRenderParam("computedWithGetSets", (Object)ctx.getComputedWithGetSets());
        lcdpComponent.addRenderParam("createds", (Object)ctx.getCreateds());
        lcdpComponent.addRenderParam("mounteds", (Object)ctx.getMounteds());
        lcdpComponent.addRenderParam("customMounteds", (Object)ctx.getCustomMountedStr());
        lcdpComponent.addRenderParam("destroyeds", (Object)ctx.getDestroyeds());
        lcdpComponent.addRenderParam("activateds", (Object)ctx.getActivateds());
        lcdpComponent.addRenderParam("deactivateds", (Object)ctx.getDeactivateds());
        lcdpComponent.addRenderParam("styles", (Object)ctx.getStyles());
        lcdpComponent.addRenderParam("hasNonScopedStyles", (Object)ctx.hasNonScopedStyles());
        lcdpComponent.addRenderParam("extendScopedStyles", (Object)ctx.getExtendScopedStyles());
        lcdpComponent.addRenderParam("nonScopedStyles", (Object)ctx.getNonScopedStyles());
        lcdpComponent.addRenderParam("pageName", (Object)ctx.getPageName());
        lcdpComponent.addRenderParam("importScripts", (Object)ctx.getImports());
        lcdpComponent.addRenderParam("watches", (Object)ctx.getWatches());
        lcdpComponent.addRenderParam("filters", (Object)ctx.getFilter());
        lcdpComponent.addRenderParam("components", (Object)ctx.getComponents());
        lcdpComponent.addRenderParam("rootInstanceKey", (Object)lcdpComponent.getInstanceKey());
        lcdpComponent.addRenderParam("styleSchemeClassName", (Object)lcdpComponent.getStyleSchemeClassName());
        lcdpComponent.addRenderParam("hyperlinksSpan", (Object)".jxd_hyperlinks_span{color: rgb(58, 142, 230);cursor:pointer;}");
        lcdpComponent.addRenderParam("directives", (Object)SectionConstants.VUE_DEFAULT_DIRECTIVES);
        lcdpComponent.addRenderParam("dicts", (Object)ctx.getDictInfo().getDicts());
        lcdpComponent.addRenderParam("optionLoads", (Object)ctx.getDictInfo().getOptionLoads());
        lcdpComponent.addRenderParam("levelDicts", (Object)ctx.getDictInfo().getLevelDicts());
        lcdpComponent.addRenderParam("treeLoads", (Object)ctx.getDictInfo().getTreeLoads());
        lcdpComponent.addRenderParam("dictMethod", (Object)DataConfigConstant.CommonModelCategory.DICTS.getImportMethod());
        lcdpComponent.addRenderParam("treeMethod", (Object)DataConfigConstant.CommonModelCategory.LEVELDICTS.getImportMethod());
        lcdpComponent.addRenderParam("customMethods", lcdpComponent.getProps().get("customMethods"));
        this.renderPageProps(lcdpComponent, ctx);
        this.renderImport(ctx);
        this.renderFlowData(lcdpComponent, ctx);
        this.renderOnload(lcdpComponent, ctx);
        this.renderPageActivated(lcdpComponent, ctx);
        this.renderActivated(lcdpComponent, ctx);
        this.renderPoll(lcdpComponent, ctx);
        this.renderRouter(ctx);
        this.renderPageVariables(ctx);
        this.renderWatchEvents(lcdpComponent, ctx);
    }

    private void renderPageVariables(Ctx ctx) {
        if (ToolUtil.isNotEmpty((Object)ctx.getPageInfo().getPageVariables())) {
            List pageVariables = ctx.getPageInfo().getPageVariables();
            for (PageVariables pageVariable : pageVariables) {
                if (!ToolUtil.isNotEmpty((Object)pageVariable) || !ToolUtil.isNotEmpty((Object)pageVariable.getVariablesName()) || !ToolUtil.isNotEmpty((Object)pageVariable.getVariablesDataType())) continue;
                String variablesDataType = pageVariable.getVariablesDataType();
                String dataName = pageVariable.getVariablesName() + ":";
                if (ToolUtil.isNotEmpty((Object)pageVariable.getDefaultValue())) {
                    JSONObject defaultValueAnalysis = (JSONObject)pageVariable.getDefaultValue();
                    String configData = defaultValueAnalysis.getJSONObject("from").toString();
                    ComponentReference reference = (ComponentReference)JSON.parseObject((String)configData, ComponentReference.class);
                    String result = "''";
                    if (DataFromEnum.INPUT.getValue().equals(reference.getType()) && ToolUtil.isEmpty((Object)reference.getDataType())) {
                        reference.setDataType("string");
                    }
                    try {
                        ComponentData fromComponentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)reference);
                        if (ToolUtil.isNotEmpty((Object)fromComponentData)) {
                            result = fromComponentData.getRenderValue();
                        }
                    }
                    catch (LcdpException e) {
                        e.printStackTrace();
                    }
                    dataName = dataName + result;
                } else {
                    dataName = variablesDataType.equals("string") || variablesDataType.equals("date") ? dataName + "''" : (variablesDataType.equals("double") || variablesDataType.equals("int") ? dataName + 0 : (variablesDataType.equals("boolean") ? dataName + "false" : (variablesDataType.equals("object") ? dataName + "{}" : dataName + "[]")));
                }
                String desc = "\u9875\u9762\u53d8\u91cf";
                desc = ToolUtil.isNotEmpty((Object)pageVariable.getVariablesDesc()) ? pageVariable.getVariablesDesc() + "\uff08\u9875\u9762\u53d8\u91cf\uff09" : pageVariable.getVariablesName() + "\uff08\u9875\u9762\u53d8\u91cf\uff09";
                ctx.addData(dataName, desc);
            }
        }
    }

    private void renderState(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String rootKey = ctx.getRootLcdpComponent().getInstanceKey();
        String commonStateMeName = ctx.getRootLcdpComponent().getInstanceKey() + "PageCommonStateMe";
        StringBuilder allState = new StringBuilder();
        allState.append(this.unsureMethod(commonStateMeName));
        ctx.addMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe", ToolUtil.isNotEmpty((Object)allState) ? allState.toString() : "", false, "\u9875\u9762\u72b6\u6001\u65b9\u6cd5");
        String bpmStateName = this.unsureMethod(rootKey + "BpmStateHandler");
        ctx.addMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe", ToolUtil.isNotEmpty((Object)bpmStateName) ? bpmStateName : "", false, "\u9875\u9762\u72b6\u6001\u65b9\u6cd5");
        StringBuilder stringBuilder = new StringBuilder();
        RootComponent rootComponent = (RootComponent)lcdpComponent;
        stringBuilder.append("const failButContinue = true;\n");
        stringBuilder.append("flowAuth.getOnlineConfig().then((res) => {\nif (res && res.msg === 'true') {\n");
        this.renderFlowAuth(lcdpComponent, ctx, stringBuilder);
        stringBuilder.append("} else {\n");
        Map states = rootComponent.getPageState();
        rootComponent.initPageState();
        if (ToolUtil.isNotEmpty((Object)states)) {
            stringBuilder.append(this.unsureMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe"));
        }
        stringBuilder.append(CodePrefix._SELF.getType() + "alreadyLoad = true;\n");
        stringBuilder.append("if(callBack && typeof callBack === 'function') {callBack();}");
        stringBuilder.append("}\n");
        if (ToolUtil.isNotEmpty((Object)states)) {
            for (Map.Entry state : states.entrySet()) {
                if (!((String)state.getKey()).equals("common")) continue;
                stringBuilder.append(this.unsureMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageAllStateMe"));
            }
        }
        stringBuilder.append("}).catch(() => {" + CodePrefix._SELF.getType() + "$message.error('\u6570\u636e\u8bf7\u6c42\u5f02\u5e38');});");
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("callBack");
        ctx.addMethod(ctx.getRootLcdpComponent().getInstanceKey() + "PageRenderAllState", args, ToolUtil.isNotEmpty((Object)stringBuilder) ? stringBuilder.toString() : "", false, "\u5de5\u4f5c\u6d41\u8868\u5355\u6743\u9650\u65b9\u6cd5");
        ctx.addCreated(CodePrefix._SELF.getType() + ctx.getRootLcdpComponent().getInstanceKey() + "PageRenderAllState" + "();");
    }

    private String unsureMethod(String methodName) {
        return "if(self." + methodName + "){self." + methodName + "();}";
    }

    private void renderFlowAuth(LcdpComponent lcdpComponent, Ctx ctx, StringBuilder stringBuilder) throws LcdpException {
        HashMap<String, String> moduleMap = new HashMap<String, String>();
        ctx.addData("alreadyLoad: false", MultilineExegesisUtil.dealDataExegesis((String)"\u9875\u9762", (String)"alreadyLoad\u5c5e\u6027"));
        lcdpComponent.addRenderParam("isProduce", (Object)true);
        Map componentMap = ctx.getComponentMap();
        StringBuilder disableInstance = new StringBuilder();
        for (Map.Entry component : componentMap.entrySet()) {
            LcdpComponent value = (LcdpComponent)component.getValue();
            if (!ToolUtil.isNotEmpty((Object)value) || !"com.jxdinfo.elementui.JXDElForm".equals(value.getName())) continue;
            String data = value.getInstanceKey() + "Disabled";
            disableInstance.append("self." + data + " = true;");
        }
        moduleMap.put("disableInstanceKey", disableInstance.toString());
        ctx.addImports("*", "flowAuth", "@/api/bpm/flowAuth");
        String dataArrayStr = RenderUtil.renderTemplate((String)"template/elementui/event/FlowAuthConfig.ftl", moduleMap);
        stringBuilder.append(dataArrayStr);
    }

    private void renderStyles(Ctx ctx) {
        for (LcdpComponent component : ctx.getComponentMap().values()) {
            if ("com.jxdinfo.elementui.JXDSingleImgUpload".equals(component.getName())) {
                ctx.addStyle(".flex-img__image {width: 100%;}");
            }
            if (!"com.jxdinfo.elementui.JXDElFileUpload".equals(component.getName())) continue;
            ctx.addStyle(".fileUploadDialog .fileUploadTable /deep/ thead tr th .vxe-cell--edit-icon {display: none;}");
            ctx.addStyle(".fileUploadDialog /deep/ .el-dialog{width: 1064px; height: 602px; top: 200px;}");
            ctx.addStyle(".fileUploadDialog /deep/ .el-dialog .el-dialog__body{padding: 20px 30px;}");
            ctx.addStyle(".fileUploadDialog /deep/ .el-dialog .el-dialog__header{background-color: #F6F7F8;padding: 10px;}");
            ctx.addStyle(".fileUploadDialog /deep/ .el-dialog .el-dialog__header .el-dialog__headerbtn{top: 10px;}");
            ctx.addStyle(".fileUploadDialog /deep/ .el-dialog .el-dialog__header .fileUploadDialogHeader{font-size: 14px;font-family: PingFangSC-Semibold;color: #333333;font-weight: 600;}");
            ctx.addStyle(".fileUploadDialog /deep/ .el-dialog .el-dialog__body .fileUploadDialogBody .fileUploadTable{width: 1004px;height: 472px;}");
            ctx.addStyle(".fileUploadDialog /deep/ .el-dialog .el-dialog__body .fileUploadDialogBody .fileUploadTable .vxe-table--main-wrapper .vxe-table--header thead{font-family: 'bus-PingFangSC';font-size: 14px;color: #666666;opacity: 0.85;font-weight: 500;}");
            ctx.addStyle(".fileUploadDialog /deep/ .el-dialog .el-dialog__body .fileUploadDialogBody .fileUploadTable .vxe-table--main-wrapper .vxe-table--body tbody{font-family: PingFangSC-Regular;font-size: 14px;color: #333333;line-height: 22px;font-weight: 400;}");
            ctx.addStyle(".fileUploadDialog .fileUploadDialogBody .confirmUploadBtn{float: right;top: 20px;padding: 7px 18px;position: relative;width: 92px;height: 34px;background: #2695F9;border-radius: 2px;color: #FFFFFF;margin-left: 0;}");
            ctx.addStyle(".fileUploadDialog .fileUploadDialogBody .cancelUploadBtn{float: right;right: 16px;top: 20px;padding: 7px 18px;position: relative;width: 92px;height: 34px;border-radius: 2px;margin-left: 0;}");
            ctx.addStyle(".fileUploadDialog .fileUploadDialogBody .deleteUploadBtn{top: 20px;padding: 7px 18px;position: relative;width: 92px;height: 34px;border: 1px solid #F44E63;border-radius: 2px;color: #F44E63;margin-left: 0;}");
            ctx.addStyle(".fileUploadDialog .fileUploadDialogBody .deleteUploadBtn:hover{background-color: #FFFFFF;}");
            ctx.addStyle(".fileUploadDialog .fileUploadDialogBody .deleteUploadBtn:focus{background-color: #FFFFFF;}");
            ctx.addStyle(".fileUploadDialog .fileUploadDialogBody .cancelUploadBtn:hover{background-color: #FFFFFF;color: #606266;border-color: #DCDFE6;}");
            ctx.addStyle(".fileUploadTable .drag-btn { cursor: move; font-size: 12px; }");
            ctx.addStyle(".fileUploadTable .vxe-body--row.sortable-ghost, .fileUploadTable .vxe-body--row.sortable-chosen { background-color: #dfecfb; }");
            return;
        }
    }

    private void renderExtendScopedStyles(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        if (lcdpComponent.getProps().get("cssFiles") != null) {
            List cssFileModels = JSON.parseArray((String)lcdpComponent.getProps().get("cssFiles").toString(), CssFileModel.class);
            for (CssFileModel cssFileModel : cssFileModels) {
                if (ToolUtil.isEmpty((Object)cssFileModel.getFileId())) continue;
                String path = FileUtil.posixPath((String[])new String[]{this.fileMappingService.getFormatPath(cssFileModel.getFileId())});
                ctx.addExtendScopedStyles("<style scoped src=\"" + ExtendCommonUtil.addExtendCSSImport((Ctx)ctx, (String)path) + "\"></style>");
            }
        }
    }

    private void renderFlowData(LcdpComponent lcdpComponent, Ctx ctx) {
        Map renderMap = lcdpComponent.getRenderParams();
        for (String key : renderMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains("addFlowFileData")) continue;
            ctx.addData(lcdpComponent.getInstanceKey() + "ShowFlowFile: false,", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feshowFlowFile\u5c5e\u6027"));
            ctx.addData(lcdpComponent.getInstanceKey() + "OldTop: 0,", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feoldTop\u5c5e\u6027"));
            ctx.addData(lcdpComponent.getInstanceKey() + "OldLeft: 0,", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feoldLeft\u5c5e\u6027"));
            ArrayList<String> renderValueArray = new ArrayList<String>();
            renderValueArray.add("val");
            ctx.addWatch(lcdpComponent.getInstanceKey() + "ShowFlowFile", renderValueArray, "const page = document.getElementsByClassName('lcdp_axe')[0];\n        if (val) {\n          this." + lcdpComponent.getInstanceKey() + "OldTop = page.scrollTop;\n          this." + lcdpComponent.getInstanceKey() + "OldLeft = page.scrollLeft;\n        }\n        page.style.overflow = val ? 'hidden' : 'auto';\n        page.scrollLeft  = val ? 0 : this." + lcdpComponent.getInstanceKey() + "OldLeft;\n        page.scrollTop  = val ? 0 : this." + lcdpComponent.getInstanceKey() + "OldTop;", MultilineExegesisUtil.dealWatchExegesis((LcdpComponent)lcdpComponent));
            ctx.addData(lcdpComponent.getInstanceKey() + "ShowPicProcessKey: null,", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u6d41\u7a0b\u56feshowPicProcessKey\u5c5e\u6027"));
            break;
        }
    }

    private void renderImport(Ctx ctx) {
        List formulaReferJsList = ExtendFormulaUtil.getFormulaCompileReferJs((Ctx)ctx);
        if (ToolUtil.isNotEmpty((Object)formulaReferJsList)) {
            for (ExtendFormulaCompileReferMethod referMethod : formulaReferJsList) {
                if (!ToolUtil.isNotEmpty((Object)referMethod.getMethods())) continue;
                for (String method : referMethod.getMethods()) {
                    ctx.addImports(method, referMethod.getPath());
                }
            }
        }
        for (LcdpComponent component : ctx.getComponentMap().values()) {
            DefaultStyle defaultStyles = defaultStyleCacheService.get(component.getName());
            if (HussarUtils.isEmpty((Object)defaultStyles) || !ToolUtil.isNotEmpty((Object)defaultStyles.getProps()) || !ToolUtil.isNotEmpty(defaultStyles.getProps().get("isEChart")) || !((Boolean)defaultStyles.getProps().get("isEChart")).booleanValue()) continue;
            ctx.addImports("*", "elementResizeDetectorMaker", "element-resize-detector");
            String mountedStr = "const ERD = elementResizeDetectorMaker();";
            if (!component.isVerticalFill() && !component.isHorizontalFill()) continue;
            ctx.addMounted(mountedStr);
            return;
        }
    }

    private void renderOnload(LcdpComponent lcdpComponent, Ctx ctx) {
        Map mountedMap = ctx.getMethods();
        for (String key : mountedMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains(lcdpComponent.getInstanceKey() + "Onload")) continue;
            lcdpComponent.addRenderParam("isOnload", (Object)true);
            break;
        }
    }

    private void renderPageProps(LcdpComponent lcdpComponent, Ctx ctx) {
        boolean hasPageInfo = ToolUtil.isNotEmpty((Object)ctx.getPageInfo());
        ArrayList paramList = new ArrayList();
        if (hasPageInfo && ToolUtil.isNotEmpty((Object)ctx.getPageInfo().getComponentParams())) {
            List params = ctx.getPageInfo().getComponentParams();
            for (ComponentPageParams entry : params) {
                String paramName = entry.getParamName();
                String paramDataType = entry.getParamDataType();
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("paramName", paramName);
                if ("arrayPrimary".equals(paramDataType)) {
                    paramDataType = "array";
                }
                if ("treeObject".equals(paramDataType)) {
                    paramDataType = "object";
                }
                if ("int".equals(paramDataType) || "double".equals(paramDataType)) {
                    paramDataType = "number";
                }
                paramMap.put("paramDataType", paramDataType);
                paramList.add(paramMap);
            }
        }
        lcdpComponent.addRenderParam("props", paramList);
    }

    private void renderPoll(LcdpComponent lcdpComponent, Ctx ctx) {
        Map mountedMap = ctx.getMethods();
        ArrayList<String> destroyPolls = new ArrayList<String>();
        boolean pollSwitchMethod = false;
        for (String key : mountedMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains(lcdpComponent.getInstanceKey() + "PollName")) continue;
            pollSwitchMethod = true;
            ctx.addData(key + "Destroy: null", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"destroy\u5c5e\u6027"));
            destroyPolls.add(key + "Destroy");
        }
        lcdpComponent.addRenderParam("destroyPolls", destroyPolls);
        lcdpComponent.addRenderParam("pollSwitchMethod", (Object)pollSwitchMethod);
        lcdpComponent.addRenderParam("polls", lcdpComponent.getProps().get("polls"));
    }

    private void renderPageActivated(LcdpComponent lcdpComponent, Ctx ctx) {
        Map activatedMap = ctx.getMethods();
        for (String key : activatedMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains(lcdpComponent.getInstanceKey() + "PageActivated")) continue;
            ctx.addActivated("if(!" + CodePrefix._SELF.getType() + "isFirstCreate ){\n" + CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "PageActivated();\n}");
            break;
        }
    }

    private void renderActivated(LcdpComponent lcdpComponent, Ctx ctx) {
        ctx.addData("isFirstCreate: true", MultilineExegesisUtil.dealDataExegesis((String)"\u9875\u9762", (String)"isFirstCreate\u5c5e\u6027"));
        Map activatedMap = ctx.getMethods();
        for (String key : activatedMap.keySet()) {
            if (!ToolUtil.isNotEmpty((Object)key) || !key.contains(lcdpComponent.getInstanceKey() + "Activated")) continue;
            ctx.addActivated("if(!" + CodePrefix._SELF.getType() + "isFirstCreate && HussarRouter.query(self, 'refresh')){\n" + CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "Activated();\n}");
            ctx.addDeactivated(CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "firstCreated = false");
            ctx.addActivated("if(!" + CodePrefix._SELF.getType() + "isFirstCreate && HussarRouter.query(self, 'systemParams') && JSON.parse(HussarRouter.query(self, 'systemParams')).refresh === 1){\n" + CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "Activated();\n}");
            break;
        }
        ctx.addActivated(CodePrefix._SELF.getType() + "isFirstCreate = false;");
    }

    private void renderRouter(Ctx ctx) {
        ctx.addImports("*", "HussarRouter", "@/utils/HussarRouter");
    }

    private void renderWatchEvents(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("pageWatchEvents"))) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("instanceKey", lcdpComponent.getInstanceKey());
            JSONArray pageWatchEvents = JSONArray.parseArray((String)lcdpComponent.getProps().get("pageWatchEvents").toString());
            for (int i = 0; i < pageWatchEvents.size(); ++i) {
                ComponentData watchParamData;
                JSONObject jsonObject = JSON.parseObject((String)pageWatchEvents.get(i).toString());
                ComponentReference watchParam = (ComponentReference)JSON.parseObject((String)jsonObject.getString("watchParam"), ComponentReference.class);
                if (ToolUtil.isEmpty((Object)watchParam) || ToolUtil.isEmpty((Object)(watchParamData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)watchParam)))) continue;
                if (ToolUtil.isNotEmpty((Object)watchParamData.getRenderValue())) {
                    params.put("watchParam", watchParamData.getRenderValue());
                }
                String watchType = jsonObject.get((Object)"watchType").toString();
                params.put("watchType", watchType);
                params.put("eventEName", ToolUtil.firstLetterToUpper((String)jsonObject.get((Object)"eventEName").toString()));
                String eventName = jsonObject.get((Object)"eventName").toString();
                ctx.addComputed(lcdpComponent.getInstanceKey() + "WatchParam" + i, RenderUtil.renderTemplate((String)"/template/elementui/element/framework/watch_events_computed_param.ftl", params), true, lcdpComponent.getInstanceKey() + "\u76d1\u542c\u4e8b\u4ef6\u3010" + eventName + "\u3011\u7684\u76d1\u542c\u6570\u636e");
                ArrayList<String> watchParams = new ArrayList<String>();
                watchParams.add("newValue");
                watchParams.add("oldValue");
                if ("normal".equals(watchType)) {
                    ctx.addWatch(lcdpComponent.getInstanceKey() + "WatchParam" + i, watchParams, RenderUtil.renderTemplate((String)"/template/elementui/element/framework/watch_events_watch.ftl", params), lcdpComponent.getInstanceKey() + "WatchParam" + i + "\u7684\u76d1\u542c");
                    continue;
                }
                ctx.addWatch("'" + lcdpComponent.getInstanceKey() + "WatchParam" + i + "'", RenderUtil.renderTemplate((String)"/template/elementui/element/framework/watch_events_watch.ftl", params), lcdpComponent.getInstanceKey() + "WatchParam" + i + "\u7684\u76d1\u542c");
            }
        }
    }
}

