<div
    <#list attributes!?keys as key>
        ${key}="${attributes[key]}"
    </#list>
    <#if (disabled??)>
        :class="{'disabled':${instanceKey!}Disabled}"
    </#if>
    ref="${instanceKey!}ImgUpload"
>
    <el-upload class="jxd-upload-item" :action="${instanceKey!}UploadApi" list-type="picture-card"
               :file-list="${instanceKey!}Files"
               :http-request="${instanceKey!}UploadMethod"
                <#if limit?? && limit! gt 0>
                    :limit="${limit!}" :on-exceed="${instanceKey!}HandleExceed"
                </#if>
               ref="${instanceKey!}Ref"
                :headers="Headers"
               :on-success="${instanceKey!}UploadSuccess"
               :before-upload="${instanceKey!}BeforeUpload"
                <#if isExistBig?? && isExistBig!>
                    :on-preview="${instanceKey!}HandlePictureCardPreview"
                </#if>

               <#--:on-remove="${instanceKey!}HandleRemove"-->
                :disabled="${instanceKey!}Disabled"
            multiple accept="image/jpeg,image/jpg,image/png">
    <i class="jxd-uploader-icon <#if iconClassName??>${iconClassName!}<#else>el-icon-plus</#if>"></i>
            <div slot="file" slot-scope="{ file }" class="el-upload-list-slot">
                <blob-img class="el-upload-list__item-thumbnail" :file="file" :src="file.url"></blob-img>
                <span class="el-upload-list__item-actions">
                    <span v-if="!${instanceKey!}Disabled" class="el-upload-list__item-delete" @click="${instanceKey!}HandleRemove(file)">
                        <i class="el-icon-delete"></i>
                    </span>
                </span>
            </div>
    </el-upload>
            <#if isExistBig?? && isExistBig!>
                 <el-dialog :append-to-body="true" :visible.sync="dialogVisible">
                  <img width="100%" :src="dialogImageUrl" alt="">
                 </el-dialog>
            </#if>

    <input type="hidden" ${valueData!} />
<#--    <el-dialog class="jxd_ins_elDialog upload-img-dialog" :visible.sync="${instanceKey!}DialogVisible" :append-to-body=true>-->
<#--        <img :src="${instanceKey!}DialogUrl">-->
<#--    </el-dialog>-->
</div>
