/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.HhRadioGroup.value")
@Scope(value="prototype")
public class HRadioGroupValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String setValue(List<String> dataItems) {
        return "";
    }

    public Map<String, String> getComponentColMapping() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String label = "name";
        String value = "value";
        String cusLabel = "cusLabel";
        String cusValue = "cusValue";
        if (ToolUtil.isNotEmpty(this.lcdpComponent.getProps().get(cusLabel))) {
            label = String.valueOf(this.lcdpComponent.getProps().get("cusLabel"));
        }
        if (ToolUtil.isNotEmpty(this.lcdpComponent.getProps().get(cusValue))) {
            value = String.valueOf(this.lcdpComponent.getProps().get("cusValue"));
        }
        map.put("label", label);
        map.put("value", value);
        return map;
    }

    public String getDefaultValue() {
        return "''";
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem = dataItems.get(0);
            String relativeField = this.getRelativeDataField(dataItem, this.lcdpComponent);
            if ("data".equals(dataItem)) {
                if (dataItems.size() == 1) {
                    return this.getOptionData();
                }
                String data = dataItems.get(1);
                return this.getValueLabelData(data);
            }
            if ("value".equals(dataItem)) {
                return this.getValueData();
            }
            if ("label".equals(dataItem) || HussarUtils.isNotEmpty((Object)relativeField)) {
                ComponentData labelData = new ComponentData();
                labelData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                String optionData = this.getOptionData().getRenderValue();
                labelData.setRenderValue("function() {\n for(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nif(" + optionData + "[i].value === " + this.getValueData().getRenderValue() + "){\nreturn " + optionData + "[i]." + (HussarUtils.isNotEmpty((Object)relativeField) ? relativeField : "name") + ";\n}\n}\nreturn '';\n}()");
                return labelData;
            }
        }
        return this.getValueData();
    }

    private String getRelativeDataField(String dataItem, LcdpComponent lcdpComponent) {
        String relativeField = "";
        JSONArray array = (JSONArray)lcdpComponent.getProps().get("relativeData");
        if (HussarUtils.isNotEmpty((Object)array)) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String relativeId = String.valueOf(jsonObject.get((Object)"id"));
                if (!dataItem.equals(relativeId)) continue;
                relativeField = String.valueOf(jsonObject.get((Object)"field"));
                return relativeField;
            }
        }
        return relativeField;
    }

    public ComponentData getDefaultValueByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    private ComponentData getValueLabelData(String dataItem) throws LcdpException {
        ComponentData data = new ComponentData();
        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        String optionData = this.getOptionData().getRenderValue();
        if ("label".equals(dataItem)) {
            data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i].label);\n}\nreturn flag;}()");
        } else if ("value".equals(dataItem)) {
            data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i].value);\n}\nreturn flag;}()");
        } else {
            String relativeField = this.getRelativeDataField(dataItem, this.lcdpComponent);
            if (ToolUtil.isNotEmpty((Object)relativeField)) {
                data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i]." + relativeField + ");\n}\nreturn flag;}()");
            }
        }
        return data;
    }

    private ComponentData getOptionData() throws LcdpException {
        ComponentData optionData = new ComponentData();
        ArrayList<String> optionDataItem = new ArrayList<String>();
        optionDataItem.add("data");
        optionData.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        optionData.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
        optionData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._OPTION.getType(), optionDataItem));
        return optionData;
    }

    private ComponentData getValueData() throws LcdpException {
        ComponentData valueData = new ComponentData();
        valueData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("value")));
        return valueData;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return Collections.singletonList(new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("value"))));
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        return null;
    }
}

