/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.ExtendFormulaUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.DynDataUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaCompileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaCompileReferMethod;
import com.jxdinfo.hussar.formdesign.extend.model.formula.ExtendFormulaInfo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ElHTabsVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("template/elementui/element/hTabs/el_tabs.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.judgeHorizontalAndVerticalFill(lcdpComponent);
        lcdpComponent.addRenderParam("themeName", (Object)lcdpComponent.getStyleSchemeClassName());
    }

    private void judgeHorizontalAndVerticalFill(LcdpComponent lcdpComponent) {
        boolean isHorizontalFill = lcdpComponent.isHorizontalFill();
        boolean isVerticalFill = lcdpComponent.isVerticalFill();
        List scrollList = JSON.parseArray((String)lcdpComponent.getProps().get("scrollList").toString(), HashMap.class);
        int realWidth = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(lcdpComponent.getInnerStyles().get("realWidth")), (String)"px"));
        int realHeight = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(lcdpComponent.getInnerStyles().get("realHeight")), (String)"px"));
        for (HashMap hashMap : scrollList) {
            int scrollWidth = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(hashMap.get("scrollWidth")), (String)"px"));
            int scrollHeight = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(hashMap.get("scrollHeight")), (String)"px"));
            int diffX = scrollWidth - realWidth;
            int diffY = scrollHeight - realHeight;
            if (isHorizontalFill) {
                hashMap.put("scrollWidth", "calc(100% + " + diffX + "px)");
            } else if (diffX == 0) {
                hashMap.put("scrollWidth", "100%");
            }
            if (isVerticalFill) {
                hashMap.put("scrollHeight", "calc(100% + " + diffY + "px)");
                continue;
            }
            if (diffY != 0) continue;
            hashMap.put("scrollHeight", "100%");
        }
        lcdpComponent.addRenderParam("scrolls", (Object)scrollList);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap tabMap = new HashMap();
        tabMap.put("active", lcdpComponent.getProps().get("defaultActiveTab"));
        tabMap.put("stretch", lcdpComponent.getProps().get("stretch"));
        tabMap.put("id", lcdpComponent.getInstanceKey());
        List tabList = JSON.parseArray((String)lcdpComponent.getProps().get("tabList").toString(), HashMap.class);
        JSONObject fromComponentParams = JSON.parseObject((String)String.valueOf(lcdpComponent.getProps().get("formComponentParams")));
        ArrayList fromComponentParamList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)fromComponentParams)) {
            for (Object entry : fromComponentParams.entrySet()) {
                HashMap fromComponentParam = new HashMap();
                fromComponentParam.put(entry.getKey(), entry.getValue());
                fromComponentParamList.add(fromComponentParam);
            }
        }
        int index = 0;
        for (HashMap tab : tabList) {
            String routePath = "";
            if (ToolUtil.isNotEmpty(tab.get("outLink"))) {
                routePath = tab.get("outLink").toString();
                tab.put("outLink", routePath);
                tab.put("url", "");
                continue;
            }
            if (!ToolUtil.isNotEmpty(tab.get("url"))) continue;
            StringBuilder props = new StringBuilder();
            StringBuilder triggers = new StringBuilder();
            JSONObject pageParamConfig = (JSONObject)((HashMap)JSON.parseObject((String)tab.get("url").toString(), HashMap.class)).get("pageParamConfig");
            List events = lcdpComponent.getEvents();
            String id = ((HashMap)JSON.parseObject((String)tab.get("url").toString(), HashMap.class)).get("fileId").toString();
            routePath = FileUtil.posixPath((String[])new String[]{this.fileMappingService.getFormatPath(id)});
            Map<String, String> name = this.getComponentNameFromPath(routePath);
            String tabName = name.get("componentName");
            String componentName = name.get("importName");
            for (Object entry : events) {
                String eventName = entry.getTrigger();
                String oldName = "";
                List eventTriggers = lcdpComponent.getDynamicEventTriggers();
                for (Object eventTrigger : eventTriggers) {
                    Map e = DynDataUtil.asObject(eventTrigger).orElse(Collections.emptyMap());
                    if (!eventName.equals(e.get("name"))) continue;
                    oldName = String.valueOf(e.get("oName"));
                }
                if (entry.getTrigger().contains(String.valueOf(tab.get("slotName")))) {
                    String strTrigger = " @" + oldName + " =" + lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)eventName);
                    triggers.append(strTrigger);
                }
                this.removeTiggers(lcdpComponent, eventName);
            }
            for (Object entry : pageParamConfig.entrySet()) {
                HashMap<String, Map<String, Object>> moduleMap = new HashMap<String, Map<String, Object>>();
                String key = String.valueOf(entry.getKey());
                JSONObject value = JSON.parseObject((String)JSON.toJSONString(entry.getValue()));
                String propValue = lcdpComponent.getInstanceKey() + componentName + index + ToolUtil.firstLetterToUpper((String)key);
                if (!ToolUtil.isNotEmpty((Object)value) || !ToolUtil.isNotEmpty(value.get("type"))) continue;
                String strProp = " :" + key + " = " + propValue;
                props.append(strProp);
                Map<String, Object> config = ElHTabsVoidVisitor.getRenderPageParamData(ctx, (Map.Entry<String, Object>)entry);
                if (config.size() > 0) {
                    moduleMap.put("params", config);
                }
                ctx.addComputed(propValue, RenderUtil.renderTemplate((String)"template/elementui/element/hTabs/tab_props.ftl", moduleMap), false, MultilineExegesisUtil.dealComputedExegesis((LcdpComponent)lcdpComponent));
            }
            String refTab = " ref='" + tabName + "Ref'";
            tab.put("url", routePath);
            tab.put("pageName", "<" + tabName + refTab + props + triggers + " ></" + tabName + ">");
            ctx.addImports("import " + componentName + " from '#/views" + routePath + "'");
            ctx.addComponent(componentName);
            ++index;
        }
        String dataArrayStr = RenderUtil.renderTemplate((String)"template/elementui/element/hTabs/tab_data.ftl", tabMap);
        ctx.addData(dataArrayStr);
        String tooltipDisabled = "";
        for (HashMap tab : tabList) {
            tooltipDisabled = tooltipDisabled.concat(tab.get("slotName") + ": true,");
        }
        ctx.addData(lcdpComponent.getInstanceKey() + "TabTooltipDisabled: {" + tooltipDisabled + "}");
        lcdpComponent.addRenderParam("tabs", (Object)tabList);
    }

    private Map<String, String> getComponentNameFromPath(String path) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] str = path.split("/");
        StringBuilder componentName = new StringBuilder("");
        StringBuilder importName = new StringBuilder("");
        for (int i = 0; i < str.length; ++i) {
            if ("".equals(importName.toString())) {
                componentName.append(str[i].toLowerCase());
            } else {
                componentName.append("-" + str[i].toLowerCase());
            }
            importName.append(ToolUtil.firstLetterToUpper((String)str[i].toLowerCase()));
        }
        result.put("componentName", componentName.toString());
        result.put("importName", importName.toString());
        return result;
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        ctx.addComputed("url", "return window.location.origin + '/#';", false, MultilineExegesisUtil.dealComputedExegesis((LcdpComponent)lcdpComponent));
        ArrayList<String> param = new ArrayList<String>();
        String instanceKey = lcdpComponent.getInstanceKey();
        lcdpComponent.addAttr(":props", instanceKey + "Props");
        if (HussarUtils.isNotEmpty((Object)lcdpComponent.getProps())) {
            for (Map tab : (List)lcdpComponent.getProps().get("tabList")) {
                if (!(tab.get("tabName") instanceof Map) || !"formula".equals(((Map)tab.get("tabName")).get("type"))) continue;
                tab.put("tabName", ((Map)tab.get("tabName")).get("showName"));
            }
            for (Map scroll : (List)lcdpComponent.getProps().get("scrollList")) {
                if (!(scroll.get("tabName") instanceof Map) || !"formula".equals(((Map)scroll.get("tabName")).get("type"))) continue;
                scroll.put("tabName", ((Map)scroll.get("tabName")).get("showName"));
            }
        }
        ctx.addData(instanceKey + "Props:" + JSON.toJSONString((Object)lcdpComponent.getProps()));
        HashMap<String, String> params = new HashMap<String, String>();
        param.add("key");
        param.add("tabRef");
        param.add("tabName");
        ctx.addImports("TabTooltipHiddenPublic", "@/pages/index/utils/lowcode/tabTooltipUtil");
        ctx.addMethod("TabTooltipHidden", param, RenderUtil.renderTemplate((String)"/template/elementui/element/hTabs/tab_tooltipHidden.ftl", params), true);
        List tabs = (List)lcdpComponent.getRenderParams().get("tabs");
        for (Map tab : tabs) {
            params.put("tabName", "");
            String name = lcdpComponent.getInstanceKey();
            if (HussarUtils.isNotEmpty(tab.get("tabName")) && tab.get("tabName") instanceof String) {
                params.put("tabName", "'" + tab.get("tabName") + "'");
            } else if (HussarUtils.isNotEmpty(tab.get("tabName")) && tab.get("tabName") instanceof Map && HussarUtils.isNotEmpty(((Map)tab.get("tabName")).get("type")) && DataFromEnum.EXTEND_FORMULA.getValue().equals(((Map)tab.get("tabName")).get("type")) && HussarUtils.isNotEmpty(((Map)tab.get("tabName")).get("formulaEditor"))) {
                String formula = ((JSONObject)((Map)tab.get("tabName")).get("formulaEditor")).toJSONString();
                ExtendFormulaInfo formulaInfo = (ExtendFormulaInfo)JSON.parseObject((String)formula, ExtendFormulaInfo.class);
                ExtendFormulaCompileInfo compileInfo = ExtendFormulaUtil.getFormulaCompile((ExtendFormulaInfo)formulaInfo, (Ctx)ctx);
                if (HussarUtils.isNotEmpty((Object)compileInfo)) {
                    params.put("tabName", compileInfo.getFormulaStr());
                }
                if (HussarUtils.isNotEmpty((Object)formulaInfo.getReferMethods())) {
                    ArrayList formulaReferJsList = new ArrayList();
                    formulaReferJsList.addAll(ExtendFormulaUtil.getImportPath((List)formulaInfo.getReferMethods(), (String)ctx.getPageInfo().getType()));
                    if (HussarUtils.isNotEmpty(formulaReferJsList)) {
                        for (ExtendFormulaCompileReferMethod referMethod : formulaReferJsList) {
                            if (!HussarUtils.isNotEmpty((Object)referMethod.getMethods())) continue;
                            for (String method : referMethod.getMethods()) {
                                ctx.addImports(method, referMethod.getPath());
                            }
                        }
                    }
                }
            }
            name = name + tab.get("slotName");
            ctx.addMethod(name, RenderUtil.renderTemplate((String)"template/elementui/element/hTabs/tab_tabName.ftl", params), true);
        }
    }

    private void removeTiggers(LcdpComponent lcdpComponent, String eventName) {
        lcdpComponent.getTrigger().removeIf(trigger -> trigger.getName().equals(eventName));
    }

    private static Map<String, Object> getRenderPageParamData(Ctx ctx, Map.Entry<String, Object> entry) throws LcdpException {
        HashMap<String, Object> paramConfig = new HashMap<String, Object>();
        ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)entry.getValue().toString(), ComponentReference.class);
        ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
        if (null != data) {
            paramConfig.put(entry.getKey(), data.getRenderValue());
        } else {
            paramConfig.put(entry.getKey(), "''");
        }
        return paramConfig;
    }
}

