/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;

public class BimPowerPlantVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        lcdpComponent.registerTemplatePath("/template/elementui/element/bimPowerPlant/el_bimPowerPlant.ftl");
        JSONObject jsonObject = (JSONObject)lcdpComponent.getProps().get("bimImage");
        String imgPath = jsonObject.get((Object)"imgRelativePath").toString();
        boolean havePath = false;
        if (!"/images/fail.png".equals(imgPath)) {
            String imgName = imgPath.substring(imgPath.lastIndexOf(47) + 1);
            String projectDirectory = imgName.substring(0, imgName.indexOf(46));
            imgPath = '/' + projectDirectory.toLowerCase() + "/index.html";
            havePath = true;
        }
        lcdpComponent.addRenderParam("havePath", (Object)havePath);
        lcdpComponent.addRenderParam("src", (Object)imgPath);
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) {
        ArrayList<String> eventMap = new ArrayList<String>();
        for (int i = 0; i < lcdpComponent.getEvents().size(); ++i) {
            String eventName = ((EventConfig)lcdpComponent.getEvents().get(i)).getTrigger();
            String eventNameUpper = eventName.substring(0, 1).toUpperCase() + eventName.substring(1, eventName.length() - 5);
            eventMap.add(eventNameUpper);
        }
        for (String s : eventMap) {
            if ("CoolingTower".equals(s)) {
                ctx.addMounted("window[\"showCoolingTower\"] = () => {\n        this." + lcdpComponent.getInstanceKey() + s + "Click();\n      };");
                continue;
            }
            if ("BoilerRoom".equals(s)) {
                ctx.addMounted("window[\"showBoilerRoom\"] = () => {\n        this." + lcdpComponent.getInstanceKey() + s + "Click();\n      };");
                continue;
            }
            if (!"Chimney".equals(s)) continue;
            ctx.addMounted("window[\"showChimney\"] = () => {\n        this." + lcdpComponent.getInstanceKey() + s + "Click();\n      };");
        }
    }
}

