/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.elementui.visitor.element.ScrollContainerVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class ScrollContainer
extends LcdpComponent {
    public static ScrollContainer newComponent(JSONObject jsonObject) {
        ScrollContainer scrollContainer = (ScrollContainer)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)ScrollContainer.class.getName()));
        Object backgroundImg = scrollContainer.getStyles().get("backgroundImageBack");
        scrollContainer.getStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            scrollContainer.getStyles().put("backgroundImage", backgroundImg);
        }
        if (!scrollContainer.isHorizontalFill()) {
            scrollContainer.getInnerStyles().put("realScrollWid", scrollContainer.getInnerStyles().get("scrollWidth"));
        }
        if (!scrollContainer.isVerticalFill()) {
            scrollContainer.getInnerStyles().put("realScrollHei", scrollContainer.getInnerStyles().get("scrollHeight"));
        }
        return scrollContainer;
    }

    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.elementui.JXDElScrollContainer";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_elScrollContainer");
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("overFlow", "${prefix} {overflow:${val};}");
        map.put("overFlowHover", "${prefix}:hover {overflow:${val};}");
        map.put("realScrollWid", "${prefix} .scrollContainer{width:${val}}");
        map.put("realScrollHei", "${prefix} .scrollContainer{height:${val}}");
        map.put("Position", "${prefix} .scrollContainer{position:${val}}");
        map.put("scrollDisplay", "${prefix} {overflow:${val}}");
        map.put("hoverScrollDisplay", "${prefix}:hover {overflow:${val}}");
        map.put("scrollColor", "${prefix}::-webkit-scrollbar-thumb {background-color:${val}}");
        map.put("hoverScrollColor", "${prefix}::-webkit-scrollbar-thumb:hover {background-color:${val}}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isShadowNew", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border: none}";
            }
            return "";
        });
        map.put("isShadowNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {box-shadow: none}";
            }
            return "";
        });
        return (Function)map.get(key);
    }

    public VoidVisitor visitor() {
        return new ScrollContainerVoidVisitor();
    }
}

