<#-- 根据 type 的不同，渲染不同展示格式的日期时间选择器 -->
<#if (type! == "time")>
    <el-time-picker
        format="HH:mm:ss"
        <#if valueType! == "string">
            value-format="yyyy-MM-dd HH:mm:ss"
        <#else>
            value-format="yyyy-MM-dd HH:mm:ss"
        </#if>
        prefix-icon="el-icon-date"
        <#if (tabindex??)>
            tabindex="${tabindex!}"
        </#if>
        <#if (placeholder??)>
            placeholder="${placeholder!}"
        </#if>
        <#if (attributes??)>
            <#list attributes! as attribute>
                ${attribute}
            </#list>
        </#if>
        <#if rangeDisabled?? && rangeDisabled != 'null' >
            :picker-options="{disabledDate: ${instanceKey!}DisabledDate}"
        </#if>
        <#if isRange?? && isRange>
            is-range
            :range-separator="'${rangeSeparator!}'"
            :start-placeholder="'${startPlaceholder!}'"
            :end-placeholder="'${endPlaceholder!}'"
        </#if>
    ></el-time-picker>
<#elseif (type! == "year")>
    <el-date-picker
        type="${type!}"
        format="yyyy"
    <#if valueType! == "string">
        value-format="yyyy-MM-dd HH:mm:ss"
    <#else>
        value-format="yyyy-MM-dd HH:mm:ss"
    </#if>
        prefix-icon="el-icon-date"
        <#if (tabindex??)>
            tabindex="${tabindex!}"
        </#if>
        <#if (placeholder??)>
            placeholder="${placeholder!}"
        </#if>
        <#if rangeDisabled?? && rangeDisabled != 'null'>
            :picker-options="{disabledDate: ${instanceKey!}DisabledDate}"
        </#if>
        <#if (attributes??)>
            <#list attributes! as attribute>
                ${attribute}
            </#list>
        </#if>
    ></el-date-picker>
<#elseif (type! == "month")>
    <el-date-picker
    type="<#if isRange?? && isRange>monthrange<#else>${type!}</#if>"
    <#if !(linkPanels?? && linkPanels)>
        unlink-panels
    </#if>
    format="yyyy-MM"
    <#if valueType! == "string">
        value-format="yyyy-MM-dd HH:mm:ss"
    <#else>
        value-format="yyyy-MM-dd HH:mm:ss"
    </#if>
    prefix-icon="el-icon-date"
    <#if (tabindex??)>
        tabindex="${tabindex!}"
    </#if>
    <#if (placeholder??)>
        placeholder="${placeholder!}"
    </#if>
    <#if (attributes??)>
        <#list attributes! as attribute>
            ${attribute}
        </#list>
    </#if>
    <#if rangeDisabled?? && rangeDisabled != 'null'>
        :picker-options="{disabledDate: ${instanceKey!}DisabledDate}"
    </#if>
    <#if isRange?? && isRange>
        :range-separator="'${rangeSeparator!}'"
        :start-placeholder="'${startPlaceholder!}'"
        :end-placeholder="'${endPlaceholder!}'"
    </#if>
    ></el-date-picker>
<#elseif (type! == "date")>
    <el-date-picker
    type="<#if isRange?? && isRange>daterange<#else>${type!}</#if>"
    popper-class="DataTimePicker"
    <#if !(linkPanels?? && linkPanels)>
        unlink-panels
    </#if>
    format="yyyy-MM-dd"
    <#if valueType! == "string">
        value-format="yyyy-MM-dd HH:mm:ss"
    <#else>
        value-format="yyyy-MM-dd HH:mm:ss"
    </#if>
    prefix-icon="el-icon-date"
    <#if (tabindex??)>
        tabindex="${tabindex!}"
    </#if>
    <#if (placeholder??)>
        placeholder="${placeholder!}"
    </#if>
    <#if (attributes??)>
        <#list attributes! as attribute>
            ${attribute}
        </#list>
    </#if>
    <#if rangeDisabled?? && rangeDisabled != 'null'>
        :picker-options="{disabledDate: ${instanceKey!}DisabledDate}"
    </#if>
    <#if isRange?? && isRange>
        :range-separator="'${rangeSeparator!}'"
        :start-placeholder="'${startPlaceholder!}'"
        :end-placeholder="'${endPlaceholder!}'"
    </#if>
    ></el-date-picker>
<#elseif (type! == "datetime")>
    <el-date-picker
    type="<#if isRange?? && isRange>datetimerange<#else>${type!}</#if>"
    <#if !(linkPanels?? && linkPanels)>
        unlink-panels
    </#if>
    format="yyyy-MM-dd HH:mm:ss"
    <#if valueType! == "string">
        value-format="yyyy-MM-dd HH:mm:ss"
    <#else>
        value-format="yyyy-MM-dd HH:mm:ss"
    </#if>
    prefix-icon="el-icon-date"
    <#if (tabindex??)>
        tabindex="${tabindex!}"
    </#if>
    <#if (placeholder??)>
        placeholder="${placeholder!}"
    </#if>
    <#if (attributes??)>
        <#list attributes! as attribute>
            ${attribute}
        </#list>
    </#if>
    <#if rangeDisabled?? && rangeDisabled != 'null'>
        :picker-options="{disabledDate: ${instanceKey!}DisabledDate}"
    </#if>
    <#if isRange?? && isRange>
        :range-separator="'${rangeSeparator!}'"
        :start-placeholder="'${startPlaceholder!}'"
        :end-placeholder="'${endPlaceholder!}'"
    </#if>
    ></el-date-picker>
</#if>
