<template>
    <#if isProduce?? && isProduce>
    <el-form class="lcdp_axe_main" v-show="alreadyLoad">
    <#else>
    <el-form class="lcdp_axe_main">
    </#if>
    <div class="lcdp_axe jxd_ins_elBaseWebPage jxd_additional ${pageName} ${rootInstanceKey}">
        ${body!}
        <#if showFlowFile?? && showFlowFile>
            <flowchart
                    v-if="${instanceKey!}ShowFlowFile"
                    class="workflow"
                    :businessId="${instanceKey!}ShowPicProcessKey"
                    :processKey="hussar_0ProcessKey"
                    :show="${instanceKey!}ShowFlowFile"
                    @close="${instanceKey!}ShowFlowFile=false"/>
        </#if>
        <#if participantDialog?? && participantDialog>
        <participantDialog @close="${instanceKey!}ParticipantDialogVisible = false" @comfirm="${instanceKey!}ComfirmParticipant" :selectionBackup='${instanceKey!}SelectionBackup' :tableData ='${instanceKey!}ParticipantData'  :participantDialogVisible='${instanceKey!}ParticipantDialogVisible' :taskId="${instanceKey!}ParticipantTaskId" :processDefinitionKey="${instanceKey!}ParticipantProcessDefinitionKey" :nodeId="${instanceKey!}FlowData.flowSelect">
        </participantDialog>
            </#if>
        <#if assignParticipantDialog?? && assignParticipantDialog>
            <assignParticipantDialog @close="${instanceKey!}AssignParticipantDialogVisible = false" @comfirm="${instanceKey!}ComfirmAssignParticipant" :selectionBackup='${instanceKey!}AssignSelectionBackup' :assignParticipantData ='${instanceKey!}AssignParticipantData' :assignParticipantDialogVisible='${instanceKey!}AssignParticipantDialogVisible'>
            </assignParticipantDialog>
        </#if>
        <#if consignorDialog?? && consignorDialog>
            <consignorDialog @close="${instanceKey!}ConsignorDialogVisible = false" @comfirm="${instanceKey!}ComfirmConsignor" :selectionBackup='${instanceKey!}SelectedConsignorBackup' :tableData ='${instanceKey!}ConsignorData'  :consignorDialogVisible='${instanceKey!}ConsignorDialogVisible'>
            </consignorDialog>
        </#if>
        <#if customFlowNode??>
            <#list customFlowNode as currentKey>
                <customFlowNode @addCustomNodeExecuteFunction="${instanceKey!}${currentKey!}AddCustomNodeExecuteFunction" @close="${instanceKey!}${currentKey!}CustomFlowNodeVisible = false" :customFlowNodeVisible="${instanceKey!}${currentKey!}CustomFlowNodeVisible" :taskId="${instanceKey!}${currentKey!}CustomFlowNodeTaskId">
                </customFlowNode>
            </#list>
        </#if>
        <#if customFlowNodeSingle??>
            <#list customFlowNodeSingle as currentKey>
                <customFlowNodeSingle @addCustomNodeSignalExecuteFunction="${instanceKey!}${currentKey!}AddCustomNodeSignalExecuteFunction" @close="${instanceKey!}${currentKey!}CustomFlowNodeSingleVisible = false" :customFlowNodeVisible="${instanceKey!}${currentKey!}CustomFlowNodeSingleVisible" :taskId="${instanceKey!}${currentKey!}CustomFlowNodeSingleTaskId">
                </customFlowNodeSingle>
            </#list>
        </#if>
        <#if showSelectParticipant??>
            <#list showSelectParticipant as currentKey>
                <selectParticipant @close="${instanceKey!}${currentKey!}SelectParticipantShow = false" :selectParticipantShow="${instanceKey!}${currentKey!}SelectParticipantShow" @save="${instanceKey!}${currentKey!}FlowFormSubmitSave" :taskId="${instanceKey!}${currentKey!}TaskId" :processDefinitionKey="${instanceKey!}${currentKey!}ProcessDefinitionKey" :doneListIdentification="${instanceKey!}${currentKey!}DoneListIdentification ? ${instanceKey!}${currentKey!}DoneListIdentification : '0'" :isGetRevokeNode="${instanceKey!}${currentKey!}isGetRevokeNode">
                </selectParticipant>
            </#list>
        </#if>
        <#if showSelectEntrust??>
            <#list showSelectEntrust as currentKey>
                <selectEntrust @close="${instanceKey!}${currentKey!}SelectEntrustShow = false" :selectEntrustShow="${instanceKey!}${currentKey!}SelectEntrustShow" @save="${instanceKey!}${currentKey!}TaskEntrustSave">
                </selectEntrust>
            </#list>
        </#if>
        <#if showSelectRejectNode??>
            <#list showSelectRejectNode as currentKey>
                <selectRejectNode @close="${instanceKey!}${currentKey!}SelectRejectNodeShow = false"
                                  :selectRejectNodeShow="${instanceKey!}${currentKey!}SelectRejectNodeShow"
                                  @save="${instanceKey!}${currentKey!}AnyNodeRejectSave"
                                  :taskId="${instanceKey!}${currentKey!}TaskId"
                                  :doneListIdentification="${instanceKey!}${currentKey!}DoneListIdentification ? ${instanceKey!}${currentKey!}DoneListIdentification : '0'"
                                  >
                </selectRejectNode>
            </#list>
        </#if>
        <#if showSelectRejectNodeBack??>
            <#list showSelectRejectNodeBack as currentKey>
                <selectRejectNodeBack @close="${instanceKey!}${currentKey!}selectRejectNodebackShow = false"
                       :selectRejectNodeShow="${instanceKey!}${currentKey!}selectRejectNodebackShow"
                       :selectData="${currentKey!}Data"
                       @save="${instanceKey!}${currentKey!}selectRejectNodebackSave"
                       :taskId="${instanceKey!}${currentKey!}TaskId"
                       :doneListIdentification="${instanceKey!}${currentKey!}DoneListIdentification ? ${instanceKey!}${currentKey!}DoneListIdentification : '0'"
                       >
                </selectRejectNodeBack>
            </#list>
    </#if>
        <#if showFreeReject??>
            <#list showFreeReject as currentKey>
                <freeReject @freeRejectExecuteFunction="${instanceKey!}${currentKey!}FreeRejectExecuteFunction" @close="${instanceKey!}${currentKey!}FreeRejectShow = false" :freeRejectShow="${instanceKey!}${currentKey!}FreeRejectShow" :taskId="${instanceKey!}${currentKey!}FreeRejectTaskId" :flowEventData="${instanceKey!}${currentKey!}FlowEventData">
                </freeReject>
            </#list>
        </#if>
        ${slotCodes.default!}
        ${slot_title!}
        ${slotCodes.treeContextMenu!}
    </div>
    </el-form>
</template>

<script>
    <#list importScripts! as imp>
        ${imp};
    </#list>
    /* ${directives.definitionsBegin} */
    /* ${directives.definitionsEnd} */
    export default {
        name: "${pageName!}",
        components: {
                <#list components as component>
                ${component},
                </#list>
        },
            props: {
                customProps: {
                    type: Object
                }
            <#list props as prop>
                ${prop.paramName}: ${prop.paramDataType?cap_first},
            </#list>
                },
        data() {
            return {
                <#if dicts?? && dicts?size gt 0>
                    dictOptions: [], // 字典数据
                </#if>
                <#if levelDicts?? && levelDicts?size gt 0>
                    levelDictOptions: [], // 多级字典数据
                </#if>
                <#list datas?keys as key>
                    <#assign data=datas[key]>
                    ${key}, <#if data.comments??> <#list data.comments as comment>// ${comment}</#list> </#if>
                </#list>
                hussar_0Disabled: false,
                component: `${formPageUrl!}`,
                /* ${directives.dataBegin} */
                /* ${directives.dataEnd} */
            }
        },
        computed: {
            <#list computeds?keys as key>
                <#assign computed=computeds[key]>
                ${key}(${computed.argBody!}){
                    const self = this;
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            <#list computedWithGetSets?keys as key>
                <#assign computed=computedWithGetSets[key]>
                ${key}:{
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            /* ${directives.computedBegin} */
            /* ${directives.computedEnd} */
        },
        watch: {
            <#list watches?keys as key>
            <#assign watch=watches[key]>
                <#if (key!?index_of('\'') > -1)>
                    ${key}:{
                        <#list watch.bodies as body>
                            ${body}
                        </#list>
                    },
                <#else>
                    ${key}(${watch.argBody!}){
                        <#list watch.bodies as body>
                            ${body}
                        </#list>
                    },
                </#if>
            </#list>
            /* ${directives.watchBegin} */
            /* ${directives.watchEnd} */
        },
        methods: {
            <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
            /**
             * 查询字典数据
             */
            async queryDictOptions() {
                const self = this;
                <#if dicts?? && dicts?size gt 0>
                const queryDictObj = {
                    typeNames: '<#list dicts[0 ..! dicts?size - 1] as dict>${dict},</#list>${dicts[dicts?size - 1]}'
                };
                await dict.${dictMethod}(queryDictObj).then((res) => {
                    if (res.code === 10000 || res.code === 200) {
                        self.dictOptions = res.data;
                        <#list optionLoads as optionLoad>
                        ${optionLoad}
                        </#list>
                    } else {
                        HussarRouter.showMsg(self, '字典数据请求异常', 'error');
                    }
                }).catch(function () {
                    HussarRouter.showMsg(self, '字典数据请求异常', 'error');
                });
                </#if>
                <#if levelDicts?? && levelDicts?size gt 0>
                const queryLevelDictObj = {
                    typeNames: '<#list levelDicts[0 ..! levelDicts?size - 1] as levelDict>${levelDict},</#list>${levelDicts[levelDicts?size - 1]}'
                };
                await dict.${treeMethod}(queryLevelDictObj).then((res) => {
                    if (res.code === 10000 || res.code === 200) {
                        self.levelDictOptions = res.data;
                        <#list treeLoads as treeLoad>
                        ${treeLoad}
                        </#list>
                    } else {
                        HussarRouter.showMsg(self, '字典数据请求异常', 'error');
                    }
                }).catch(function () {
                    HussarRouter.showMsg(self, '字典数据请求异常', 'error');
                });
                </#if>
            },
            </#if>
            <#list methods?keys as key>
            <#assign method=methods[key]>
            <#assign importName=key>
            <#if async?? && async?size gt 0>
            <#list async! as async_importName>
            <#if async_importName == key>
            <#assign importName=("async " + key)?string>
            </#if>
            </#list>
            </#if>
            <#if method.comments??>
            /**
             <#list method.comments as comment>
             * ${comment}
             </#list>
             */
                </#if>
                ${importName}(${method.argBody!}){
                const self = this;
                <#list method.bodies as body>
                ${body}
                </#list>
            },
            </#list>
            /* ${directives.methodsBegin} */
            /* ${directives.methodsEnd} */
        },
        <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
        async </#if> created() {
            const self = this;
            // ${directives.createdBeforeBegin}
            // ${directives.createdBeforeEnd}
            <#list createds! as created>
            ${created}
            </#list>
            <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
            // 查询字典数据
            await self.queryDictOptions();
            </#if>
            // ${directives.createdAfterBegin}
            // ${directives.createdAfterEnd}
        },
        async mounted() {
            const self = this;
            // ${directives.mountedBeforeBegin}
            // ${directives.mountedBeforeEnd}
            <#list mounteds! as mounted>
                ${mounted}
            </#list>
            <#if isOnload?? && isOnload>
                self.${rootInstanceKey!}Onload();
            </#if>
            <#if pollSwitchMethod && pollSwitch?? && pollSwitch>
                <#if polls?? && (polls?size>0)>
                    <#list polls as poll>
                        <#assign str = poll.eventName?cap_first/>
                        <#list methods?keys as key>
                            <#if key == rootInstanceKey + str>
                            self.${key}Destroy = setInterval(() => {
                            const self = this;
                                self.${key}();
                                },<#if poll.pollTime??>${poll.pollTime?c}</#if>);
                            </#if>
                        </#list>
                    </#list>
                </#if>
            </#if>
            <#-- 不重启环境下，实现页面局部刷新 -->
            if (self.$compilationMetadata.strategy) {
                window.curPageSelfFresh = function () {
                    self['${rootInstanceKey!}Activated'] && self.${rootInstanceKey!}Activated();
                };
            }
            // ${directives.mountedAfterBegin}
            // ${directives.mountedAfterEnd}
        },
        filters: {
            <#list filters?keys as key>
            <#assign filter=filters[key]>
            ${key}(${filter.argBody!}){
                <#list filter.bodies as body>
                ${body}
                </#list>
            },
            </#list>
        },
        destroyed() {
            const self = this;
            // ${directives.destroyedBeforeBegin}
            // ${directives.destroyedBeforeEnd}
            <#list destroyeds! as destroyed>
                ${destroyed}
            </#list>
            <#if pollSwitchMethod && pollSwitch?? && pollSwitch>
                <#if destroyPolls?? && (destroyPolls?size>0)>
                    <#list destroyPolls! as destroyPoll>
                        clearInterval(self.${destroyPoll});
                    </#list>
                </#if>
            </#if>
            // ${directives.destroyedAfterBegin}
            // ${directives.destroyedAfterEnd}
        },
        activated() {
            const self = this;
            // ${directives.activatedBeforeBegin}
            // ${directives.activatedBeforeEnd}
            <#list activateds! as activated>
            ${activated}
            </#list>
            <#if isActivated?? && isActivated>
                if(HussarRouter.query(self, 'refresh')){
                    self.${rootInstanceKey!}Activated();
                }
            </#if>
            // ${directives.activatedAfterBegin}
            // ${directives.activatedAfterEnd}
        },
        <#-- 重启环境下，实现页面局部刷新 -->
        beforeRouteUpdate(to, from, next){
            const self = this;
            next();
            if (to.query && to.query.systemParams && JSON.parse(to.query.systemParams).refresh === 1) {
                self['${rootInstanceKey!}Activated'] && self.${rootInstanceKey!}Activated();
            }
        },
        deactivated() {
            const self = this;
            // ${directives.deactivatedBeforeBegin}
            // ${directives.deactivatedBeforeEnd}
            <#list deactivateds! as deactivated>
            ${deactivated}
            </#list>
            // ${directives.deactivatedAfterBegin}
            // ${directives.deactivatedAfterEnd}
        },
        /* ${directives.optionsBegin} */
        /* ${directives.optionsEnd} */
}
</script>

<!-- ${directives.styleBeforeBegin} -->
<!-- ${directives.styleBeforeEnd} -->

<style scoped>
    /*公共，用于固定*/
    .lcdp_axe_main{transform: scale(1);height: 100%;overflow: auto}
    /*公共，用于设置文字提示的最大宽度*/
    .el-tooltip__popper{
        max-width: 500px;
    }
    ${styles!}
    ${hyperlinksSpan}
</style>

<#if hasNonScopedStyles>
<style>
    ${nonScopedStyles!}
</style>
</#if>

<!-- ${directives.styleAfterBegin} -->
<!-- ${directives.styleAfterEnd} -->
