/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.tree.TreeRelativeDataAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDElHTree.value")
@Scope(value="prototype")
public class HTreeValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("id", "id");
        map.put("pid", "pid");
        map.put("label", "label");
        map.put("levelName", "levelName");
        JSONArray colsJson = (JSONArray)this.lcdpComponent.getProps().get("relativeData");
        if (ToolUtil.isNotEmpty((Object)colsJson)) {
            List colsList = colsJson.toJavaList(TreeRelativeDataAnalysis.class);
            colsList.forEach(col -> map.put(col.getId(), col.getField()));
        }
        return map;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        ComponentData data = new ComponentData();
        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        Map<String, String> componentColMapping = this.getComponentColMapping();
        String renderValue = (String)eventParamConfig.getEventParamData().get(0);
        if (eventParamConfig.getEventParamData().size() > 1) {
            if (ToolUtil.isNotEmpty(componentColMapping) && ToolUtil.isNotEmpty((Object)componentColMapping.get(eventParamConfig.getEventParamData().get(1)))) {
                String colField = componentColMapping.get(eventParamConfig.getEventParamData().get(1));
                if (ToolUtil.isNotEmpty((Object)colField)) {
                    data.setRenderValue(renderValue + "." + colField);
                }
            } else {
                data.setRenderValue(String.join((CharSequence)"['", eventParamConfig.getEventParamData()) + "']");
            }
        } else if (ToolUtil.isNotEmpty(eventParamConfig.getEventParamData().get(0))) {
            data.setRenderValue(renderValue);
        }
        if (!"formula".equals(eventParamConfig.getType())) {
            data.setDataType(eventParamConfig.getDataType());
        }
        return data;
    }

    public String getDefaultValue() {
        return null;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            this.getSelectAndTreeData(dataItems, data, dataItems.get(0));
        } else {
            data.setDataType(ComponentData.DataTypeEnum.TREE_OBJECT);
            ArrayList<String> currDataItem = new ArrayList<String>();
            currDataItem.add("data");
            data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), currDataItem));
        }
        return data;
    }

    public ComponentData getDefaultValueByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    private void getSelectAndTreeData(List<String> dataItems, ComponentData data, String dataItem) throws LcdpException {
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        String dataValue = null;
        ArrayList<String> currDataItem = new ArrayList<String>();
        boolean isTreeValue = false;
        if (dataItem.equals("data")) {
            isTreeValue = true;
            currDataItem.add("data");
            data.setDataType(ComponentData.DataTypeEnum.TREE_OBJECT);
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), currDataItem);
            if (ToolUtil.isNotEmpty(this.lcdpComponent.getProps().get("lazy")) && ((Boolean)this.lcdpComponent.getProps().get("lazy")).booleanValue()) {
                dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._LAZY_TREE_DATA.getType(), currDataItem);
            }
        } else if (dataItem.equals("checkedData")) {
            currDataItem.add("checkedData");
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TREE_DATA_CHECKED.getType(), currDataItem);
        } else {
            String dataValueCode;
            String relativeField = this.getRelativeDataField(dataItem, this.lcdpComponent);
            data.setDataType(ComponentData.DataTypeEnum.TREE_OBJECT);
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TREE_DATA_CHECKED.getType(), currDataItem);
            dataValue = dataValueCode = "function() {\n let result = [];\nfor(let i = 0,optionLen = " + dataValue + ".length;i < optionLen;i++){\nresult.push(" + dataValue + "[i]." + (HussarUtils.isNotEmpty((Object)relativeField) ? relativeField : "label") + ");\n}\nreturn result;\n}()";
        }
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            Map<String, String> treeColMapping = this.getComponentColMapping();
            this.getColData(dataItems, data, dataValue, treeColMapping, isTreeValue);
        } else {
            data.setRenderValue(dataValue);
        }
    }

    private void getColData(List<String> dataItems, ComponentData data, String dataValue, Map<String, String> treeColMapping, boolean isTreeData) {
        String fieldId = dataItems.get(1);
        String relativeField = this.getRelativeDataField(fieldId, this.lcdpComponent);
        if (ToolUtil.isNotEmpty(treeColMapping) && treeColMapping.containsKey(fieldId)) {
            if (isTreeData) {
                ComponentDataUtil.addPackageTreeFieldMethod((Ctx)this.ctx);
                data.setRenderValue("function(){\nconst result = [];\nself.packageTreeField(result, " + dataValue + ", '" + treeColMapping.get(fieldId) + "');\nreturn result;}()");
            } else {
                data.setRenderValue("function(){\nconst result = [];" + dataValue + ".forEach((item) => result.push(item." + treeColMapping.get(fieldId) + "));return result;}()");
            }
        } else if (isTreeData) {
            data.setDataType(ComponentData.DataTypeEnum.TREE_OBJECT);
            String optionData = CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
            data.setRenderValue("function() {\n let result = [];\nfor(let i = 0,optionLen = " + optionData + ".length;i < optionLen;i++){\nresult.push(" + optionData + "[i]." + (HussarUtils.isNotEmpty((Object)relativeField) ? relativeField : "label") + ");\n}\nreturn result;\n}()");
        } else {
            data.setDataType(ComponentData.DataTypeEnum.TREE_OBJECT);
            String optionData = CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + CodeSuffix._TREE_DATA_CHECKED.getType();
            data.setRenderValue("function() {\n let result = [];\nfor(let i = 0,optionLen = " + optionData + ".length;i < optionLen;i++){\nresult.push(" + optionData + "[i]." + (HussarUtils.isNotEmpty((Object)relativeField) ? relativeField : "label") + ");\n}\nreturn result;\n}()");
        }
    }

    private String getRelativeDataField(String dataItem, LcdpComponent lcdpComponent) {
        String relativeField = "";
        JSONArray array = (JSONArray)lcdpComponent.getProps().get("relativeData");
        if (HussarUtils.isNotEmpty((Object)array)) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String relativeId = String.valueOf(jsonObject.get((Object)"id"));
                if (!dataItem.equals(relativeId)) continue;
                relativeField = String.valueOf(jsonObject.get((Object)"field"));
                return relativeField;
            }
        }
        return relativeField;
    }

    private ComponentData getOptionData() throws LcdpException {
        ComponentData optionData = new ComponentData();
        ArrayList<String> optionDataItem = new ArrayList<String>();
        optionDataItem.add("data");
        optionData.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        optionData.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
        optionData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._OPTION.getType(), optionDataItem));
        return optionData;
    }
}

