/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HRadarEchartsVisitor
implements VoidVisitor {
    private final FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/hradarecharts/el_radarEcharts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMounted(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderPropsData(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
        lcdpComponent.addAttr(":theme-name", lcdpComponent.getInstanceKey() + "ThemeName");
    }

    private void renderMounted(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        HashMap<String, String> instanceKey = new HashMap<String, String>();
        instanceKey.put("instanceKey", lcdpComponent.getInstanceKey());
        if (lcdpComponent.isVerticalFill() || lcdpComponent.isHorizontalFill()) {
            ctx.addMounted(RenderUtil.renderTemplate((String)"/template/elementui/element/eChartsResize/echarts_resize.ftl", instanceKey));
        }
    }

    private void renderPropsData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        lcdpComponent.addAttr(":props", lcdpComponent.getInstanceKey() + "PropsData");
        String propsData = "";
        if (lcdpComponent.getProps().size() != 0) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (String key : lcdpComponent.getProps().keySet()) {
                String value = lcdpComponent.getProps().get(key).toString();
                if (lcdpComponent.getProps().get(key) instanceof String) {
                    value = "'" + value + "'";
                }
                props.put(key, value);
            }
            HashMap<String, HashMap<String, String>> renderParams = new HashMap<String, HashMap<String, String>>();
            renderParams.put("echartsMaps", props);
            propsData = propsData + RenderUtil.renderTemplate((String)"/template/elementui/element/HBarEcharts/echarts-props-data.ftl", renderParams);
        }
        ctx.addData(lcdpComponent.getInstanceKey() + "PropsData: {" + propsData + " }");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) {
        String instanceKey = lcdpComponent.getInstanceKey();
        Integer height = lcdpComponent.getHeight();
        Integer width = lcdpComponent.getWidth();
        if (ToolUtil.isNotEmpty(lcdpComponent.getInnerStyles().get("borderTop"))) {
            String borderTop = String.valueOf(lcdpComponent.getInnerStyles().get("borderTop"));
            ctx.addData(instanceKey + "BorderTop: " + borderTop.substring(0, borderTop.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getInnerStyles().get("borderBottom"))) {
            String borderBottom = String.valueOf(lcdpComponent.getInnerStyles().get("borderBottom"));
            ctx.addData(instanceKey + "BorderBottom: " + borderBottom.substring(0, borderBottom.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getInnerStyles().get("borderLeft"))) {
            String borderLeft = String.valueOf(lcdpComponent.getInnerStyles().get("borderLeft"));
            ctx.addData(instanceKey + "BorderLeft: " + borderLeft.substring(0, borderLeft.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getInnerStyles().get("borderRight"))) {
            String borderRight = String.valueOf(lcdpComponent.getInnerStyles().get("borderRight"));
            ctx.addData(instanceKey + "BorderRight: " + borderRight.substring(0, borderRight.indexOf("px")));
        }
        ctx.addData(instanceKey + "Height: " + height);
        ctx.addData(instanceKey + "Width: " + width);
        String styleSchemeClassName = lcdpComponent.getStyleSchemeClassName();
        ctx.addData(lcdpComponent.getInstanceKey() + "ThemeName: '" + styleSchemeClassName + "'");
        ctx.addData(instanceKey + "QueryData: {legend: '',}");
    }

    private void setDataModel(Map<String, Object> params, DataSModelAnalysis dataModelAnalysis, LcdpComponent lcdpComponent, Ctx ctx) throws IOException, LcdpException {
        DataSConditionAnalysis dataConditionAnalysis = dataModelAnalysis.getCondition();
        Map dataFieldAnalysisMap = dataModelAnalysis.getFields();
        String labelField = "";
        String valueField = "";
        String groupField = "";
        if (ToolUtil.isNotEmpty((Object)dataFieldAnalysisMap)) {
            for (Map.Entry fieldList : dataFieldAnalysisMap.entrySet()) {
                List fieldAnalyses = (List)fieldList.getValue();
                for (DataSFieldAnalysis dataFieldAnalysis : fieldAnalyses) {
                    String dataItemValue;
                    List dataItemPath = dataFieldAnalysis.getDataItemPath();
                    if (!ToolUtil.isNotEmpty((Object)dataItemPath)) continue;
                    switch (dataItemValue = (String)dataItemPath.get(dataItemPath.size() - 1)) {
                        case "label": {
                            labelField = dataFieldAnalysis.getFieldName();
                            break;
                        }
                        case "value": {
                            valueField = dataFieldAnalysis.getFieldName();
                            break;
                        }
                        case "group": {
                            groupField = dataFieldAnalysis.getFieldName();
                            break;
                        }
                    }
                }
            }
        }
        if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField) && ToolUtil.isNotEmpty((Object)groupField)) {
            String sortConditionName;
            DataSortConditionAnalysis dataSortConditionAnalysis;
            String querySelectionName;
            List conditionList;
            String operationName = "hussarQuery";
            String apiFileName = "";
            String apiFilePath = "";
            String dataModelId = dataModelAnalysis.getDataModelId();
            if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                apiFileName = this.fileMappingService.getFileName(dataModelId);
                apiFilePath = this.fileMappingService.getImportPath(dataModelId);
            }
            if (ToolUtil.isNotEmpty((Object)dataConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataConditionAnalysis.getQueryConditionModelList()))) {
                params.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                params.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
            }
            if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataConditionAnalysis.getSelectCondition()))) {
                operationName = operationName + querySelectionName;
            }
            if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                operationName = operationName + sortConditionName;
            }
            if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
            }
            params.put("importName", apiFileName);
            params.put("importMethod", operationName);
            params.put("axisCols", labelField);
            params.put("seriesCols", valueField);
            params.put("groupValue", groupField);
        }
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        DataSAnalysis dataAnalysis;
        DataSModelAnalysis dataModelAnalysis;
        HashMap<String, Object> params = new HashMap<String, Object>(100);
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        this.renderDadaValue(lcdpComponent, ctx, params);
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            params.put("isQuoteOrGetValue", "true");
        }
        if (ToolUtil.isNotEmpty((Object)(dataModelAnalysis = (dataAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class)).getDatamodel()))) {
            this.setDataModel(params, dataModelAnalysis, lcdpComponent, ctx);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("n");
        ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"/template/elementui/element/hradarecharts/el_radarEcharts_Success.ftl", params));
        ctx.addMethod(lcdpComponent.getInstanceKey() + "DataClick", Collections.singletonList("queryData"), RenderUtil.renderTemplate((String)"/template/elementui/element/hradarecharts/data_click_method.ftl", params));
        ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
    }

    private void renderDadaValue(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> echartsParams) throws LcdpException {
        String defaultValue = "{\nitemName: [],\nitemValue: [],\nindicatorData: [],\n}";
        ComponentData optionData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION_DATA.getType(), Collections.singletonList("data"), (String)defaultValue);
        lcdpComponent.addAttr(":optionData", optionData.getRenderValue());
        echartsParams.put("optionData", CodePrefix._SELF.getType() + optionData.getRenderValue());
        String curPropsData = lcdpComponent.getInstanceKey() + "PropsData";
        echartsParams.put("curPropsData", CodePrefix._SELF.getType() + curPropsData);
        boolean isDefaultValue = false;
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            echartsParams.put("isQuoteOrGetValue", "true");
        } else if (!ctx.getDatas().containsKey(lcdpComponent.getInstanceKey() + CodeSuffix._OPTION_DATA.getType() + ":" + defaultValue)) {
            isDefaultValue = true;
        }
        echartsParams.put("isDefaultValue", isDefaultValue);
    }
}

