/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HDoughnutVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        lcdpComponent.registerTemplatePath("/template/elementui/element/hDoughnut/h-doughnut_echarts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMounted(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        lcdpComponent.addAttr(":themeName", "'" + lcdpComponent.getStyleSchemeClassName() + "'");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMounted(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        HashMap<String, String> instanceKey = new HashMap<String, String>();
        instanceKey.put("instanceKey", lcdpComponent.getInstanceKey());
        if (lcdpComponent.isVerticalFill() || lcdpComponent.isHorizontalFill()) {
            ctx.addMounted(RenderUtil.renderTemplate((String)"/template/elementui/element/eChartsResize/echarts_resize.ftl", instanceKey));
        }
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String instanceKey = lcdpComponent.getInstanceKey();
        Integer height = lcdpComponent.getHeight();
        Integer width = lcdpComponent.getWidth();
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderTop"))) {
            String borderTop = String.valueOf(lcdpComponent.getStyles().get("borderTop"));
            ctx.addData(instanceKey + "BorderTop: " + borderTop.substring(0, borderTop.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderBottom"))) {
            String borderBottom = String.valueOf(lcdpComponent.getStyles().get("borderBottom"));
            ctx.addData(instanceKey + "BorderBottom: " + borderBottom.substring(0, borderBottom.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderLeft"))) {
            String borderLeft = String.valueOf(lcdpComponent.getStyles().get("borderLeft"));
            ctx.addData(instanceKey + "BorderLeft: " + borderLeft.substring(0, borderLeft.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderRight"))) {
            String borderRight = String.valueOf(lcdpComponent.getStyles().get("borderRight"));
            ctx.addData(instanceKey + "BorderRight: " + borderRight.substring(0, borderRight.indexOf("px")));
        }
        ctx.addData(instanceKey + "Height: " + height);
        ctx.addData(instanceKey + "Width: " + width);
        ctx.addData(instanceKey + "Data: null");
        ctx.addData(instanceKey + "QueryData: {name: '',value: '',}");
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, Object> echartsParams = new HashMap<String, Object>();
        echartsParams.put("instanceKey", lcdpComponent.getInstanceKey());
        this.renderDadaValue(lcdpComponent, ctx, echartsParams);
        HashMap renderParams = new HashMap();
        ctx.addData(lcdpComponent.getInstanceKey() + "Props: " + JSONObject.toJSONString((Object)lcdpComponent.getProps()));
        lcdpComponent.addAttr(":props", lcdpComponent.getInstanceKey() + "Props");
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
            Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
            String valueField = "";
            String legendField = "";
            if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                        List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                        if (ToolUtil.isNotEmpty((Object)dataItemPath) && "value".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                            valueField = dataSFieldAnalysis.getFieldName();
                        }
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"legend".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                        legendField = dataSFieldAnalysis.getFieldName();
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)legendField) && ToolUtil.isNotEmpty((Object)valueField)) {
                DataSortConditionAnalysis dataSortConditionAnalysis;
                String querySelectionName;
                List conditionList;
                String operationName = "hussarQuery";
                String dataSelectId = lcdpComponent.getInstanceKey();
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = dataSModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getImportPath(dataModelId);
                }
                if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                    echartsParams.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                    echartsParams.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                }
                if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                    operationName = operationName + querySelectionName;
                }
                if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition()))) {
                    String sortConditionName = dataSortConditionAnalysis.getSortCondition();
                    if (ToolUtil.isNotEmpty((Object)sortConditionName)) {
                        operationName = operationName + sortConditionName;
                    }
                    echartsParams.put("dbdHaveMethod", DataModelUtil.judgeDataModelHasOperation((String)dataModelId, (String)operationName));
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                echartsParams.put("importName", apiFileName);
                echartsParams.put("importMethod", operationName);
                echartsParams.put("xAxisCols", legendField);
                echartsParams.put("seriesCols", valueField);
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("n");
        ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"/template/elementui/element/hDoughnut/h-doughnut_echarts_success.ftl", echartsParams));
        ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
    }

    private void renderDadaValue(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> echartsParams) throws LcdpException {
        String defaultValue = "{\nseriesResult: [],\nlegendData: [],\n}";
        ComponentData optionData = RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION_DATA.getType(), Collections.singletonList("data"), (String)defaultValue);
        lcdpComponent.addAttr(":optionData", optionData.getRenderValue());
        echartsParams.put("optionData", CodePrefix._SELF.getType() + optionData.getRenderValue());
        boolean isDefaultValue = false;
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            echartsParams.put("isQuoteOrGetValue", "true");
        } else if (!ctx.getDatas().containsKey(lcdpComponent.getInstanceKey() + CodeSuffix._OPTION_DATA.getType() + ":" + defaultValue)) {
            isDefaultValue = true;
        }
        echartsParams.put("isDefaultValue", isDefaultValue);
    }
}

