/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.spacedigital.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectPersonTableVoidVisitor
implements VoidVisitor {
    protected static final Logger logger = LoggerFactory.getLogger(SelectPersonTableVoidVisitor.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/spacedigital/element/SelectPersonTable/table.ftl");
        Map dataParams = lcdpComponent.getRenderParamsToBind();
        this.renderTableCol(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx, dataParams);
        this.renderMethod(lcdpComponent, ctx, dataParams);
        this.renderAttrs(lcdpComponent, ctx);
        this.renderEvent(lcdpComponent, ctx);
    }

    private void renderTableCol(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3\u8868\u683c\u5217\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u8868\u683c\u5217\u53c2\u6570\uff1aopt_cols------");
        }
        JSONArray optColsJSONArray = (JSONArray)lcdpComponent.getProps().get("opt_cols");
        lcdpComponent.addRenderParam("tableShowFields", (Object)optColsJSONArray);
        JSONArray allColumns = this.getAllColumns(optColsJSONArray);
        for (int i = 0; i < allColumns.size(); ++i) {
            String field;
            HashMap<String, String> params = new HashMap<String, String>();
            if (!ToolUtil.isNotEmpty((Object)allColumns.get(i)) || !ToolUtil.isNotEmpty((Object)(field = String.valueOf(((JSONObject)allColumns.get(i)).get((Object)"field"))))) continue;
            params.put("field", field);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3\u8868\u683c\u5217\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
    }

    private JSONArray getAllColumns(JSONArray cols) {
        JSONArray allColumns = new JSONArray();
        for (Object col : cols) {
            JSONObject colObj = (JSONObject)col;
            allColumns.add((Object)colObj);
        }
        return allColumns;
    }

    public void renderData(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException {
        this.renderTableData(lcdpComponent, ctx);
        this.renderSelectData(lcdpComponent, ctx);
        String dataArrayStr = RenderUtil.renderTemplate((String)"/template/spacedigital/element/SelectPersonTable/table_data.ftl", dataParams);
        ctx.addDataCommon(dataArrayStr);
        ctx.addDataCommon(lcdpComponent.getInstanceKey() + "TemAllData: []");
        ctx.addDataCommon(lcdpComponent.getInstanceKey() + "AssignTableData: []");
    }

    private void renderTableData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)"[]");
        lcdpComponent.addAttr(CodePrefix._DATA.getType(), valueData);
    }

    private void renderSelectData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        ArrayList<String> selectItems = new ArrayList<String>();
        selectItems.add("data");
        RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._TABLE_DATA_CHECKED.getType(), selectItems, (String)"[]");
    }

    public void renderMethod(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        JSONArray optColsJSONArray = (JSONArray)lcdpComponent.getProps().get("opt_cols");
        List cols = JSON.parseArray((String)optColsJSONArray.toJSONString(), TableOptColsAnalysis.class);
        params.put("idField", ((TableOptColsAnalysis)cols.get(0)).getField());
        ArrayList<String> selectRow = new ArrayList<String>();
        selectRow.add("data");
        ctx.addMethod(lcdpComponent.getInstanceKey() + "SelectRow", selectRow, RenderUtil.renderTemplate((String)"/template/spacedigital/element/SelectPersonTable/select_method.ftl", params));
        ArrayList<String> rowClickDatas = new ArrayList<String>();
        rowClickDatas.add("row");
        rowClickDatas.add("colum");
        rowClickDatas.add("event");
        ctx.addMethod(lcdpComponent.getInstanceKey() + "RowClick", rowClickDatas, RenderUtil.renderTemplate((String)"/template/spacedigital/element/SelectPersonTable/row_clickMethod.ftl", params));
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealDisabledAttr(lcdpComponent, ctx);
        dealFormDataVisitor.dealReadonlyAttr(lcdpComponent, ctx);
        Map props = lcdpComponent.getProps();
        Boolean hiddenValue = props.get("hidden") != null ? props.get("hidden") : Boolean.valueOf(false);
        ctx.addDataCommon(lcdpComponent.getInstanceKey() + "Hidden: " + hiddenValue);
    }

    private void renderEvent(LcdpComponent lcdpComponent, Ctx ctx) {
        List triggers;
        List eventConfigs = lcdpComponent.getEvents();
        if (ToolUtil.isNotEmpty((Object)eventConfigs)) {
            for (EventConfig eventConfig : eventConfigs) {
                if (!"notCheck".equals(eventConfig.getTrigger())) continue;
                lcdpComponent.addRenderParam("notCheck", (Object)true);
            }
        }
        if (ToolUtil.isNotEmpty((Object)(triggers = lcdpComponent.getTrigger()))) {
            triggers.clear();
        }
    }
}

