/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.elementui.visitor.provide;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.speedcode.common.analysismodel.dataset.MethodConfigAnalysis;
import com.jxdinfo.hussar.speedcode.common.constant.CodePrefix;
import com.jxdinfo.hussar.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.constant.dataset.DataSetObjectTypeEnum;
import com.jxdinfo.hussar.speedcode.datasource.model.meta.DataModelFieldBase;
import com.jxdinfo.hussar.speedcode.datasource.model.meta.dataset.DataSet;
import com.jxdinfo.hussar.speedcode.datasource.model.meta.dataset.ValueObjectProperty;
import com.jxdinfo.hussar.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDElDataBaseComponent.value")
@Scope(value="prototype")
public class DataBaseComponentValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public String setValue(List<String> dataItems) throws LcdpException {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (this.params != null && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData insData = new ComponentData();
        insData.setRenderValue(CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType());
        DataSet returnDataSet = this.getReturnDataSet();
        if (null != returnDataSet) {
            insData.setDataType(returnDataSet.getDataType());
            if (dataItems.size() > 1 && null != returnDataSet.getDataSetObject()) {
                ComponentData data = new ComponentData(insData.getDataType(), insData.getDataItemSource(), insData.getRenderValue());
                return this.getChildData(dataItems, 1, data, returnDataSet.getDataSetObject().getObjectType(), returnDataSet.getDataSetObject().getProperties(), returnDataSet.getModelProperties());
            }
        }
        return insData;
    }

    private ComponentData getChildData(List<String> dataitems, int size, ComponentData data, String objectType, List<ValueObjectProperty> properties, List<DataModelFieldBase> modelFields) {
        if (data.getDataItemSource().equals((Object)ComponentData.DataItemSourceEnum.READONLY)) {
            return data;
        }
        ValueObjectProperty property = this.getValueProperty(objectType, properties, modelFields, dataitems.get(size));
        if (null != property) {
            if (ComponentData.DataTypeEnum.OBJECT.equals((Object)data.getDataType())) {
                data.setDataType(property.getDataType());
                data.setRenderValue(data.getRenderValue() + CodeSuffix._POINT.getType() + property.getName());
            } else if (ComponentData.DataTypeEnum.ARRAY_OBJECT.equals((Object)data.getDataType()) || ComponentData.DataTypeEnum.TREE_OBJECT.equals((Object)data.getDataType())) {
                data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
                data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                data.setRenderValue("function(){\nlet result = [];\nif(" + data.getRenderValue().replace(".", "?.") + "){" + data.getRenderValue() + ".forEach((item) => result.push(item." + property.getName() + "))}return result;}()");
            } else {
                return ComponentData.EMPTY_DATA;
            }
            if (size == dataitems.size() - 1) {
                return data;
            }
        } else {
            return ComponentData.EMPTY_DATA;
        }
        this.getChildData(dataitems, size + 1, data, property.getObjectType(), property.getProperties(), modelFields);
        return data;
    }

    private ValueObjectProperty getValueProperty(String objectType, List<ValueObjectProperty> properties, List<DataModelFieldBase> dataModelFieldBases, String dataItem) {
        block4: {
            block3: {
                if (!DataSetObjectTypeEnum.DATA_MODEL.getValue().equals(objectType)) break block3;
                if (!ToolUtil.isNotEmpty(dataModelFieldBases)) break block4;
                for (DataModelFieldBase fieldBase : dataModelFieldBases) {
                    if (!dataItem.equals(fieldBase.getName())) continue;
                    return ValueObjectProperty.of((DataModelFieldBase)fieldBase);
                }
                break block4;
            }
            if (ToolUtil.isNotEmpty(properties)) {
                for (ValueObjectProperty valueObjectProperty : properties) {
                    if (!dataItem.equals(valueObjectProperty.getName())) continue;
                    return valueObjectProperty;
                }
            }
        }
        return null;
    }

    private DataSet getReturnDataSet() {
        try {
            JSONObject methodObj = JSON.parseObject((String)JSON.toJSONString((Object)this.lcdpComponent.getDatas()));
            if (ToolUtil.isNotEmpty((Object)methodObj) && ToolUtil.isNotEmpty((Object)methodObj.get((Object)"datamodel"))) {
                MethodConfigAnalysis methodConfigAnalysis = (MethodConfigAnalysis)JSON.parseObject((String)methodObj.get((Object)"datamodel").toString(), MethodConfigAnalysis.class);
                return DataModelUtil.getDataSetById((String)methodConfigAnalysis.getDataModelId(), (String)methodConfigAnalysis.getReturnDataSet());
            }
        }
        catch (LcdpException | IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getDefaultValue() {
        return "{}";
    }

    public Map<String, String> getComponentColMapping() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("col", "none");
        return map;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return null;
    }

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }
}

