<#if tableInstanceKey?? && tableInstanceKey != "">
    let file = event.currentTarget.files[0];
    const types = file.name.split(".")[1];
    const fileType = ["xlsx", "xlc", "xlm", "xls", "xlt"].some(
        item => item === types
    );
    if (!fileType) {
        HussarRouter.showMsg(self, "文件格式错误，请重新选择！", 'error',<#if strategy??>true<#else>false</#if>);
        return;
    }
    const Excel = require("exceljs");
    let fileReader = new FileReader();
    let dicts = [];
    let relates = [];
    <#if showConfigItemInfos??>
        <#list showConfigItemInfos! as item>
            <#if item.isConfigComplete && item.commonModelType?? >
                let dict${item_index} = [];
                let relate${item_index} = [];
                <#if !item.dictType?? || item.dictType == "">
                    let ${item.importName!}Obj${item_index} = {};
                <#else>
                    let ${item.importName!}Obj${item_index} = {
                    typeName: '${item.dictType}',
                    };
                </#if>
                const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                HussarRouter.showMsg(self, "数据请求异常", 'error',<#if strategy??>true<#else>false</#if>);
                });
                const data${item_index} = res${item_index}.data;
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                // 数据展示字典表
                if (data${item_index} && data${item_index}.length > 0) {
                for (let i = 0; i < data${item_index}.length; i++) {
                dict${item_index}.push({
                field: '${item.tableFieldWhere!}',
                value: data${item_index}[i].value,
                label: data${item_index}[i].label
                });
                }
                relate${item_index}.push({
                tableFieldWhere: '${item.tableFieldWhere!}',
                field: '${item.tableFieldWhere!}'
                });
                }
                } else {
                HussarRouter.showMsg(self, "数据展示数据请求失败", 'error',<#if strategy??>true<#else>false</#if>);
                }
                dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
                relates.push(relate${item_index});
            <#elseif item.isConfigComplete>
                let dict${item_index} = [];
                let relate${item_index} = [];
                let ${item.importName!}Obj${item_index} = {
                inValues: '',
                ${item.queryObjectAttr!}
                };
                const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                HussarRouter.showMsg(self, "数据请求异常", 'error',<#if strategy??>true<#else>false</#if>);
                });
                const data${item_index} = res${item_index}.data;
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                // 数据展示数据模型
                if (data${item_index}.data && data${item_index}.data.length > 0) {
                for (let i = 0; i < data${item_index}.data.length; i++) {
                <#list item.mappingRelates! as mapping>
                    dict${item_index}.push({
                    field: '${item.tableFieldWhere!}',
                    value: data${item_index}.data[i].${item.relateTableFieldWhere!},
                    label: data${item_index}.data[i].${mapping.relateField!}
                    });
                </#list>
                }
                <#list item.mappingRelates! as mapping>
                    relate${item_index}.push({
                    tableFieldWhere: '${item.tableFieldWhere!}',
                    field: '${mapping.field!}'
                    });
                </#list>
                }
                } else {
                HussarRouter.showMsg(self, "数据展示数据请求失败", 'error',<#if strategy??>true<#else>false</#if>);
                }
                dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
                relates.push(relate${item_index});
            </#if>
        </#list>
    </#if>
    fileReader.onload = function (ev) {
        const data = ev.target.result;
        const workbook = new Excel.Workbook();
        workbook.xlsx.load(data)
            .then(function() {
                let values = [
                <#list tableShowFields! as item>
                    <#if (item_index != (tableShowFields?size-1))>
                        "${item.title}",
                    <#else>
                        "${item.title}"
                    </#if>
                </#list>
                ];
                let prop = [
                <#list tableShowFields! as item>
                    <#if (item_index != (tableShowFields?size-1))>
                        "${item.field}",
                    <#else>
                        "${item.field}"
                    </#if>
                </#list>
                ];
                <#if showConfigItemInfos??>
                    for (let i = 0; i < relates.length; i++) {
                        if (relates[i][0]) {
                            let tableFieldWhere = relates[i][0].tableFieldWhere;
                            prop.splice(prop.findIndex(function (item) {
                                return item === relates[i][0].field
                            }), 1, tableFieldWhere);
                        } else {
                           HussarRouter.showMsg(self, "数据展示数据请求失败", 'error',<#if strategy??>true<#else>false</#if>);
                        }
                    }
                </#if>
                function cellValueToDict(keys, row) {
                    let data = {};
                    row.eachCell(function(cell, colNumber) {
                        let value = cell.value;
                        if(cell.type == (Excel.ValueType.Date)) {
                            value = new Date(value.valueOf() - 8 * 60 * 60 * 1000);
                        }
                        if (dicts.length != 0) {
                            let findIndex = dicts.findIndex(function(dictItem) {
                                return  dictItem.field == prop[colNumber - 1];
                            });
                            if (findIndex != -1) {
                                value = dicts.find(function(dictItem){
                                    return  dictItem.field == prop[colNumber - 1];
                                }).dict.find(function(dictItem) {
                                    return value == dictItem.label && dictItem.field == prop[colNumber - 1];
                                }) != undefined ? dicts.find(function(dictItem) {
                                    return  dictItem.field == prop[colNumber - 1];
                                }).dict.find(function(dictItem) {
                                    return value == dictItem.label && dictItem.field == prop[colNumber - 1];
                                }).value : value;
                            }
                        }
                        data[prop[colNumber - 1]] = value;
                    });
                    return data;
                }
                let dataArray = [];
                let keys = [];
                const worksheet = workbook.worksheets[0]; //获取第一个worksheet
                worksheet.eachRow(function(row, rowNumber) {
                    if (rowNumber == ${maxLevel!}) {
                        keys = row.values;
                    }
                    else if (rowNumber > ${maxLevel!}) {
                        let rowDict = cellValueToDict(keys, row);
                        dataArray.push(rowDict);
                    }
                });
                let valuesCopy = values.slice(0);
                let keysCopy = keys.filter(function(el) {
                    return el;
                }).slice(0);
                if (JSON.stringify(keysCopy.sort()) != JSON.stringify(valuesCopy.sort())) {
                    HussarRouter.showMsg(self, "导入模板错误，请重新选择！", 'error',<#if strategy??>true<#else>false</#if>);
                    return;
                }
        <#if unReferences?? && unReferences!>
            <#if importName?? && importName != "">
            ${importName!}['${importMethod!}']({
                    importList: JSON.stringify(dataArray)
                }).then(res => {
                    if(res) {
                        HussarRouter.showMsg(self, "导入成功", 'success',<#if strategy??>true<#else>false</#if>);
                self.${tableInstanceKey}TableLoad();
                        ${callbackCode!}
                    } else {
                       HussarRouter.showMsg(self, "导入失败", 'error',<#if strategy??>true<#else>false</#if>);
                }
                }
                ).catch(function () {
                    HussarRouter.showMsg(self, "数据请求异常", 'error',<#if strategy??>true<#else>false</#if>);
                })
            <#else>
                ${callbackCodeWithoutData!}
            </#if>
        <#else>
            ${dataName!} = ${dataName!}.concat(dataArray);
            HussarRouter.showMsg(self, "导入成功", 'success',<#if strategy??>true<#else>false</#if>);
        </#if>
            });
    }
    fileReader.readAsBinaryString(file);
</#if>