<#--定义列递归宏-->
<#macro editTree list>
    <#list list! as item>
        <#if (item.isParent?? && item.isParent!)>
            <vxe-table-colgroup align="${item.bodyAlign!}"
                              header-align="${item.align!}"
                              title="${item.label!}"
                    <#if item.width??>width="${item.width!}"</#if>
            >
                <@editTree list = item.children></@editTree>
            </vxe-table-colgroup>
        <#else>
            <#if item.rowSummary?? && item.rowSummary>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  <#if item.width??>
                                      <#if item.isMinWidth?? && item.isMinWidth!>
                                          :min-width = "${item.width!}"
                                      <#else>
                                          width="${item.width!}"
                                      </#if>
                                  <#else>
                                      <#if item.label?? && item.label?length gt 0>:min-width="${item.label?length * 14 + 40}"</#if>
                                  </#if>
                                  title="${item.label!}"
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        >
                <#if item.rowCalculate??>
                <template v-slot="{ row }">
                    <span class="vxe-cell--label">{{$numeral(${item.rowCalculate.editFormulaReplace!}).format('${item.rowCalculate.format!}')}}</span>
                </template>
                </#if>
                </vxe-table-column>
            <#elseif item.isShowConfig?? && item.isShowConfig!>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  <#if item.width??>
                                      <#if item.isMinWidth?? && item.isMinWidth!>
                                          :min-width = "${item.width!}"
                                      <#else>
                                          width="${item.width!}"
                                      </#if>
                                  <#else>
                                      <#if item.label?? && item.label?length gt 0>:min-width="${item.label?length * 14 + 40}"</#if>
                                  </#if>
                                  title="${item.label!}"
                                  <#if item.width??>width="${item.width!}"</#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        >
                <template v-slot="{ row }">
                    <span class="vxe-cell--label">{{row.${item.prop!}}}</span>
                </template>
                </vxe-table-column>
            <#else>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  title="${item.label!}"
                                  <#if item.width??>
                                      <#if item.isMinWidth?? && item.isMinWidth!>
                                          :min-width = "${item.width!}"
                                      <#else>
                                          width="${item.width!}"
                                      </#if>
                                  <#else>
                                      <#if item.label?? && item.label?length gt 0>:min-width="${item.label?length * 14 + 40}"</#if>
                                  </#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#--可编辑列-->
                        <#if item.colEditComponent! != '' && item.colEditComponent! !='empty'>
                            :edit-render="{
                                immediate: true,
                                <#--输入框-->
                                <#if item.colEditComponent! == 'input' || item.colEditComponent! == 'dialog'>
                                name: 'input',
                                attrs: {type: 'text'},
                                <#--数字框-->
                                <#elseif item.colEditComponent! == 'number'>
                                name: '$input',
                                props: {type: 'number'},
                                <#--日期-->
                                <#elseif item.colEditComponent! == 'date'>
                                name: '$input',
                                props:{type:'<#if item.selectFormat??>${item.selectFormat.dateFmtSelect!}</#if>'},
                                <#--下拉框-->
                                <#elseif item.colEditComponent! == 'select'>
                                name: '$select',
                                props: {type: 'select'},
                                options: ${instanceKey!}${item.prop!?cap_first}Options,
                                <#else >
                                </#if>
                                events: {
                                <#--合计行触发事件-->
                                <#if columnSummary?? && columnSummary>
                                input: ${instanceKey!}UpdateFooterEvent,
                                </#if>
                                <#--数据展示替换-->
                                <#if item.showConfig?? && item.showConfig>
                                change: ${instanceKey!}ReplaceData,
                                </#if>
                                <#--列弹框展示-->
                                <#if item.colEditComponent! == 'dialog'>
                                focus: ${instanceKey!}${item.prop?cap_first}EditEvent,
                                </#if>
                                }
                              }"
                        </#if>>
                        <#if item.colComponent! == 'date'>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.${item.prop!}) ? $moment(row.${item.prop!}).format('<#if item.selectType??>${item.selectType.dateFmtSelect!}</#if>') : '--'}}</span>
                        </template>
                        <#elseif item.colComponent! == 'number'>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.${item.prop!}) ? $numeral(row.${item.prop!}).format('<#if item.selectType??>${item.selectType.numberFmtSelect!}</#if>') : '--'}}</span>
                        </template>
                        <#else>
                        </#if>
                </vxe-table-column>
            </#if>
        </#if>
    </#list>
</#macro>
<div ref="${instanceKey!}Ref">
    <vxe-table
        show-overflow
        keep-source
        <#--列表loading-->
        :loading="${instanceKey!}TableLoading"
        <#--列表边框-->
        <#if borderStyle??>
            :border="${instanceKey!}BorderStyle"
        </#if>
        <#if editRulesFlag?? && editRulesFlag>
            :edit-rules="${instanceKey!}EditRules"
        </#if>
        <#--表格高度（分页）-->
        <#if isPagination?? && isPagination>
            <#if tableHeight??>
                height="${tableHeight!}"
            </#if>
        <#else >:height="'100%'"
        </#if>
        <#if cellClick?? && cellClick>
            @cell-click="${instanceKey!}CellClickInfo"
        </#if>
        ref="${instanceKey!}TableRef"
        <#--单击触发可编辑-->
        :edit-config="{trigger: 'click', mode: 'cell'<#if isDisabled??>, activeMethod: ${instanceKey!}ActiveRowMethod</#if>}"
        <#--合计行方法-->
        <#if columnSummary?? && columnSummary>
            show-footer
            :footer-method="${instanceKey!}ColumnSummaryEvent"
        </#if>
        <#--选择项变化-->
        <#if showSelection?? && showSelection>
        <#if isRadio?? && isRadio!>
            @radio-change="${instanceKey!}SelectRow"
        <#else>
            @checkbox-change="${instanceKey!}SelectRow"
            @checkbox-all="${instanceKey!}SelectAll"
        </#if>
        </#if>
        <#if columnStyle?? && columnStyle>
            :cell-style="${instanceKey!}CellStyle"
        </#if>
        <#if isRadio?? && isRadio!>
            :radio-config="{ checkMethod: ${instanceKey!}Selectable }"
        <#else>
            :checkbox-config="{ <#if crossPageSelect?? && crossPageSelect!>reserve: true, </#if>checkMethod: ${instanceKey!}Selectable, strict: ${instanceKey!}Disabled }"
        </#if>
        <#if crossPageSelect?? && crossPageSelect!>
            row-id="${rowId!"id"}"
        </#if>
        auto-resize
        <#if isSortChange?? && isSortChange>
                @sort-change="${instanceKey!}SortChange"
                :sort-config="{remote: true}"
        </#if>
    >
        <#--列表选择框-->
        <#if showSelection?? && showSelection>
            <vxe-table-column align="center" type="<#if isRadio?? && isRadio!>radio<#else>checkbox</#if>" width="<#if checkWidth??>${checkWidth!}<#else>60</#if>"></vxe-table-column>
        </#if>
        <#--列表序号列-->
        <#if showIndex?? && showIndex>
            <vxe-table-column align="center" title="序号" type="seq" width="<#if indexWidth??>${indexWidth!}<#else>60</#if>"></vxe-table-column>
        </#if>
        <#--列表列-->
        <@editTree list= tableShowFields!></@editTree>
    </vxe-table>
    <#if isPagination?? && isPagination>
        <div class="page" v-show="!${instanceKey!}PageHidden">
            <el-pagination
                    background
                    @size-change="${instanceKey!}HandleSizeChange"
                    @current-change="${instanceKey!}HandleCurrentChange"
                    :page-size="${ListQuery!}.size"
                    <#if size?? && size! lt 10>
                        :page-sizes="[${size?c!}, 10, 20, 50]"
                    <#elseif size?? && size! gt 10 && size! lt 20>
                        :page-sizes="[10, ${size?c!}, 20, 50]"
                    <#elseif size?? && size! gt 20 && size! lt 50>
                        :page-sizes="[10, 20, ${size?c!}, 50]"
                    <#elseif size?? && size! gt 50>
                        :page-sizes="[10, 20, 50, ${size?c!}]"
                    </#if>
                    <#if (layout??)>
                        :layout="${instanceKey!}Layout"
                    </#if>
                    :total="${TableTotal!}"
                    :current-page.sync="${instanceKey!}CurrentPage">
            </el-pagination>
        </div>
    </#if>
<#if hasSortTableOverall??>
    ${hasSortTableOverall!}
</#if>
</div>