const resultSeries = [];
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
const xPaddingTop = parseInt('${xPaddingTop!}', 10);
const xPaddingRight = parseInt('${xPaddingRight!}', 10);
const xPaddingBottom = parseInt('${xPaddingBottom!}', 10);
const xPaddingLeft = parseInt('${xPaddingLeft!}', 10);
const yPaddingTop = parseInt('${yPaddingTop!}', 10);
const yPaddingRight = parseInt('${yPaddingRight!}', 10);
const yPaddingBottom = parseInt('${yPaddingBottom!}', 10);
const yPaddingLeft = parseInt('${yPaddingLeft!}', 10);
let newTitle = '';
if (oldTitle) {
    const titleLength = oldTitle.length;
    const provideLength = numberOfRow;
    const rowNumber = Math.ceil(titleLength / provideLength);
    if (titleLength > provideLength) {
        for (let i = 0; i < rowNumber; i++) {
            let tempStr = ' ';
            const start = i * provideLength;
            const end = start + provideLength;
            if (i === rowNumber - 1) {
                tempStr = oldTitle.substring(start, titleLength);
            } else {
                tempStr = oldTitle.substring(start, end) + '\n';
            }
            newTitle += tempStr;
        }
    } else {
        newTitle = oldTitle;
    }
}
const echatrsTitle = {
    text: newTitle,
    textStyle: {
        color: '${titleColor!}',
        fontSize: '${titleFontSize!}',
        fontFamily: '${fontFamily!}',
        fontWeight: '${fontWeight!}',
        fontStyle: '${fontStyle!}',
    },
    left: '${titleAlign!}',
    top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
};
const echatrsTooltip = {
    trigger: 'axis',
    backgroundColor: '${tooltipBgColor!}',
    textStyle: {
        color: '${toolColor!}',
        fontSize: '${toolFontSize!}',
        fontFamily: '${toolFontFamily!}',
        fontWeight: '${toolFontWeight!}',
        fontStyle: '${toolFontStyle!}',
    },
};
<#--网格-->
const grid = {
    left: '${gridLeft!}',
    top: '${gridTop!}',
    right: '${gridRight!}',
    bottom: '${gridBottom!}',
    containLabel: ${containLabel?string!},
};
const textStyle = {
    color: '${legendColor!}',
    fontSize: '${legendFontSize!}',
    fontFamily: '${legendFontFamily!}',
    fontWeight: '${legendFontWeight!}',
    fontStyle: '${legendFontStyle!}',
};
const nameTextStyle = {
    color: '${xyColor!}',
    fontSize: '${xyFontSize!}',
    fontFamily: '${xyFontFamily!}',
    fontWeight: '${xyFontWeight!}',
    fontStyle: '${xyFontStyle!}',
    padding: [xPaddingTop, xPaddingRight, xPaddingBottom, xPaddingLeft],
};
const axisLine = {
    show: true,
    type: 'solid',
    lineStyle: {
        width: '${lineWidth!}',
        color: '${lineColor!}',
    },
};
const axisLabel = {
    show: true,
    color: '${xyColor!}',
    fontSize: '${xyFontSize!}',
    fontFamily: '${xyFontFamily!}',
    fontWeight: '${xyFontWeight!}',
    fontStyle: '${xyFontStyle!}',
};
const axisTick ={
    length:'${xyAxisTickLength!}',
};
const yAxis = {
    type: 'value',
    name: '${yAxisName!}',
    nameGap: '${yNameGap!}',
    nameLocation: '${nameLocation}',
    nameTextStyle: {
        color: '${xyColor!}',
        fontSize: '${xyFontSize!}',
        fontFamily: '${xyFontFamily!}',
        fontWeight: '${xyFontWeight!}',
        fontStyle: '${xyFontStyle!}',
        padding: [yPaddingTop, yPaddingRight, yPaddingBottom, yPaddingLeft],
    },
    axisLine: {
        show: true,
        type: 'solid',
        lineStyle: {
            width: '${lineWidth!}',
            color: '${lineColor!}',
        },
    },
    axisLabel: {
        show: true,
        color: '${xyColor!}',
        fontSize: '${xyFontSize!}',
        fontFamily: '${xyFontFamily!}',
        fontWeight: '${xyFontWeight!}',
        fontStyle: '${xyFontStyle!}',
    },
    axisTick: {
        length:'${xyAxisTickLength!}',
    },
};
const topicColorStr = ${topicColorStr!};
<#--series样式设置-->
const seriesItemStyle = {
    normal: {
        barBorderRadius: ${barRadius!},
    },
};
${optionData!}.legendData.forEach((legend, index) => {
    resultSeries.push({
        name: legend,
        itemStyle: seriesItemStyle,
        barWidth: ${barWidth!},
    <#if barGap?? && '${barGap}' != ''>
        barGap: '${barGap}',
    </#if>
        data: ${optionData!}.yAxisData[index] || [],
        type: 'bar'
    });
});
return {
    color: topicColorStr,
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    grid: grid,
    legend: {
  <#if (isShowFlag?? && isShowFlag)>
    show: true,
  <#elseif (!isShowFlag?? || !isShowFlag)>
    show: false,
  </#if>
        itemGap: 20,
        itemWidth: 15,
        itemHeight: 15,
        left: '${legendLocation!}',
        textStyle: textStyle,
        data: ${optionData!}.legendData || []
    },
    xAxis: {
        type: 'category',
        name: '${xAxisName!}',
        nameGap: '${xNameGap!}',
        nameLocation: '${nameLocation!}',
        nameTextStyle: nameTextStyle,
        axisLine: axisLine,
        axisLabel: axisLabel,
        axisTick:axisTick,
        data: ${optionData!}.xAxisData || []
    },
    yAxis: yAxis,
    series: resultSeries
};
