/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.elementui.visitor.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.speedcode.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.speedcode.common.constant.CodePrefix;
import com.jxdinfo.hussar.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.speedcode.common.utils.TableFieldUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDElEditTable.value")
@Scope(value="prototype")
public class EditTableValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        JSONObject sumRow;
        Boolean sumRowExist;
        JSONArray colsJson = (JSONArray)this.lcdpComponent.getProps().get("opt_cols");
        JSONArray hiddenJson = (JSONArray)this.lcdpComponent.getProps().get("hidden_cols");
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (ToolUtil.isNotEmpty((Object)colsJson)) {
            List colsList = colsJson.toJavaList(TableOptColsAnalysis.class);
            colsList.forEach(col -> {
                if (!col.getRowSummary()) {
                    map.put(col.getId(), col.getField());
                }
            });
        }
        if (ToolUtil.isNotEmpty((Object)hiddenJson)) {
            List hiddenColsList = hiddenJson.toJavaList(TableOptColsAnalysis.class);
            hiddenColsList.forEach(col -> map.put(col.getId(), col.getField()));
        }
        if (null != (sumRowExist = (Boolean)this.lcdpComponent.getProps().get("columnSummary")) && sumRowExist.booleanValue() && null != (sumRow = (JSONObject)this.lcdpComponent.getProps().get("columnCalculate")) && ToolUtil.isNotEmpty((Object)sumRow.get((Object)"columnFields"))) {
            JSONArray columnFields = sumRow.getJSONArray("columnFields");
            for (int i = 0; i < columnFields.size(); ++i) {
                map.put(columnFields.getString(i), columnFields.getString(i));
            }
        }
        map.put("page", "page");
        map.put("pageSize", "pageSize");
        map.put("total", "total");
        return map;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getDefaultValue() {
        return "[]";
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem;
            switch (dataItem = dataItems.get(0)) {
                case "summary": {
                    this.getSummaryData(dataItems, data);
                    break;
                }
                case "pagination": {
                    this.getPageData(dataItems, data);
                    break;
                }
                case "total": {
                    data.setDataType(ComponentData.DataTypeEnum.INTEGER);
                    data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TABLE_TOTAL.getType(), dataItems));
                    break;
                }
                case "curRowData": {
                    this.getCurRowDataData(dataItems, data);
                    break;
                }
                case "data": 
                case "value": {
                    this.getSelectAndTableData(dataItems, data, dataItem);
                    break;
                }
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            ArrayList<String> currDataItem = new ArrayList<String>();
            currDataItem.add("value");
            data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), currDataItem));
        }
        return data;
    }

    private void getSelectAndTableData(List<String> dataItems, ComponentData data, String dataItem) throws LcdpException {
        String dataValue;
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        ArrayList<String> currDataItem = new ArrayList<String>();
        if (dataItem.equals("data")) {
            currDataItem.add("data");
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TABLE_DATA_CHECKED.getType(), currDataItem);
        } else {
            currDataItem.add("value");
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), currDataItem);
        }
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("opt_cols");
            JSONArray hiddenCols = (JSONArray)this.lcdpComponent.getProps().get("hidden_cols");
            this.getOptColData(dataItems, data, dataValue, cols);
            this.getHiddenColData(dataItems, data, dataValue, hiddenCols);
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            data.setRenderValue(dataValue);
        }
    }

    private void getHiddenColData(List<String> dataItems, ComponentData data, String dataValue, JSONArray hiddenCols) {
        if (ToolUtil.isNotEmpty((Object)hiddenCols)) {
            List hiddenColsList = hiddenCols.toJavaList(TableOptColsAnalysis.class);
            for (TableOptColsAnalysis col : hiddenColsList) {
                if (!col.getId().equals(dataItems.get(1))) continue;
                data.setDataType(col.getDataType());
                data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => result.push(item." + col.getField() + "));return result;}()");
                break;
            }
        }
    }

    private void getOptColData(List<String> dataItems, ComponentData data, String dataValue, JSONArray cols) {
        if (ToolUtil.isNotEmpty((Object)cols)) {
            List colsList = cols.toJavaList(TableOptColsAnalysis.class);
            for (TableOptColsAnalysis col : colsList) {
                if (!col.getId().equals(dataItems.get(1))) continue;
                data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                if (col.getRowSummary() && ToolUtil.isNotEmpty((Object)col.getRowCalculate())) {
                    data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((row) => result.push(" + col.getRowCalculate().getEditFormulaReplace() + "));return result;}()");
                    break;
                }
                data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => result.push(item." + col.getField() + "));return result;}()");
                break;
            }
        }
    }

    private void getPageData(List<String> dataItems, ComponentData data) throws LcdpException {
        ArrayList<String> pageDataItem = new ArrayList<String>();
        pageDataItem.add("pagination");
        String pageValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TABLE_PAGE_DATA.getType(), pageDataItem);
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.INTEGER);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            if ("page".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".current");
            } else if ("pageSize".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".size");
            } else if ("total".equals(dataItems.get(1))) {
                data.setRenderValue(pageValue + ".TableTotal");
            }
        } else {
            data.setDataType(ComponentData.DataTypeEnum.OBJECT);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            data.setRenderValue(pageValue);
        }
    }

    private void getCurRowDataData(List<String> dataItems, ComponentData data) throws LcdpException {
        ArrayList<String> curRowDataItem = new ArrayList<String>();
        curRowDataItem.add("curRowData");
        String curRowValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._CUR_ROW_DATA.getType(), curRowDataItem);
        if (dataItems.size() == 2) {
            ArrayList<String> colTypeList = new ArrayList<String>();
            colTypeList.add("opt_cols");
            colTypeList.add("hidden_cols");
            String field = TableFieldUtil.getTableFieldById((String)dataItems.get(1), colTypeList, (LcdpComponent)this.lcdpComponent);
            data.setDataType(TableFieldUtil.getTableFieldTypeByField((String)field, colTypeList, (LcdpComponent)this.lcdpComponent));
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            data.setRenderValue(curRowValue + "." + field);
        } else {
            data.setDataType(ComponentData.DataTypeEnum.OBJECT);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
            data.setRenderValue(curRowValue);
        }
    }

    private void getSummaryData(List<String> dataItems, ComponentData data) {
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.DOUBLE);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            data.setRenderValue(CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + "ColumnFieldsAssignment." + dataItems.get(1).replace("sum(", "").replace(")", ""));
        } else {
            data.setDataType(ComponentData.DataTypeEnum.OBJECT);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            data.setRenderValue(CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + "ColumnFieldsAssignment");
        }
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return Collections.singletonList(new ComponentData(ComponentData.DataTypeEnum.ARRAY_OBJECT, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("value"))));
    }
}

