/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.elementui.visitor.provide;

import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.speedcode.common.constant.CodePrefix;
import com.jxdinfo.hussar.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.ComponentDataUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDElCheckBoxGroup.value")
@Scope(value="prototype")
public class CheckBoxGroupValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String setValue(List<String> dataItems) {
        return "this." + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType() + " = fromDataValue;";
    }

    public Map<String, String> getComponentColMapping() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String label = "name";
        String value = "value";
        String cusLabel = "cusLabel";
        String cusValue = "cusValue";
        if (ToolUtil.isNotEmpty(this.lcdpComponent.getProps().get(cusLabel))) {
            label = String.valueOf(this.lcdpComponent.getProps().get("cusLabel"));
        }
        if (ToolUtil.isNotEmpty(this.lcdpComponent.getProps().get(cusValue))) {
            value = String.valueOf(this.lcdpComponent.getProps().get("cusValue"));
        }
        map.put("label", label);
        map.put("value", value);
        return map;
    }

    public String getDefaultValue() {
        return "[]";
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem = dataItems.get(0);
            if ("data".equals(dataItem)) {
                if (dataItems.size() == 1) {
                    return this.getOptionData();
                }
                String dataItemData = dataItems.get(1);
                return this.getValueLabelData(dataItemData);
            }
            if ("label".equals(dataItem)) {
                data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
                String valueData = this.getValueData().getRenderValue();
                String optionData = CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + CodeSuffix._OPTION.getType();
                data.setRenderValue("function() {\n let result = [];\nfor(let i = 0,optionLen = " + optionData + ".length;i < optionLen;i++){\nfor(let j = 0,valueLen = " + valueData + ".length;j < valueLen;j++){\nif(" + optionData + "[i].value === " + valueData + "[j]){\nresult.push(" + optionData + "[i].name);\n}\n}\n}\nreturn result;\n}()");
                return data;
            }
        }
        return this.getValueData();
    }

    private ComponentData getValueLabelData(String dataItem) throws LcdpException {
        ComponentData data = new ComponentData();
        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        String optionData = this.getOptionData().getRenderValue();
        if ("label".equals(dataItem)) {
            data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i].name);\n}\nreturn flag;}()");
        } else {
            data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i].value);\n}\nreturn flag;}()");
        }
        return data;
    }

    private ComponentData getOptionData() throws LcdpException {
        ComponentData optionData = new ComponentData();
        ArrayList<String> optionDataItem = new ArrayList<String>();
        optionDataItem.add("data");
        optionData.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        optionData.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
        optionData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._OPTION.getType(), optionDataItem));
        return optionData;
    }

    private ComponentData getValueData() throws LcdpException {
        ComponentData optionData = new ComponentData();
        ArrayList<String> optionDataItem = new ArrayList<String>();
        optionDataItem.add("value");
        optionData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        optionData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), optionDataItem));
        return optionData;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return Collections.singletonList(new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("value"))));
    }
}

