/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.speedcode.common.constant.CodePrefix;
import com.jxdinfo.hussar.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.file.FileMappingService;
import com.jxdinfo.hussar.speedcode.common.util.RenderUtil;
import com.jxdinfo.hussar.speedcode.common.util.SpringUtil;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.speedcode.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.speedcode.common.utils.EventUtil;
import com.jxdinfo.hussar.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.speedcode.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LineEchartVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/lineEchart/line_echart.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealHiddenAttr(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String instanceKey = lcdpComponent.getInstanceKey();
        Integer height = lcdpComponent.getHeight();
        Integer width = lcdpComponent.getWidth();
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderTop"))) {
            String borderTop = String.valueOf(lcdpComponent.getStyles().get("borderTop"));
            ctx.addData(instanceKey + "BorderTop: " + borderTop.substring(0, borderTop.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderBottom"))) {
            String borderBottom = String.valueOf(lcdpComponent.getStyles().get("borderBottom"));
            ctx.addData(instanceKey + "BorderBottom: " + borderBottom.substring(0, borderBottom.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderLeft"))) {
            String borderLeft = String.valueOf(lcdpComponent.getStyles().get("borderLeft"));
            ctx.addData(instanceKey + "BorderLeft: " + borderLeft.substring(0, borderLeft.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderRight"))) {
            String borderRight = String.valueOf(lcdpComponent.getStyles().get("borderRight"));
            ctx.addData(instanceKey + "BorderRight: " + borderRight.substring(0, borderRight.indexOf("px")));
        }
        ctx.addData(instanceKey + "Width: " + width);
        ctx.addData(instanceKey + "Height: " + height);
        ctx.addData(instanceKey + "Data: null");
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        Map echartsMaps;
        HashMap<String, CharSequence> echartsParams = new HashMap<String, CharSequence>();
        echartsParams.put("instanceKey", lcdpComponent.getInstanceKey());
        String optionData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION_DATA.getType(), Collections.singletonList("data"), (String)"{\nxAxisData: [],\nyAxisData: [],\nbrokenColor: [],\nlegendData: [],\n}");
        echartsParams.put("optionData", CodePrefix._SELF.getType() + optionData);
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            echartsParams.put("isQuoteOrGetValue", "true");
        }
        if (ToolUtil.isNotEmpty((Object)(echartsMaps = lcdpComponent.getProps()))) {
            echartsParams.put("titleText", (CharSequence)echartsMaps.get("title"));
            echartsParams.put("titleColor", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("titleColor")) ? echartsMaps.get("titleColor") : "#000"));
            echartsParams.put("titleFontSize", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("titleFontSize")) ? echartsMaps.get("titleFontSize") : "18"));
            echartsParams.put("fontFamily", (CharSequence)echartsMaps.get("fontFamily"));
            echartsParams.put("fontStyle", (CharSequence)echartsMaps.get("fontStyle"));
            echartsParams.put("fontWeight", (CharSequence)echartsMaps.get("fontWeight"));
            echartsParams.put("titleAlign", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("titleAlign")) ? echartsMaps.get("titleAlign") : "left"));
            echartsParams.put("numberOfRow", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("numberOfRow")) ? echartsMaps.get("numberOfRow") : "10"));
            echartsParams.put("xAxisName", (CharSequence)echartsMaps.get("xAxisName"));
            echartsParams.put("yAxisName", (CharSequence)echartsMaps.get("yAxisName"));
            echartsParams.put("nameLocation", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("nameLocation")) ? echartsMaps.get("nameLocation") : "end"));
            echartsParams.put("xyColor", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("xyColor")) ? echartsMaps.get("xyColor") : "#909399"));
            echartsParams.put("xyFontSize", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("xyFontSize")) ? echartsMaps.get("xyFontSize") : "14"));
            echartsParams.put("xyFontFamily", (CharSequence)echartsMaps.get("xyFontFamily"));
            echartsParams.put("xyFontWeight", (CharSequence)echartsMaps.get("xyFontWeight"));
            echartsParams.put("xyFontStyle", (CharSequence)echartsMaps.get("xyFontStyle"));
            echartsParams.put("lineColor", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("lineColor")) ? echartsMaps.get("lineColor") : "#EBEEF5"));
            echartsParams.put("lineWidth", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("lineWidth")) ? echartsMaps.get("lineWidth") : "2"));
            echartsParams.put("xNameGap", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("xNameGap")) ? echartsMaps.get("xNameGap") : "10"));
            echartsParams.put("yNameGap", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("yNameGap")) ? echartsMaps.get("yNameGap") : "10"));
            echartsParams.put("tooltipBgColor", (CharSequence)echartsMaps.get("tooltipBgColor"));
            echartsParams.put("toolColor", (CharSequence)echartsMaps.get("toolColor"));
            echartsParams.put("toolFontSize", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("toolFontSize")) ? echartsMaps.get("toolFontSize") : "18"));
            echartsParams.put("toolFontFamily", (CharSequence)echartsMaps.get("toolFontFamily"));
            echartsParams.put("toolFontWeight", (CharSequence)echartsMaps.get("toolFontWeight"));
            echartsParams.put("toolFontStyle", (CharSequence)echartsMaps.get("toolFontStyle"));
            echartsParams.put("isShowFlag", (CharSequence)echartsMaps.get("isShowFlag"));
            echartsParams.put("smooth", (CharSequence)echartsMaps.get("smooth"));
            echartsParams.put("legendLocation", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("legendLocation")) ? echartsMaps.get("legendLocation") : "right"));
            echartsParams.put("legendColor", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("legendColor")) ? echartsMaps.get("legendColor") : "#000000"));
            echartsParams.put("legendFontSize", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("legendFontSize")) ? echartsMaps.get("legendFontSize") : "18"));
            echartsParams.put("legendFontFamily", (CharSequence)echartsMaps.get("legendFontFamily"));
            echartsParams.put("legendFontWeight", (CharSequence)echartsMaps.get("legendFontWeight"));
            echartsParams.put("legendFontStyle", (CharSequence)echartsMaps.get("legendFontStyle"));
            echartsParams.put("xPaddingTop", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("xPaddingTop")) ? echartsMaps.get("xPaddingTop") : "0"));
            echartsParams.put("xPaddingRight", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("xPaddingRight")) ? echartsMaps.get("xPaddingRight") : "0"));
            echartsParams.put("xPaddingBottom", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("xPaddingBottom")) ? echartsMaps.get("xPaddingBottom") : "0"));
            echartsParams.put("xPaddingLeft", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("xPaddingLeft")) ? echartsMaps.get("xPaddingLeft") : "0"));
            echartsParams.put("yPaddingTop", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("yPaddingTop")) ? echartsMaps.get("yPaddingTop") : "0"));
            echartsParams.put("yPaddingRight", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("yPaddingRight")) ? echartsMaps.get("yPaddingRight") : "0"));
            echartsParams.put("yPaddingBottom", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("yPaddingBottom")) ? echartsMaps.get("yPaddingBottom") : "0"));
            echartsParams.put("yPaddingLeft", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("yPaddingLeft")) ? echartsMaps.get("yPaddingLeft") : "0"));
            echartsParams.put("symbolIcon", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("symbolIcon")) ? echartsMaps.get("symbolIcon") : "emptyCircle"));
            echartsParams.put("symbolSize", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("symbolSize")) ? echartsMaps.get("symbolSize") : "3"));
            echartsParams.put("seriesLineWidth", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("seriesLineWidth")) ? echartsMaps.get("seriesLineWidth") : "2"));
            DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
            DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
            if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
                DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
                String labelField = "";
                String valueField = "";
                String legendField = "";
                if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                    for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                        List fieldAnalyses = (List)fieldList.getValue();
                        for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                            List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                            if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                labelField = dataSFieldAnalysis.getFieldName();
                            }
                            if (ToolUtil.isNotEmpty((Object)dataItemPath) && "value".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                valueField = dataSFieldAnalysis.getFieldName();
                            }
                            if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"legend".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                            legendField = dataSFieldAnalysis.getFieldName();
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
                    String sortConditionName;
                    DataSortConditionAnalysis dataSortConditionAnalysis;
                    String querySelectionName;
                    List conditionList;
                    String operationName = "hussarQuery";
                    String dataSelectId = lcdpComponent.getInstanceKey();
                    String apiFileName = "";
                    String apiFilePath = "";
                    String dataModelId = dataSModelAnalysis.getDataModelId();
                    if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                        apiFileName = this.fileMappingService.getFileName(dataModelId);
                        apiFilePath = this.fileMappingService.getImportPath(dataModelId);
                    }
                    if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                        echartsParams.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                        echartsParams.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                    }
                    if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                        operationName = operationName + querySelectionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                        operationName = operationName + sortConditionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                        EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                    }
                    echartsParams.put("importName", apiFileName);
                    echartsParams.put("importMethod", operationName);
                    echartsParams.put("xAxisCols", labelField);
                    echartsParams.put("seriesCols", valueField);
                    echartsParams.put("legendCols", legendField);
                }
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderBottom", args, RenderUtil.renderTemplate((String)"/template/elementui/element/lineEchart/line_echart_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderRight", args, RenderUtil.renderTemplate((String)"/template/elementui/element/lineEchart/line_echart_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderLeft", args, RenderUtil.renderTemplate((String)"/template/elementui/element/lineEchart/line_echart_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderTop", args, RenderUtil.renderTemplate((String)"/template/elementui/element/lineEchart/line_echart_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Height", args, RenderUtil.renderTemplate((String)"/template/elementui/element/lineEchart/line_echart_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Width", args, RenderUtil.renderTemplate((String)"/template/elementui/element/lineEchart/line_echart_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "OptionData", args, RenderUtil.renderTemplate((String)"/template/elementui/element/lineEchart/line_echart_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "EchartsData", args, RenderUtil.renderTemplate((String)"/template/elementui/element/lineEchart/line_echart_watch.ftl", echartsParams));
            ctx.addComputed(lcdpComponent.getInstanceKey() + "EchartsData", RenderUtil.renderTemplate((String)"/template/elementui/element/lineEchart/line_echart_computed.ftl", echartsParams));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"/template/elementui/element/lineEchart/line_echart_success.ftl", echartsParams));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
        }
    }
}

